/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.piggybank;

import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.io.ProtobufConverter;
import com.twitter.elephantbird.pig.util.PigUtil;
import com.twitter.elephantbird.pig.util.ProtobufToPig;
import com.twitter.elephantbird.pig.util.ProtobufTuple;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class ProtobufBytesToTuple<M extends Message>
extends EvalFunc<Tuple> {
    private TypeRef<M> typeRef_ = null;
    private ProtobufConverter<M> protoConverter_ = null;
    private final ProtobufToPig protoToPig_ = new ProtobufToPig();

    public ProtobufBytesToTuple() {
    }

    public ProtobufBytesToTuple(String protoClassName) {
        TypeRef typeRef = PigUtil.getProtobufTypeRef(protoClassName);
        this.setTypeRef(typeRef);
    }

    public void setTypeRef(TypeRef<M> typeRef) {
        this.typeRef_ = typeRef;
        this.protoConverter_ = ProtobufConverter.newInstance(typeRef);
    }

    public Tuple exec(Tuple input) throws IOException {
        if (input == null || input.size() < 1) {
            return null;
        }
        try {
            DataByteArray bytes = (DataByteArray)input.get(0);
            Message value_ = this.protoConverter_.fromBytes(bytes.get());
            return new ProtobufTuple(value_);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Schema outputSchema(Schema input) {
        return PigUtil.outputSchemaForProtobuf(this.protoToPig_, this.typeRef_);
    }
}

