/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.piggybank;

import com.google.common.collect.Maps;
import com.twitter.elephantbird.pig.util.PigCounterHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonStringToMap
extends EvalFunc<Map<String, String>> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonStringToMap.class);
    private final JSONParser jsonParser = new JSONParser();
    private final PigCounterHelper counterHelper = new PigCounterHelper();

    public Schema outputSchema(Schema input) {
        try {
            return Utils.getSchemaFromString((String)"json: [chararray]");
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> exec(Tuple input) throws IOException {
        try {
            if (input == null || input.size() < 1) {
                throw new IOException("Not enough arguments to " + ((Object)((Object)this)).getClass().getName() + ": got " + input.size() + ", expected at least 1");
            }
            if (input.get(0) == null) {
                this.counterHelper.incrCounter(((Object)((Object)this)).getClass().getName(), "NullJsonString", 1L);
                return null;
            }
            String jsonLiteral = (String)input.get(0);
            return this.parseStringToMap(jsonLiteral);
        }
        catch (ExecException e) {
            LOG.warn("Error in " + ((Object)((Object)this)).getClass() + " with input " + input, (Throwable)e);
            throw new IOException(e);
        }
    }

    protected Map<String, String> parseStringToMap(String line) {
        try {
            HashMap values = Maps.newHashMap();
            JSONObject jsonObj = (JSONObject)this.jsonParser.parse(line);
            for (Object key : jsonObj.keySet()) {
                Object value = jsonObj.get(key);
                values.put(key.toString(), value != null ? value.toString() : null);
            }
            return values;
        }
        catch (ParseException e) {
            LOG.warn("Could not json-decode string: " + line, (Throwable)e);
            return null;
        }
        catch (NumberFormatException e) {
            LOG.warn("Very big number exceeds the scale of long: " + line, (Throwable)e);
            return null;
        }
    }
}

