/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.google.common.collect.Lists;
import com.twitter.elephantbird.mapreduce.input.IntegerListInputFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.StorageUtil;
import org.apache.pig.impl.util.UDFContext;

public class LocationAsTuple
extends LoadFunc
implements LoadMetadata {
    public static final String DATA_PROP = "data";
    final byte token;
    boolean returned = false;
    private String signature;

    public LocationAsTuple() {
        this("\t");
    }

    public LocationAsTuple(String s) {
        this.token = StorageUtil.parseFieldDel((String)s);
    }

    public InputFormat getInputFormat() throws IOException {
        return new IntegerListInputFormat();
    }

    public Tuple getNext() throws IOException {
        if (!this.returned) {
            this.returned = true;
            String dataString = this.getUDFProperties().getProperty(DATA_PROP);
            LinkedList tups = Lists.newLinkedList();
            int offset = 0;
            for (int i = 0; i < dataString.length(); ++i) {
                if (dataString.charAt(i) != this.token) continue;
                tups.add(dataString.substring(offset, i));
                offset = i + 1;
            }
            tups.add(dataString.substring(offset, dataString.length()));
            return TupleFactory.getInstance().newTupleNoCopy((List)tups);
        }
        return null;
    }

    public void setUDFContextSignature(String signature) {
        this.signature = signature;
    }

    public String relativeToAbsolutePath(String location, Path curDir) throws IOException {
        return location;
    }

    public void setLocation(String location, Job job) throws IOException {
        Properties p = this.getUDFProperties();
        p.setProperty(DATA_PROP, location);
    }

    private Properties getUDFProperties() {
        return UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
    }

    public void prepareToRead(RecordReader arg0, PigSplit arg1) throws IOException {
    }

    public ResourceSchema getSchema(String filename, Job job) throws IOException {
        ArrayList fieldSchemas = Lists.newArrayList();
        for (int i = 0; i < filename.length(); ++i) {
            if (filename.charAt(i) != this.token) continue;
            Schema.FieldSchema fieldSchema = new Schema.FieldSchema(null, 55);
            fieldSchemas.add(fieldSchema);
        }
        Schema.FieldSchema fieldSchema = new Schema.FieldSchema(null, 55);
        fieldSchemas.add(fieldSchema);
        return new ResourceSchema(new Schema((List)fieldSchemas));
    }

    public String[] getPartitionKeys(String arg0, Job arg1) throws IOException {
        return null;
    }

    public ResourceStatistics getStatistics(String arg0, Job arg1) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression arg0) throws IOException {
    }
}

