/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.examples;

import com.twitter.elephantbird.examples.proto.AddressBookProtos;
import com.twitter.elephantbird.mapreduce.input.MultiInputFormat;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoneNumberCounter
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(PhoneNumberCounter.class);

    private PhoneNumberCounter() {
    }

    public int run(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: hadoop jar path/to/this.jar " + ((Object)((Object)this)).getClass() + " <input dir> <output dir>");
            System.exit(1);
        }
        Configuration conf = this.getConf();
        Job job = new Job(conf);
        job.setJobName("Protobuf Person Phone Number Counter");
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(LongWritable.class);
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setMapperClass(PhoneNumberCounterMapper.class);
        job.setCombinerClass(PhoneNumberCounterReducer.class);
        job.setReducerClass(PhoneNumberCounterReducer.class);
        MultiInputFormat.setClassConf(AddressBookProtos.Person.class, (Configuration)conf);
        job.setInputFormatClass(MultiInputFormat.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new PhoneNumberCounter(), (String[])args);
        System.exit(exitCode);
    }

    public static class PhoneNumberCounterReducer
    extends Reducer<Text, Text, Text, LongWritable> {
        private final LongWritable count_ = new LongWritable();

        protected void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            int count = 0;
            for (Text phoneNumber : values) {
                ++count;
            }
            this.count_.set((long)count);
            context.write((Object)key, (Object)this.count_);
        }
    }

    public static class PhoneNumberCounterMapper
    extends Mapper<LongWritable, ProtobufWritable<AddressBookProtos.Person>, Text, Text> {
        private final Text name_ = new Text();
        private final Text phoneNumber_ = new Text();

        protected void map(LongWritable key, ProtobufWritable<AddressBookProtos.Person> value, Mapper.Context context) throws IOException, InterruptedException {
            AddressBookProtos.Person p = (AddressBookProtos.Person)((Object)value.get());
            this.name_.set(p.getName());
            for (AddressBookProtos.Person.PhoneNumber phoneNumber : p.getPhoneList()) {
                this.phoneNumber_.set(phoneNumber.getNumber());
                context.write((Object)this.name_, (Object)this.phoneNumber_);
            }
        }
    }
}

