/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.chill.java;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.twitter.chill.IKryoRegistrar;
import com.twitter.chill.SingleRegistrar;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.BitSet;

public class BitSetSerializer
extends Serializer<BitSet>
implements Serializable {
    private static final Field wordsField;
    private static final Constructor<BitSet> bitSetConstructor;
    private static final Method recalculateWordsInUseMethod;

    public static IKryoRegistrar registrar() {
        return new SingleRegistrar<BitSet>(BitSet.class, new BitSetSerializer());
    }

    public void write(Kryo kryo, Output output, BitSet bitSet) {
        long[] lArray = null;
        try {
            lArray = (long[])wordsField.get(bitSet);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new KryoException("Error while accessing field 'words' of bitSet", (Throwable)illegalAccessException);
        }
        output.writeInt(lArray.length, true);
        for (int i = 0; i < lArray.length; ++i) {
            output.writeLong(lArray[i]);
        }
    }

    public BitSet read(Kryo kryo, Input input, Class<BitSet> clazz) {
        int n = input.readInt(true);
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = input.readLong();
        }
        BitSet bitSet = null;
        try {
            bitSet = bitSetConstructor.newInstance(new Object[]{lArray});
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new KryoException("Unable to call BitSet(long[]) constructor", (Throwable)reflectiveOperationException);
        }
        try {
            recalculateWordsInUseMethod.invoke((Object)bitSet, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new KryoException("Unable to call BitSet.recalculateWordsInUse() method", (Throwable)reflectiveOperationException);
        }
        return bitSet;
    }

    static {
        try {
            wordsField = BitSet.class.getDeclaredField("words");
            wordsField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new KryoException("Error while getting field 'words' of bitSet", (Throwable)noSuchFieldException);
        }
        try {
            bitSetConstructor = BitSet.class.getDeclaredConstructor(long[].class);
            bitSetConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new KryoException("Unable to get BitSet(long[]) constructor", (Throwable)noSuchMethodException);
        }
        try {
            recalculateWordsInUseMethod = BitSet.class.getDeclaredMethod("recalculateWordsInUse", new Class[0]);
            recalculateWordsInUseMethod.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new KryoException("Unable to get BitSet.recalculateWordsInUse() method", (Throwable)noSuchMethodException);
        }
    }
}

