/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.util;

import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.util.WtcString;
import com.twistpair.wave.thinclient.xml.WtcDocumentBuilderFactoryPlatform;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WtcXml {
    private static final String TAG = WtcLog.TAG(WtcXml.class);

    public static Element toXmlDoc(String text) throws WtcXmlException {
        Document doc;
        WtcDocumentBuilderFactoryPlatform.WtcDocumentBuilderPlatform docBuilder;
        if (WtcString.isNullOrEmpty(text)) {
            return null;
        }
        WtcDocumentBuilderFactoryPlatform docFactory = WtcDocumentBuilderFactoryPlatform.newInstance();
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            WtcLog.error(TAG, "EXCEPTION: toXmlDoc docFactory.newDocumentBuilder()", e);
            throw new WtcXmlException(e, text);
        }
        ByteArrayInputStream xmlStream = new ByteArrayInputStream(text.getBytes());
        try {
            doc = docBuilder.parse(xmlStream);
        }
        catch (SAXException e) {
            WtcLog.error(TAG, "EXCEPTION: toXmlDoc docBuilder.parse(xmlStream)", e);
            throw new WtcXmlException(e, text);
        }
        catch (IOException e) {
            WtcLog.error(TAG, "EXCEPTION: toXmlDoc docBuilder.parse(xmlStream)", e);
            throw new WtcXmlException(e, text);
        }
        return doc.getDocumentElement();
    }

    public static class WtcXmlException
    extends Exception {
        private static final long serialVersionUID = 3479626558974922759L;
        public final Exception innerException;
        public final String text;

        private WtcXmlException(Exception innerException, String text) {
            this.innerException = innerException;
            this.text = text;
        }

        @Override
        public String toString() {
            return this.innerException.toString();
        }
    }
}

