/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.util;

import com.twistpair.wave.thinclient.util.WtcString;

public class WtcVersionString {
    private final int major;
    private final int minor;
    private final int build;
    private final int revision;

    public WtcVersionString(String versionString) {
        String[] versionParts = WtcString.split(versionString, ".", 0);
        if (versionParts.length != 4) {
            throw new IllegalArgumentException("versionString must be of format \"1.2.3.4\"");
        }
        this.major = Integer.parseInt(versionParts[0]);
        this.minor = Integer.parseInt(versionParts[1]);
        this.build = Integer.parseInt(versionParts[2]);
        this.revision = Integer.parseInt(versionParts[3]);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBuild() {
        return this.build;
    }

    public int getRevision() {
        return this.revision;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.build + "." + this.revision;
    }

    public int compare(Object o) {
        if (!(o instanceof WtcVersionString)) {
            throw new IllegalArgumentException("Argument must be of type VersionString");
        }
        return this.compare((WtcVersionString)o);
    }

    public int compare(WtcVersionString o) {
        if (o == null) {
            return 1;
        }
        if (this.revision != o.revision) {
            if (this.revision > o.revision) {
                return 1;
            }
            return -1;
        }
        if (this.major != o.major) {
            if (this.major > o.major) {
                return 1;
            }
            return -1;
        }
        if (this.minor != o.minor) {
            if (this.minor > o.minor) {
                return 1;
            }
            return -1;
        }
        if (this.build != o.build) {
            if (this.build > o.build) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.build;
        result = 31 * result + this.revision;
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WtcVersionString)) {
            throw new IllegalArgumentException("Argument must be of type VersionString");
        }
        return this.equals((WtcVersionString)o);
    }

    public boolean equals(WtcVersionString o) {
        return this.compare(o) == 0;
    }

    public boolean greaterThan(WtcVersionString o) {
        return this.compare(o) == 1;
    }

    public boolean lessThan(WtcVersionString o) {
        return this.compare(o) == -1;
    }
}

