/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.widget.TextView;
import android.widget.Toast;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.util.WtcString;
import java.util.Iterator;
import java.util.Set;

public class WtcUtilsPlatform {
    private static final SparseArray<String> TOOL_TYPE_SYMBOLIC_NAMES = new SparseArray();
    private static final String[] BUTTON_SYMBOLIC_NAMES;
    private static final String[] META_SYMBOLIC_NAMES;

    public static void toastLong(Context context, int resId) {
        WtcUtilsPlatform.toast(context, resId, 1);
    }

    public static void toastLong(Context context, String text) {
        WtcUtilsPlatform.toast(context, text, 1);
    }

    public static void toastShort(Context context, int resId) {
        WtcUtilsPlatform.toast(context, resId, 0);
    }

    public static void toastShort(Context context, String text) {
        WtcUtilsPlatform.toast(context, text, 0);
    }

    public static void toast(Context context, int resId, int duration) {
        if (resId != -1) {
            Toast.makeText((Context)context, (int)resId, (int)duration).show();
        }
    }

    public static void toast(Context context, String text, int duration) {
        if (!WtcString.isNullOrEmpty(text)) {
            Toast.makeText((Context)context, (CharSequence)text, (int)duration).show();
        }
    }

    public static void toggleViewText(TextView view, boolean condition, int residTrue, int residFalse) {
        view.setText(condition ? residTrue : residFalse);
    }

    public static boolean equals(Class<?> a, Class<?> b) {
        return a.getCanonicalName().equals(b.getCanonicalName());
    }

    public static String getMetaDataString(Context context, String key) {
        PackageManager packageManager = context.getPackageManager();
        String packageName = context.getPackageName();
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = packageManager.getApplicationInfo(packageName, 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        Bundle metaDataBundle = applicationInfo.metaData;
        String value = metaDataBundle.getString(key);
        return value;
    }

    public static String toString(Intent intent) {
        if (intent == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(intent.toString());
        Bundle bundle = intent.getExtras();
        sb.append(", extras=").append(WtcUtilsPlatform.toString(bundle));
        return sb.toString();
    }

    public static String toString(Bundle bundle) {
        if (bundle == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        Set keys = bundle.keySet();
        Iterator it = keys.iterator();
        sb.append('{');
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = bundle.get(key);
            sb.append(WtcString.quote(key)).append('=').append(WtcString.quote(value));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    public static void logMotionEvent(String tag, String message, MotionEvent event) {
        int action = event.getAction();
        StringBuilder sb = new StringBuilder();
        if (!WtcString.isNullOrEmpty(message)) {
            sb.append(message).append(' ');
        }
        sb.append("MotionEvent { action=").append(WtcUtilsPlatform.actionToString(action));
        int pointerCount = event.getPointerCount();
        for (int i = 0; i < pointerCount; ++i) {
            sb.append(", id[").append(i).append("]=").append(event.getPointerId(i));
            sb.append(", x[").append(i).append("]=").append(event.getX(i));
            sb.append(", y[").append(i).append("]=").append(event.getY(i));
            sb.append(", toolType[").append(i).append("]=").append(WtcUtilsPlatform.toolTypeToString(event.getToolType(i)));
        }
        sb.append(", buttonState=").append(WtcUtilsPlatform.buttonStateToString(event.getButtonState()));
        sb.append(", metaState=").append(WtcUtilsPlatform.metaStateToString(event.getMetaState()));
        sb.append(", flags=0x").append(Integer.toHexString(event.getFlags()));
        sb.append(", edgeFlags=0x").append(Integer.toHexString(event.getEdgeFlags()));
        sb.append(", pointerCount=").append(pointerCount);
        sb.append(", historySize=").append(event.getHistorySize());
        sb.append(", eventTime=").append(event.getEventTime());
        sb.append(", downTime=").append(event.getDownTime());
        sb.append(", deviceId=").append(event.getDeviceId());
        sb.append(", source=0x").append(Integer.toHexString(event.getSource()));
        sb.append(" }");
        WtcLog.info(tag, sb.toString());
    }

    public static String actionToString(int action) {
        switch (action) {
            case 0: {
                return "ACTION_DOWN";
            }
            case 1: {
                return "ACTION_UP";
            }
            case 3: {
                return "ACTION_CANCEL";
            }
            case 4: {
                return "ACTION_OUTSIDE";
            }
            case 2: {
                return "ACTION_MOVE";
            }
            case 7: {
                return "ACTION_HOVER_MOVE";
            }
            case 8: {
                return "ACTION_SCROLL";
            }
            case 9: {
                return "ACTION_HOVER_ENTER";
            }
            case 10: {
                return "ACTION_HOVER_EXIT";
            }
        }
        int index = (action & 0xFF00) >> 8;
        switch (action & 0xFF) {
            case 5: {
                return "ACTION_POINTER_DOWN(" + index + ")";
            }
            case 6: {
                return "ACTION_POINTER_UP(" + index + ")";
            }
        }
        return Integer.toString(action);
    }

    public static String toolTypeToString(int toolType) {
        String symbolicName = (String)TOOL_TYPE_SYMBOLIC_NAMES.get(toolType);
        return symbolicName != null ? symbolicName : Integer.toString(toolType);
    }

    public static String buttonStateToString(int buttonState) {
        if (buttonState == 0) {
            return "0";
        }
        StringBuilder result = null;
        int i = 0;
        while (buttonState != 0) {
            boolean isSet = (buttonState & 1) != 0;
            buttonState >>>= 1;
            if (isSet) {
                String name = BUTTON_SYMBOLIC_NAMES[i];
                if (result == null) {
                    if (buttonState == 0) {
                        return name;
                    }
                    result = new StringBuilder(name);
                } else {
                    result.append('|');
                    result.append(name);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String metaStateToString(int metaState) {
        if (metaState == 0) {
            return "0";
        }
        StringBuilder result = null;
        int i = 0;
        while (metaState != 0) {
            boolean isSet = (metaState & 1) != 0;
            metaState >>>= 1;
            if (isSet) {
                String name = META_SYMBOLIC_NAMES[i];
                if (result == null) {
                    if (metaState == 0) {
                        return name;
                    }
                    result = new StringBuilder(name);
                } else {
                    result.append('|');
                    result.append(name);
                }
            }
            ++i;
        }
        return result.toString();
    }

    static {
        SparseArray<String> names = TOOL_TYPE_SYMBOLIC_NAMES;
        names.append(0, (Object)"TOOL_TYPE_UNKNOWN");
        names.append(1, (Object)"TOOL_TYPE_FINGER");
        names.append(2, (Object)"TOOL_TYPE_STYLUS");
        names.append(3, (Object)"TOOL_TYPE_MOUSE");
        names.append(4, (Object)"TOOL_TYPE_ERASER");
        BUTTON_SYMBOLIC_NAMES = new String[]{"BUTTON_PRIMARY", "BUTTON_SECONDARY", "BUTTON_TERTIARY", "BUTTON_BACK", "BUTTON_FORWARD", "0x00000020", "0x00000040", "0x00000080", "0x00000100", "0x00000200", "0x00000400", "0x00000800", "0x00001000", "0x00002000", "0x00004000", "0x00008000", "0x00010000", "0x00020000", "0x00040000", "0x00080000", "0x00100000", "0x00200000", "0x00400000", "0x00800000", "0x01000000", "0x02000000", "0x04000000", "0x08000000", "0x10000000", "0x20000000", "0x40000000", "0x80000000"};
        META_SYMBOLIC_NAMES = new String[]{"META_SHIFT_ON", "META_ALT_ON", "META_SYM_ON", "META_FUNCTION_ON", "META_ALT_LEFT_ON", "META_ALT_RIGHT_ON", "META_SHIFT_LEFT_ON", "META_SHIFT_RIGHT_ON", "META_CAP_LOCKED", "META_ALT_LOCKED", "META_SYM_LOCKED", "0x00000800", "META_CTRL_ON", "META_CTRL_LEFT_ON", "META_CTRL_RIGHT_ON", "0x00008000", "META_META_ON", "META_META_LEFT_ON", "META_META_RIGHT_ON", "0x00080000", "META_CAPS_LOCK_ON", "META_NUM_LOCK_ON", "META_SCROLL_LOCK_ON", "0x00800000", "0x01000000", "0x02000000", "0x04000000", "0x08000000", "0x10000000", "0x20000000", "0x40000000", "0x80000000"};
    }
}

