/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.util;

import com.twistpair.wave.thinclient.util.BitSetPlatform;
import com.twistpair.wave.thinclient.util.WtcMemoryStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class WtcString {
    public static final String WtcpEncoding = "utf-8";
    public static final byte[] EMPTY = new byte[]{0};

    private WtcString() {
    }

    public static byte[] getBytes(String value) {
        try {
            return value.getBytes(WtcpEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Should never happen as long as WtcpEncoding is valid");
        }
    }

    public static String getString(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, WtcpEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0 || value == "";
    }

    public static String fromNullTerminatedBytes(byte[] bytes, int offset) {
        if (bytes == null) {
            return null;
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be >= 0");
        }
        int length = 0;
        while (offset + length < bytes.length && bytes[offset + length] != 0) {
            ++length;
        }
        if (length == 0) {
            return null;
        }
        return new String(bytes, offset, length);
    }

    public static byte[] toNullTerminatedBytes(String s) {
        byte[] temp = s.getBytes();
        byte[] bytes = new byte[temp.length + 1];
        System.arraycopy(temp, 0, bytes, 0, bytes.length - 1);
        return bytes;
    }

    public static String toHexString(byte[] bytes) {
        return WtcString.toHexString(bytes, true);
    }

    public static String toHexString(byte[] bytes, boolean asByteArray) {
        if (bytes == null) {
            return "";
        }
        return WtcString.toHexString(bytes, 0, bytes.length, asByteArray);
    }

    public static String toHexString(byte[] bytes, int offset, int count) {
        return WtcString.toHexString(bytes, offset, count, true);
    }

    public static String toHexString(byte[] bytes, int offset, int count, boolean asByteArray) {
        if (bytes == null) {
            return "";
        }
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer sb = new StringBuffer();
        if (asByteArray) {
            for (int i = offset; i < count; ++i) {
                if (i != offset) {
                    sb.append('-');
                }
                sb.append(hexChars[(bytes[i] & 0xF0) >> 4]);
                sb.append(hexChars[bytes[i] & 0xF]);
            }
        } else {
            for (int i = count - 1; i >= 0; --i) {
                sb.append(hexChars[(bytes[i] & 0xF0) >> 4]);
                sb.append(hexChars[bytes[i] & 0xF]);
            }
        }
        return sb.toString();
    }

    public static String toHexString(short value, int maxLength) {
        return WtcString.toHexString(WtcMemoryStream.getBytes(value), 0, maxLength, false);
    }

    public static String toHexString(int value, int maxLength) {
        return WtcString.toHexString(WtcMemoryStream.getBytes(value), 0, maxLength, false);
    }

    public static String toHexString(long value, int maxLength) {
        return WtcString.toHexString(WtcMemoryStream.getBytes(value), 0, maxLength, false);
    }

    public static String toHexString(String value) {
        return WtcString.toHexString(value.getBytes());
    }

    public static String toBitString(byte[] bytes, int maxBits, int spaceEvery) {
        BitSetPlatform bits = new BitSetPlatform(bytes);
        maxBits = Math.max(0, Math.min(maxBits, bits.getLength()));
        StringBuffer sb = new StringBuffer();
        for (int i = maxBits - 1; i >= 0; --i) {
            sb.append(bits.get(i) ? (char)'1' : '0');
            if (spaceEvery == 0 || i <= 0 || i % spaceEvery != 0) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String toBitString(byte value, int maxBits) {
        return WtcString.toBitString(new byte[]{value}, maxBits, 0);
    }

    public static String toBitString(short value, int maxBits) {
        return WtcString.toBitString(value, maxBits, 8);
    }

    public static String toBitString(short value, int maxBits, int spaceEvery) {
        return WtcString.toBitString(WtcMemoryStream.getBytes(value), maxBits, spaceEvery);
    }

    public static String toBitString(int value, int maxBits) {
        return WtcString.toBitString(value, maxBits, 8);
    }

    public static String toBitString(int value, int maxBits, int spaceEvery) {
        return WtcString.toBitString(WtcMemoryStream.getBytes(value), maxBits, spaceEvery);
    }

    public static String toBitString(long value, int maxBits) {
        return WtcString.toBitString(value, maxBits, 8);
    }

    public static String toBitString(long value, int maxBits, int spaceEvery) {
        return WtcString.toBitString(WtcMemoryStream.getBytes(value), maxBits, spaceEvery);
    }

    public static char toChar(boolean value) {
        return value ? (char)'1' : '0';
    }

    public static String padNumber(long number, char ch, int minimumLength) {
        String s = String.valueOf(number);
        while (s.length() < minimumLength) {
            s = ch + s;
        }
        return s;
    }

    public static String formatNumber(long number, int minimumLength) {
        return WtcString.padNumber(number, '0', minimumLength);
    }

    public static String formatNumber(double number, int leading, int trailing) {
        if (number == Double.NaN || number == Double.NEGATIVE_INFINITY || number == Double.POSITIVE_INFINITY) {
            return String.valueOf(number);
        }
        String[] parts = WtcString.split(String.valueOf(number), ".", 0);
        while (parts[0].length() < leading) {
            parts[0] = '0' + parts[0];
        }
        while (parts[1].length() < trailing) {
            parts[1] = parts[1] + '0';
        }
        parts[1] = parts[1].substring(0, trailing);
        return parts[0] + '.' + parts[1];
    }

    public static String plurality(int count) {
        return count == 1 ? "" : "s";
    }

    public static String plurality(String name, int count) {
        return name + WtcString.plurality(count);
    }

    public static String[] split(String source, String separator, int limit) {
        String value;
        if (WtcString.isNullOrEmpty(source) || WtcString.isNullOrEmpty(separator)) {
            return new String[]{source};
        }
        int indexB = source.indexOf(separator);
        if (indexB == -1) {
            return new String[]{source};
        }
        int indexA = 0;
        Vector<String> values = new Vector<String>();
        while (indexB != -1 && (limit < 1 || values.size() < limit - 1)) {
            value = source.substring(indexA, indexB);
            if (!WtcString.isNullOrEmpty(value) || limit < 0) {
                values.addElement(value);
            }
            indexA = indexB + separator.length();
            indexB = source.indexOf(separator, indexA);
        }
        indexB = source.length();
        value = source.substring(indexA, indexB);
        if (!WtcString.isNullOrEmpty(value) || limit < 0) {
            values.addElement(value);
        }
        Object[] result = new String[values.size()];
        values.copyInto(result);
        return result;
    }

    public static String replace(String source, String pattern, String replacement) {
        return WtcString.replace(source, pattern, replacement, -1);
    }

    public static String replaceFirst(String source, String pattern, String replacement) {
        return WtcString.replace(source, pattern, replacement, 1);
    }

    public static String replace(String source, String pattern, String replacement, int limit) {
        if (source == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int index = -1;
        int fromIndex = 0;
        for (int count = 0; (index = source.indexOf(pattern, fromIndex)) != -1 && (limit == -1 || count < limit); ++count) {
            sb.append(source.substring(fromIndex, index));
            sb.append(replacement);
            fromIndex = index + pattern.length();
        }
        sb.append(source.substring(fromIndex));
        return sb.toString();
    }

    public static boolean contains(String s, String cs) {
        return s.indexOf(cs) != -1;
    }

    public static String getTimeElapsedString(long msElapsed) {
        long h = (int)(msElapsed / 3600000L);
        long m = (int)((msElapsed -= h * 3600L * 1000L) / 60000L);
        long s = (int)((msElapsed -= m * 60L * 1000L) / 1000L);
        return WtcString.formatNumber(h, 2) + ":" + WtcString.formatNumber(m, 2) + ":" + WtcString.formatNumber(s, 2) + "." + WtcString.formatNumber(msElapsed -= s * 1000L, 3);
    }

    public static String getShortClassName(String className) {
        if (WtcString.isNullOrEmpty(className)) {
            return "null";
        }
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public static String getShortClassName(Object o) {
        Class<?> c = o == null ? null : o.getClass();
        return WtcString.getShortClassName(c);
    }

    public static String getShortClassName(Class c) {
        String className = c == null ? null : c.getName();
        return WtcString.getShortClassName(className);
    }

    public static String getMethodName(String methodName) {
        if (methodName == null) {
            methodName = "()";
        }
        if (methodName.compareTo("()") != 0) {
            methodName = "." + methodName;
        }
        return methodName;
    }

    public static String getShortClassAndMethodName(Object o, String methodName) {
        return WtcString.getShortClassName(o) + WtcString.getMethodName(methodName);
    }

    public static String quote(Object value) {
        return WtcString.repr(value, false);
    }

    public static String repr(Object value) {
        return WtcString.repr(value, false);
    }

    public static String repr(Object value, boolean typeOnly) {
        return value == null ? "null" : (value instanceof String ? '\"' + value.toString() + '\"' : (typeOnly ? WtcString.getShortClassName(value) : value.toString()));
    }

    public static String toString(Object[] items) {
        StringBuffer sb = new StringBuffer();
        if (items == null) {
            sb.append("null");
        } else {
            sb.append('[');
            for (int i = 0; i < items.length; ++i) {
                Object item = items[i];
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(WtcString.quote(item));
            }
            sb.append(']');
        }
        return sb.toString();
    }

    public static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    public static String toFlagString(Vector flags) {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int i = 0; i < flags.size(); ++i) {
            String flag = (String)flags.elementAt(i);
            if (i != 0) {
                sb.append('|');
            }
            sb.append(flag);
        }
        sb.append(')');
        return sb.toString();
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str1 == str2 : str1.equals(str2);
    }
}

