/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.util;

import com.twistpair.wave.thinclient.logging.WtcLog;
import java.util.NoSuchElementException;

public class WtcArrayQueue {
    private static final String TAG = WtcLog.TAG(WtcArrayQueue.class);
    private final String name;
    private Object[] queue;
    private int head;
    private int tail;
    private int maxSizeCurrent;
    private int maxSizeLifetime;

    public WtcArrayQueue(String name) {
        this.name = name;
        this.clear();
    }

    public void maintenance(boolean clear) {
        if (clear) {
            this.clear();
        } else {
            WtcLog.info(TAG, '$' + this.name + " maintenance: size=" + this.size() + ", capacity=" + this.capacity() + ", maxCurrent=" + this.maxSizeCurrent + ", maxLifetime=" + this.maxSizeLifetime);
        }
    }

    public void clear() {
        WtcLog.debug(TAG, '$' + this.name + " +clear(); size=" + this.size() + ", capacity=" + this.capacity() + ", maxCurrent=" + this.maxSizeCurrent + ", maxLifetime=" + this.maxSizeLifetime);
        this.queue = new Object[1];
        this.head = 0;
        this.tail = 0;
        this.maxSizeCurrent = 0;
        WtcLog.debug(TAG, '$' + this.name + " -clear(); size=" + this.size() + ", capacity=" + this.capacity() + ", maxCurrent=" + this.maxSizeCurrent + ", maxLifetime=" + this.maxSizeLifetime);
    }

    protected int capacity() {
        return this.queue == null ? 0 : this.queue.length;
    }

    public int size() {
        return this.queue == null ? 0 : this.tail - this.head & this.queue.length - 1;
    }

    public boolean isEmpty() {
        return this.tail == this.head;
    }

    public boolean add(Object element) {
        if (element == null) {
            throw new IllegalArgumentException("element cannot be null");
        }
        this.doubleCapacityIfNeeded();
        this.queue[this.tail] = element;
        this.tail = (this.tail + 1) % this.queue.length;
        int size = this.size();
        if (size > this.maxSizeCurrent) {
            this.maxSizeCurrent = size;
            if (this.maxSizeCurrent > this.maxSizeLifetime) {
                this.maxSizeLifetime = this.maxSizeCurrent;
            }
        }
        return true;
    }

    public Object remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException(TAG + ": " + this.name + ".isEmpty() == true");
        }
        Object element = this.queue[this.head];
        this.head = (this.head + 1) % this.queue.length;
        return element;
    }

    private void doubleCapacityIfNeeded() {
        int next = (this.tail + 1) % this.queue.length;
        if (next == this.head) {
            int c = this.queue.length << 1;
            Object[] values = new Object[c];
            int size = this.size();
            for (int i = 0; i != size; ++i) {
                values[i] = this.queue[(i + this.head) % this.queue.length];
            }
            this.queue = values;
            this.head = 0;
            this.tail = size;
        }
    }
}

