/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.protocol.WtcpConstants;
import com.twistpair.wave.thinclient.protocol.types.IWtcpReceivable;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcComparatorPlatform;
import com.twistpair.wave.thinclient.util.WtcString;

public class WtcpEndpointInfo
implements IWtcpReceivable {
    public static final String ID_SELF = "1";
    public static final WtcComparatorPlatform COMPARATOR = new WtcComparatorPlatform(){

        public int compare(Object a, Object b) {
            return ((WtcpEndpointInfo)a).displayName.compareTo(((WtcpEndpointInfo)b).displayName);
        }
    };
    private String id;
    private int flags;
    private String displayName;

    public WtcpEndpointInfo(IWtcMemoryStream inputStream) {
        this.loadNetworkToHostOrder(inputStream);
    }

    @Override
    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream) {
        this.id = inputStream.readString();
        this.flags = inputStream.readInt32();
        this.displayName = inputStream.readString();
    }

    public String toString() {
        return new StringBuffer().append('{').append("id=").append(WtcString.quote(this.id)).append(", flags=").append(WtcpConstants.WtcpEndpointFlags.toString(this.flags)).append(", displayName=").append(WtcString.quote(this.displayName)).append('}').toString();
    }

    public String getId() {
        return this.id;
    }

    public long getFlags() {
        return this.flags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isSpeaking() {
        return (this.flags & 2) == 2;
    }

    public boolean isVisible() {
        return (this.flags & 0x40) == 64;
    }

    public boolean isSelf() {
        return (this.flags & 0x800) == 2048;
    }

    public boolean isPoint2Point() {
        return (this.flags & 0x1000) == 4096;
    }
}

