/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.protocol.types.IWtcpReceivable;
import com.twistpair.wave.thinclient.protocol.types.IWtcpSendable;
import com.twistpair.wave.thinclient.protocol.types.WtcpList;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcInt32;
import java.util.Enumeration;

public class WtcpChannelIdList
extends WtcpList
implements IWtcpSendable,
IWtcpReceivable {
    public WtcpChannelIdList() {
        super(WtcInt32.class);
    }

    public WtcpChannelIdList(WtcpChannelIdList channelIds) {
        super(WtcInt32.class, channelIds);
    }

    public WtcpChannelIdList(int[] channelIds) {
        this();
        this.addElements(channelIds);
    }

    public WtcpChannelIdList(IWtcMemoryStream inputStream) {
        this();
        this.loadNetworkToHostOrder(inputStream);
    }

    @Override
    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream) {
        int count = inputStream.readInt16();
        for (int i = 0; i < count; ++i) {
            int id = inputStream.readInt32();
            this.addElement(WtcInt32.valueOf(id, true));
        }
    }

    @Override
    public void dumpHostToNetworkOrder(IWtcMemoryStream outputStream) {
        outputStream.writeInt16((short)this.size());
        Enumeration elements = this.elements();
        while (elements.hasMoreElements()) {
            WtcInt32 id = (WtcInt32)elements.nextElement();
            outputStream.writeInt32(id.value);
        }
    }

    public void addElements(int[] channelIds) {
        if (channelIds != null) {
            for (int i = 0; i < channelIds.length; ++i) {
                this.addElement(WtcInt32.valueOf(channelIds[i], true));
            }
        }
    }

    public boolean removeElements(int[] channelIds) {
        boolean found = false;
        if (channelIds != null) {
            for (int i = 0; i < channelIds.length; ++i) {
                found |= this.removeElement(WtcInt32.valueOf(channelIds[i], true));
            }
        }
        return found;
    }
}

