/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol.headers;

import com.twistpair.wave.thinclient.protocol.WtcpConstants;
import com.twistpair.wave.thinclient.protocol.headers.IWtcpHeader;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcString;

public class WtcpHeader
extends IWtcpHeader {
    public static final int CURRENT_VERSION = 1;
    public static final int SIZE = 4;
    public static final int SEQUENCE_NUMBER_BITS = 10;
    public static final int MAX_LENGTH = 65535;
    public static final int MAX_PAYLOAD_LENGTH = 65531;
    private int ushort0;
    private int messageInfo;

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public int getSequenceNumberBits() {
        return 10;
    }

    public long extendSequenceNumber(ExtendedNumber number) {
        int lastSequenceNumber = this.normalizeSequenceNumber(number.large);
        if (number.small < lastSequenceNumber && lastSequenceNumber - number.small > this.getSequenceNumberMaximum() / 4) {
            ++number.wraps;
        }
        number.large = number.wraps << this.getSequenceNumberBits() | number.small;
        return number.large;
    }

    public int getVersion() {
        return (byte)(((this.ushort0 & 0xE000) >> 13) + 1);
    }

    public void setVersion(int value) {
        int mask = 57344;
        this.ushort0 = this.ushort0 & ~mask | value - 1 << 13 & mask;
    }

    public byte getMessageType() {
        return (byte)((this.ushort0 & 0x1C00) >> 10);
    }

    public void setMessageType(int value) {
        int mask = 7168;
        this.ushort0 = this.ushort0 & ~mask | value << 10 & mask;
    }

    public int getSequenceNumber() {
        return (this.ushort0 & 0x3FF) >> 0;
    }

    public void setSequenceNumber(int value) {
        int mask = 1023;
        this.ushort0 = this.ushort0 & ~mask | value << 0 & mask;
    }

    public int getPayloadLength() {
        switch (this.getMessageType()) {
            case 3: 
            case 4: 
            case 5: {
                return this.messageInfo;
            }
        }
        return 0;
    }

    public void setPayloadLength(int value) {
        this.messageInfo = value;
    }

    public int getMessageInfo() {
        return this.messageInfo;
    }

    public WtcpHeader() {
        this(4);
    }

    public WtcpHeader(int messageType) {
        this(messageType, 0, 0);
    }

    public WtcpHeader(int messageType, int sequenceNumber, int messageInfo) {
        this(1, messageType, sequenceNumber, messageInfo);
    }

    public WtcpHeader(int version, int messageType, int sequenceNumber, int messageInfo) {
        this.setVersion(version);
        this.setMessageType(messageType);
        this.setSequenceNumber(sequenceNumber);
        this.messageInfo = messageInfo;
    }

    public WtcpHeader(IWtcMemoryStream buffer) {
        super(buffer);
    }

    public void copyFrom(WtcpHeader other) {
        this.ushort0 = other.ushort0;
        this.messageInfo = other.messageInfo;
    }

    @Override
    public void dumpHostToNetworkOrder(IWtcMemoryStream buffer) {
        super.dumpHostToNetworkOrder(buffer);
        buffer.writeUInt16(this.ushort0);
        buffer.writeUInt16(this.messageInfo);
    }

    @Override
    public boolean loadNetworkToHostOrder(IWtcMemoryStream buffer) {
        if (!super.loadNetworkToHostOrder(buffer)) {
            return false;
        }
        this.ushort0 = buffer.readUInt16();
        this.messageInfo = buffer.readUInt16();
        return true;
    }

    @Override
    public void reset() {
        this.messageInfo = 0;
        this.ushort0 = 0;
    }

    @Override
    public String toString(char format) {
        format = Character.toLowerCase(format);
        StringBuffer sb = new StringBuffer();
        sb.append('{').append("v=").append(WtcString.formatNumber(this.getVersion(), 1)).append(',').append("t=").append(WtcpConstants.WtcpMessageType.toString(this.getMessageType(), format));
        switch (format) {
            case 'd': {
                sb.append(",s=").append(WtcString.formatNumber(this.getSequenceNumber(), 4)).append(",i=").append(WtcString.formatNumber(this.getMessageInfo(), 5));
                break;
            }
            default: {
                sb.append(",s=0x").append(WtcString.toHexString(this.getSequenceNumber(), 2)).append(",i=0x").append(WtcString.toHexString(this.getMessageInfo(), 2));
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public static class ExtendedNumber {
        public int small = 0;
        public int wraps = 0;
        public long large = 0L;

        public void reset() {
            this.wraps = 0;
            this.small = 0;
            this.large = 0;
        }
    }
}

