/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol;

import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.protocol.WtcpMessage;
import com.twistpair.wave.thinclient.protocol.headers.WtcpControlHeader;
import com.twistpair.wave.thinclient.protocol.headers.WtcpHeader;
import com.twistpair.wave.thinclient.protocol.headers.WtcpMediaHeader;
import com.twistpair.wave.thinclient.util.WtcArrayQueue;

public class WtcpMessagePool {
    private static final String TAG = WtcLog.TAG(WtcpMessagePool.class);
    private final WtcArrayQueue pool = new WtcArrayQueue("QueueWtcpMessagePool");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintenance(boolean clear) {
        WtcArrayQueue wtcArrayQueue = this.pool;
        synchronized (wtcArrayQueue) {
            this.pool.maintenance(clear);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(WtcpMessage message) {
        WtcArrayQueue wtcArrayQueue = this.pool;
        synchronized (wtcArrayQueue) {
            this.pool.add(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WtcpMessage remove(boolean reset) {
        WtcpMessage message;
        WtcArrayQueue wtcArrayQueue = this.pool;
        synchronized (wtcArrayQueue) {
            message = (WtcpMessage)this.pool.remove();
            if (reset) {
                message.reset();
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WtcpMessage get() {
        WtcpMessage message;
        WtcArrayQueue wtcArrayQueue = this.pool;
        synchronized (wtcArrayQueue) {
            message = this.pool.size() == 0 ? new WtcpMessage() : this.remove(true);
        }
        return message;
    }

    public WtcpMessage get(WtcpHeader header) {
        WtcpMessage message = this.get();
        message.setHeader(header);
        message.stream.setPosition(header.getSize());
        return message;
    }

    public WtcpMessage get(byte messageType) {
        return this.get(new WtcpHeader(messageType, 0, 0));
    }

    public WtcpMessage get(WtcpMediaHeader headerMedia) {
        WtcpMessage message = this.get();
        message.setSubHeader(headerMedia);
        return message;
    }

    public WtcpMessage get(int opCode) {
        return this.get(opCode, null);
    }

    public WtcpMessage get(int opCode, Object[] payload) {
        return this.get(1, opCode, payload);
    }

    public WtcpMessage get(int opType, int opCode) {
        return this.get(opType, opCode, null);
    }

    public WtcpMessage get(int opType, int opCode, Object[] payload) {
        return this.get(new WtcpControlHeader(new WtcpControlHeader.WtcpVersionedOpCode(opType, opCode)), payload);
    }

    public WtcpMessage get(WtcpControlHeader controlHeader) {
        return this.get(controlHeader, null);
    }

    public WtcpMessage get(WtcpControlHeader controlHeader, Object[] payload) {
        WtcpMessage message = this.get();
        message.setSubHeader(controlHeader);
        message.payloadAppend(payload);
        return message;
    }
}

