/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.net;

import android.net.Uri;
import com.twistpair.wave.thinclient.net.WtcUri;

public class WtcUriPlatform
extends WtcUri {
    public static final WtcUriPlatform EMPTY = new WtcUriPlatform(Uri.EMPTY);
    private final Uri uri;

    public static WtcUriPlatform parse(String uriString) {
        return new WtcUriPlatform(Uri.parse((String)WtcUri.escape(uriString)));
    }

    public static boolean isNullOrEmpty(WtcUri[] uris) {
        if (uris == null || uris.length == 0) {
            return true;
        }
        for (int i = 0; i < uris.length; ++i) {
            WtcUri uri = uris[i];
            if (uri != null && uri != EMPTY) continue;
            return true;
        }
        return false;
    }

    private WtcUriPlatform(Uri uri) {
        this.uri = uri;
    }

    public String toString() {
        return this.uri.toString();
    }

    @Override
    public String getScheme() {
        return this.uri.getScheme();
    }

    @Override
    public String getHost() {
        return this.uri.getHost();
    }

    @Override
    public int getPort() {
        return this.uri.getPort();
    }

    @Override
    public String getPath() {
        return this.uri.getPath();
    }

    @Override
    public String getQueryParameter(String key) {
        return this.uri.getQueryParameter(key);
    }

    @Override
    public WtcUri.Builder buildUpon() {
        return new Builder(this.uri.buildUpon());
    }

    public static class Builder
    extends WtcUri.Builder {
        private final Uri.Builder builder;

        public Builder() {
            this(new Uri.Builder());
        }

        private Builder(Uri.Builder builder) {
            this.builder = builder;
        }

        @Override
        public WtcUri.Builder scheme(String scheme) {
            this.builder.scheme(scheme);
            return this;
        }

        @Override
        public WtcUri.Builder authority(String authority) {
            this.builder.authority(authority);
            return this;
        }

        @Override
        public WtcUri.Builder path(String path) {
            this.builder.path(path);
            return this;
        }

        @Override
        public WtcUri.Builder appendQueryParameter(String key, String value) {
            this.builder.appendQueryParameter(key, value);
            return this;
        }

        @Override
        public WtcUri build() {
            return new WtcUriPlatform(this.builder.build());
        }
    }
}

