/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.net;

import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.net.WtcInetSocketAddressPlatform;
import com.twistpair.wave.thinclient.net.WtcUri;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.regex.Pattern;

public class WtcNetworkExceptionPlatform
extends IOException {
    private static final String TAG = WtcLog.TAG(WtcNetworkExceptionPlatform.class);
    private static final long serialVersionUID = 786021788411188364L;
    public final WtcInetSocketAddressPlatform address;
    public final Exception innerException;

    public static boolean mayTryNextServer(Exception e) {
        boolean mayTryNextServer = false;
        mayTryNextServer |= e instanceof WtcNetworkUnknownHostException;
        return mayTryNextServer |= e instanceof SocketTimeoutException;
    }

    protected static boolean isIOException(Throwable e) {
        return e != null && e instanceof IOException;
    }

    protected static boolean isSocketException(Throwable e) {
        return e != null && e instanceof SocketException;
    }

    public static boolean isUnknownHostException(Exception e) {
        if (!WtcNetworkExceptionPlatform.isIOException(e)) {
            return false;
        }
        String className = e.getClass().getName().toLowerCase();
        boolean match = false;
        match |= className.equals("java.net.unknownhostexception");
        return match |= className.equals("net.rim.device.cldc.io.dns.dnsexception");
    }

    public static boolean isHostnameNotVerified(Exception e) {
        if (!WtcNetworkExceptionPlatform.isIOException(e)) {
            return false;
        }
        boolean match = false;
        String message = e.getMessage();
        if (message != null) {
            message = message.toLowerCase();
            match |= Pattern.matches("hostname <.*?> was not verified", message);
        }
        return match;
    }

    public static boolean isUnreachable(Exception e) {
        if (!WtcNetworkExceptionPlatform.isSocketException(e)) {
            return false;
        }
        if (e instanceof ConnectException) {
            return true;
        }
        String message = e.getMessage();
        if (message != null) {
            if ((message = message.toLowerCase()).contains("no route to host")) {
                return true;
            }
            if (message.contains("network unreachable")) {
                return true;
            }
            if (message.contains("network is unreachable")) {
                return true;
            }
        }
        return false;
    }

    public static boolean isApnError(Throwable e) {
        if (!WtcNetworkExceptionPlatform.isIOException(e)) {
            return false;
        }
        String message = e.getMessage();
        return message != null && (message = message.toLowerCase()).contains("apn is not specified");
    }

    public static boolean isRemoteConnectionClosed(SocketException e) {
        String message;
        WtcLog.warn(TAG, "isRemoteConnectionClosed(...)");
        Throwable cause = e.getCause();
        if (cause != null) {
            WtcLog.info(TAG, "isRemoteConnectionClosed: cause=" + cause, cause);
        }
        return (message = e.getMessage()) != null && (message = message.toLowerCase()).contains("connection reset by peer");
    }

    public static boolean isLocalConnectionClosed(SocketException e) {
        String message;
        WtcLog.warn(TAG, "isLocalConnectionClosed(...)");
        Throwable cause = e.getCause();
        if (cause != null) {
            WtcLog.info(TAG, "isLocalConnectionClosed: cause=" + cause, cause);
        }
        if ((message = e.getMessage()) != null) {
            if ((message = message.toLowerCase()).contains("connection timed out")) {
                return true;
            }
            if (message.contains("network is unreachable")) {
                return true;
            }
        }
        return false;
    }

    protected WtcNetworkExceptionPlatform(WtcInetSocketAddressPlatform address, Exception innerException) {
        this.address = address;
        this.innerException = innerException;
    }

    public WtcNetworkExceptionPlatform(WtcUri uri, Exception innerException) {
        this(WtcNetworkExceptionPlatform.toWtcInetSocketAddress(uri), innerException);
    }

    @Override
    public String toString() {
        return new StringBuffer().append('{').append("address=").append(this.address).append(", innerException=").append(this.innerException).append('}').toString();
    }

    protected static WtcInetSocketAddressPlatform toWtcInetSocketAddress(WtcUri uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = "http".equals(uri.getScheme()) ? 80 : ("https".equals(uri.getScheme()) ? 443 : 0);
        }
        return new WtcInetSocketAddressPlatform(uri.getHost(), port);
    }

    public static class WtcNetworkHostnameNotVerifiedException
    extends WtcNetworkExceptionPlatform {
        private static final long serialVersionUID = -7278000041207334636L;

        public WtcNetworkHostnameNotVerifiedException(WtcUri uri, Exception innerException) {
            super(uri, innerException);
        }
    }

    public static class WtcNetworkUnreachableException
    extends WtcNetworkExceptionPlatform {
        private static final long serialVersionUID = -5749677690136934889L;

        public WtcNetworkUnreachableException(WtcInetSocketAddressPlatform address, Exception innerException) {
            super(address, innerException);
        }

        public WtcNetworkUnreachableException(WtcUri uri, Exception innerException) {
            super(uri, WtcNetworkUnreachableException.translate(innerException));
        }

        public static Exception translate(Exception exception) {
            if (exception instanceof ConnectException) {
                // empty if block
            }
            return exception;
        }
    }

    public static class WtcNetworkUnknownHostException
    extends WtcNetworkExceptionPlatform {
        private static final long serialVersionUID = -4791427279849143246L;

        public WtcNetworkUnknownHostException(WtcInetSocketAddressPlatform address, Exception innerException) {
            super(address, innerException);
        }

        public WtcNetworkUnknownHostException(WtcUri uri, Exception innerException) {
            super(uri, innerException);
        }
    }
}

