/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.net;

import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.net.WtcConnection;
import com.twistpair.wave.thinclient.net.WtcUri;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;

public class WtcHttpConnectionPlatform
extends WtcConnection {
    private static final String TAG = WtcLog.TAG(WtcHttpConnectionPlatform.class);
    public static final int HTTP_OK = 200;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_FOUND = 302;
    public static final int HTTP_MOVED_TEMP = 307;
    protected final HttpURLConnection connection;

    protected WtcHttpConnectionPlatform(WtcUri uri) throws IOException {
        URL url = new URL(uri.toString());
        this.connection = (HttpURLConnection)url.openConnection();
        this.connection.setInstanceFollowRedirects(true);
        this.setConnectTimeout(WtcConnection.getDefaultConnectTimeout());
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void setConnectTimeout(int timeout) throws IllegalArgumentException {
        WtcLog.info(TAG, "+setConnectTimeout(" + timeout + ')');
        this.connection.setConnectTimeout(timeout);
        this.connection.setReadTimeout(timeout);
        WtcLog.info(TAG, "-setConnectTimeout(" + timeout + ')');
    }

    public void setRequestMethod(String method) throws ProtocolException {
        this.connection.setRequestMethod(method);
    }

    public void setDoOutput(boolean newValue) {
        this.connection.setDoOutput(newValue);
    }

    public void connect() throws IOException {
        this.connection.connect();
    }

    public int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        return this.connection.getResponseMessage();
    }

    public int getContentLength() {
        return this.connection.getContentLength();
    }

    public String getHeaderField(String key) {
        return this.connection.getHeaderField(key);
    }
}

