/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.media;

import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.media.AudioPlayer;
import com.twistpair.wave.thinclient.media.WtcMediaCodec;
import com.twistpair.wave.thinclient.media.WtcMediaDeviceSpeaker;
import com.twistpair.wave.thinclient.media.WtcMediaExceptionPlatform;

public class WtcMediaDeviceSpeakerPlatform
extends WtcMediaDeviceSpeaker {
    private static final String TAG = WtcLog.TAG(WtcMediaDeviceSpeakerPlatform.class);
    private final Object mSyncState = new Object();
    private static final int AUDIO_PLAYER_SAMPLE_RATE = 8000;
    private static final int AUDIO_PLAYER_CHANNEL_CONFIG = 4;
    private static final int AUDIO_PLAYER_ENCODING_FORMAT = 2;
    private int mStreamType;
    private Thread mThreadAudioPlayer;

    public WtcMediaDeviceSpeakerPlatform(WtcMediaCodec mediaDecoder) {
        this.setMediaDecoder(mediaDecoder);
        this.mStreamType = 3;
        try {
            int streamType = this.getStreamType();
            AudioPlayer.findMinBufferSizeInBytes(streamType, 8000, 4, 2, 10);
        }
        catch (IllegalArgumentException e) {
            WtcLog.error(TAG, "Error calculating speaker buffer size", e);
            throw e;
        }
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    @Override
    public void setVolume(int volume) {
    }

    @Override
    public int getVolume() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.mSyncState;
        synchronized (object) {
            return this.mThreadAudioPlayer != null && this.mThreadAudioPlayer.isAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void open() throws WtcMediaExceptionPlatform {
        try {
            WtcLog.debug(TAG, "+open()");
            Object object = this.mSyncState;
            synchronized (object) {
                super.open();
                AudioPlayer audioPlayer = new AudioPlayer(this.mStreamType, 8000, 4, 2){

                    @Override
                    protected void onAudioPlayerStarted(int bufferLength) {
                    }

                    @Override
                    protected void onAudioPlayerStopped(Exception error) {
                        WtcMediaDeviceSpeakerPlatform.this.close(error != null);
                    }

                    @Override
                    protected int onAudioPlayerGetBuffer(short[] buffer) throws InterruptedException {
                        int shortsDecoded = WtcMediaDeviceSpeakerPlatform.this.dequeueDecoded(buffer);
                        if (shortsDecoded == -1) {
                            WtcLog.warn(TAG, "dequeueDecoded timeout (>" + WtcMediaDeviceSpeakerPlatform.this.getAutoCloseTimeout() + "ms)");
                            shortsDecoded = 0;
                        }
                        return shortsDecoded;
                    }
                };
                this.mThreadAudioPlayer = new Thread((Runnable)audioPlayer, "AudioPlayer");
                this.mThreadAudioPlayer.start();
            }
        }
        finally {
            WtcLog.debug(TAG, "-open()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean error) {
        try {
            WtcLog.debug(TAG, "+close(error=" + error + ")");
            Object object = this.mSyncState;
            synchronized (object) {
                if (this.mThreadAudioPlayer != null) {
                    this.mThreadAudioPlayer.interrupt();
                    this.mThreadAudioPlayer = null;
                }
                super.close(error);
            }
        }
        finally {
            WtcLog.debug(TAG, "-close(error=" + error + ")");
        }
    }
}

