/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.media;

import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.media.WtcMediaCodec;
import com.twistpair.wave.thinclient.media.WtcMediaCodecRawCopy;
import com.twistpair.wave.thinclient.media.WtcMediaExceptionPlatform;
import com.twistpair.wave.thinclient.util.WtcArrayBlockingQueue;
import com.twistpair.wave.thinclient.util.WtcArrayQueue;

public abstract class WtcMediaDeviceSpeaker {
    private static final String TAG = WtcLog.TAG(WtcMediaDeviceSpeaker.class);
    public static final int DEFAULT_AUTO_CLOSE_TIMEOUT_MS = 3000;
    private final WtcArrayBlockingQueue mQueueEncoded = new WtcArrayBlockingQueue("QueueSpeakerEncoded");
    private final SparePool mSparePool = new SparePool();
    protected WtcMediaCodec mMediaDecoder;
    private IWtcMediaSpeakerStateListener mListenerState;
    private IWtcMediaSpeakerBufferListener mListenerBuffer;
    private int mAutoCloseTimeout = 3000;
    protected boolean mIgnoreRx = true;

    protected WtcMediaDeviceSpeaker() {
        this.setMediaDecoder(null);
    }

    public void setMediaDecoder(WtcMediaCodec mediaDecoder) {
        if (mediaDecoder == null) {
            mediaDecoder = new WtcMediaCodecRawCopy();
        }
        this.mMediaDecoder = mediaDecoder;
    }

    public void setStateListener(IWtcMediaSpeakerStateListener listener) {
        this.mListenerState = listener;
    }

    public void setBufferListener(IWtcMediaSpeakerBufferListener listener) {
        this.mListenerBuffer = listener;
    }

    public void maintenance(boolean clear) {
        this.mQueueEncoded.maintenance();
        this.mSparePool.maintenance(clear);
    }

    public void setAutoCloseTimeout(int timeout) {
        this.mAutoCloseTimeout = timeout;
    }

    public long getAutoCloseTimeout() {
        return this.mAutoCloseTimeout;
    }

    public boolean checkAutoCloseTimeout(long timeLastWrite) {
        if (timeLastWrite + (long)this.mAutoCloseTimeout < System.currentTimeMillis()) {
            WtcLog.warn(TAG, "Speaker inactivity timeout: timeLastWrite > " + this.mAutoCloseTimeout);
            return true;
        }
        return false;
    }

    public abstract void setVolume(int var1);

    public abstract int getVolume();

    public abstract boolean isOpen();

    public boolean isIgnoreRx() {
        return this.mIgnoreRx;
    }

    public void setIgnoreRx(boolean on) {
        this.mIgnoreRx = on;
    }

    protected void open() throws WtcMediaExceptionPlatform {
        IWtcMediaSpeakerStateListener listener = this.mListenerState;
        if (listener != null) {
            listener.onSpeakerOpening();
        }
    }

    public void close(boolean error) {
        this.mQueueEncoded.clear();
        IWtcMediaSpeakerStateListener listener = this.mListenerState;
        if (listener != null) {
            listener.onSpeakerClosed(error);
        }
    }

    protected boolean onSpeakerBuffer() {
        boolean mayPlay = true;
        IWtcMediaSpeakerBufferListener listener = this.mListenerBuffer;
        if (listener != null) {
            mayPlay = listener.onSpeakerBuffer();
        }
        return mayPlay;
    }

    protected void enqueueEncodedCopy(byte[] bufferEncoded, int offset, int length) {
        Spare spareEncoded = this.mSparePool.remove(length);
        System.arraycopy(bufferEncoded, offset, spareEncoded.buffer, 0, length);
        this.mQueueEncoded.add(spareEncoded);
    }

    protected int dequeueDecoded(short[] bufferDecoded) throws InterruptedException {
        int shortsDecoded = 0;
        if (this.onSpeakerBuffer()) {
            Spare spareEncoded = (Spare)this.mQueueEncoded.poll(this.mAutoCloseTimeout);
            if (spareEncoded != null) {
                shortsDecoded = this.mMediaDecoder.decode(spareEncoded.buffer, spareEncoded.length, bufferDecoded);
                this.mSparePool.add(spareEncoded);
            } else {
                shortsDecoded = -1;
            }
        } else {
            shortsDecoded = bufferDecoded.length;
            for (int i = 0; i < shortsDecoded; ++i) {
                bufferDecoded[i] = 0;
            }
        }
        return shortsDecoded;
    }

    protected int dequeueDecoded(byte[] bufferDecoded) throws InterruptedException {
        return 0;
    }

    public void write(byte[] bufferEncoded, int offset, int length) throws WtcMediaExceptionPlatform {
        if (bufferEncoded == null) {
            return;
        }
        if (this.mIgnoreRx) {
            return;
        }
        if (!this.isOpen()) {
            this.open();
        }
        this.enqueueEncodedCopy(bufferEncoded, offset, length);
    }

    private static class SparePool {
        private final WtcArrayQueue queueSpares = new WtcArrayQueue("QueueSpeakerSpares");

        private SparePool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void maintenance(boolean clear) {
            WtcArrayQueue wtcArrayQueue = this.queueSpares;
            synchronized (wtcArrayQueue) {
                this.queueSpares.maintenance(clear);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Spare remove(int length) {
            WtcArrayQueue wtcArrayQueue = this.queueSpares;
            synchronized (wtcArrayQueue) {
                Spare spare;
                if (this.queueSpares.isEmpty()) {
                    spare = new Spare(length);
                } else {
                    spare = (Spare)this.queueSpares.remove();
                    spare.setLength(length);
                }
                return spare;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void add(Spare spare) {
            WtcArrayQueue wtcArrayQueue = this.queueSpares;
            synchronized (wtcArrayQueue) {
                this.queueSpares.add(spare);
            }
        }
    }

    private static class Spare {
        private byte[] buffer = null;
        private int length = 0;

        public Spare(int length) {
            this.setLength(length);
        }

        public void setLength(int length) {
            if (this.length < length) {
                this.buffer = new byte[length];
                this.length = length;
            }
        }
    }

    public static interface IWtcMediaSpeakerBufferListener {
        public boolean onSpeakerBuffer();
    }

    public static interface IWtcMediaSpeakerStateListener {
        public void onSpeakerOpening();

        public void onSpeakerClosed(boolean var1);
    }
}

