/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.media;

import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.media.AudioRecorder;
import com.twistpair.wave.thinclient.media.WtcMediaCodec;
import com.twistpair.wave.thinclient.media.WtcMediaDeviceMicrophone;

public class WtcMediaDeviceMicrophonePlatform
extends WtcMediaDeviceMicrophone {
    private static final String TAG = WtcLog.TAG(WtcMediaDeviceMicrophonePlatform.class);
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final int AUDIO_RECORDER_SAMPLE_RATE = 8000;
    private static final int AUDIO_RECORDER_CHANNEL_CONFIG = 16;
    private static final int AUDIO_RECORDER_ENCODING_FORMAT = 2;
    private int mAudioSource;
    private AudioRecorder mAudioRecorder;
    private Thread mThreadAudioRecorder;
    private boolean mIsOpening;

    public WtcMediaDeviceMicrophonePlatform(WtcMediaCodec mediaEncoder) {
        this.setMediaEncoder(mediaEncoder);
        this.mAudioSource = 1;
        try {
            AudioRecorder.findMinBufferSizeInBytes(this.mAudioSource, 8000, 16, 2, 10);
        }
        catch (IllegalArgumentException e) {
            WtcLog.error(TAG, "Error calculating microphone buffer size", e);
            throw e;
        }
    }

    public int getAudioSource() {
        return this.mAudioSource;
    }

    @Override
    public void setLevel(int level) {
    }

    @Override
    public int getLevel() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.mSyncState;
        synchronized (object) {
            return this.mThreadAudioRecorder != null && this.mThreadAudioRecorder.isAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean open(Runnable runAfterOpened) {
        block6: {
            boolean bl;
            try {
                WtcLog.debug(TAG, "+open(runAfterOpened=" + runAfterOpened + ')');
                Object object = this.mSyncState;
                // MONITORENTER : object
                if (!super.open(runAfterOpened)) break block6;
                bl = true;
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                WtcLog.debug(TAG, "-open(runAfterOpened=" + runAfterOpened + ')');
                throw throwable;
            }
            WtcLog.debug(TAG, "-open(runAfterOpened=" + runAfterOpened + ')');
            return bl;
        }
        int codecBytesPerAudioFrame = this.mMediaEncoder.getBytesPerFrame();
        this.mAudioRecorder = new AudioRecorder(this.mAudioSource, 8000, 16, 2, codecBytesPerAudioFrame){
            byte[] bufferEncoded;

            @Override
            protected void onAudioRecorderStarted(int bufferLength) {
                this.bufferEncoded = new byte[bufferLength];
                WtcMediaDeviceMicrophonePlatform.this.onMicrophoneOpened();
            }

            @Override
            protected void onAudioRecorderStopped(Exception error) {
                super.onAudioRecorderStopped(error);
                WtcMediaDeviceMicrophonePlatform.this.onMicrophoneClosed(error != null);
                this.bufferEncoded = null;
            }

            @Override
            protected int onAudioRecorderGotBuffer(short[] bufferUnencoded, int offsetUnencoded, int lengthUnencoded) throws InterruptedException {
                int lengthEncoded = WtcMediaDeviceMicrophonePlatform.this.encode(bufferUnencoded, offsetUnencoded, lengthUnencoded, this.bufferEncoded);
                if (lengthEncoded > 0) {
                    WtcMediaDeviceMicrophonePlatform.this.onMicrophoneBuffer(this.bufferEncoded, 0, lengthEncoded);
                } else {
                    WtcLog.warn(TAG, "encode(...) returned 0 bytes");
                }
                return lengthEncoded;
            }
        };
        this.mThreadAudioRecorder = new Thread((Runnable)this.mAudioRecorder, "AudioRecorder");
        WtcLog.debug(TAG, "+mThreadAudioRecorder.start()");
        this.mThreadAudioRecorder.start();
        WtcLog.debug(TAG, "-mThreadAudioRecorder.start()");
        this.mIsOpening = true;
        boolean bl = false;
        // MONITOREXIT : object
        WtcLog.debug(TAG, "-open(runAfterOpened=" + runAfterOpened + ')');
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean close(boolean error, Runnable runAfterClosed) {
        String sig;
        block12: {
            boolean bl;
            block13: {
                sig = "close(error=" + error + ", runAfterClosed=" + runAfterClosed + ')';
                try {
                    if (error) {
                        WtcLog.error(TAG, "+" + sig);
                    } else {
                        WtcLog.debug(TAG, "+" + sig);
                    }
                    Object object = this.mSyncState;
                    // MONITORENTER : object
                    if (!super.close(error, runAfterClosed) || this.mIsOpening) break block12;
                    bl = true;
                    // MONITOREXIT : object
                    if (!error) break block13;
                }
                catch (Throwable throwable) {
                    if (error) {
                        WtcLog.error(TAG, "-" + sig);
                        throw throwable;
                    }
                    WtcLog.debug(TAG, "-" + sig);
                    throw throwable;
                }
                WtcLog.error(TAG, "-" + sig);
                return bl;
            }
            WtcLog.debug(TAG, "-" + sig);
            return bl;
        }
        if (this.mAudioRecorder != null) {
            WtcLog.debug(TAG, "+mAudioRecorder.stop()");
            this.mAudioRecorder.stop();
            WtcLog.debug(TAG, "-mAudioRecorder.stop()");
            this.mAudioRecorder = null;
        }
        if (this.mThreadAudioRecorder != null) {
            WtcLog.debug(TAG, "+mThreadAudioRecorder.interrupt()");
            this.mThreadAudioRecorder.interrupt();
            WtcLog.debug(TAG, "-mThreadAudioRecorder.interrupt()");
            this.mThreadAudioRecorder = null;
        }
        this.mIsOpening = false;
        boolean bl = false;
        // MONITOREXIT : object
        if (error) {
            WtcLog.error(TAG, "-" + sig);
            return bl;
        }
        WtcLog.debug(TAG, "-" + sig);
        return bl;
    }
}

