/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.media;

import com.twistpair.wave.thinclient.media.WtcMediaCodec;
import com.twistpair.wave.thinclient.media.WtcMediaCodecRawCopy;

public abstract class WtcMediaDeviceMicrophone {
    private static long sBytesCapturedLifetime = 0L;
    private static long sBytesEncodedLifetime = 0L;
    private Runnable mRunAfterOpened;
    private Runnable mRunAfterClosed;
    protected WtcMediaCodec mMediaEncoder;
    protected final Object mSyncState = new Object();
    private IWtcMediaMicrophoneStateListener mListenerState = null;
    protected final Object mSyncBuffer = new Object();
    private IWtcMediaMicrophoneBufferListener mListenerBuffer = null;

    public static long getBytesCapturedLifetime() {
        return sBytesCapturedLifetime;
    }

    public static long getBytesEncodedLifetime() {
        return sBytesEncodedLifetime;
    }

    public abstract boolean isOpen();

    public abstract void setLevel(int var1);

    public abstract int getLevel();

    protected WtcMediaDeviceMicrophone() {
        this.setMediaEncoder(null);
    }

    public void setMediaEncoder(WtcMediaCodec mediaEncoder) {
        if (mediaEncoder == null) {
            mediaEncoder = new WtcMediaCodecRawCopy();
        }
        this.mMediaEncoder = mediaEncoder;
    }

    public WtcMediaCodec getMediaEncoder() {
        return this.mMediaEncoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStateListener(IWtcMediaMicrophoneStateListener listener) {
        Object object = this.mSyncState;
        synchronized (object) {
            this.mListenerState = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferListener(IWtcMediaMicrophoneBufferListener listener) {
        Object object = this.mSyncBuffer;
        synchronized (object) {
            this.mListenerBuffer = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(Runnable runAfterOpened) {
        Object object = this.mSyncState;
        synchronized (object) {
            this.mRunAfterOpened = runAfterOpened;
            this.close(false, null);
            if (this.isOpen()) {
                this.onMicrophoneOpened();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMicrophoneOpened() {
        Object object = this.mSyncState;
        synchronized (object) {
            if (this.mListenerState != null) {
                this.mListenerState.onMicrophoneOpened(this.mRunAfterOpened);
            } else if (this.mRunAfterOpened != null) {
                this.mRunAfterOpened.run();
            }
            this.mRunAfterOpened = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean error, Runnable runAfterClosed) {
        Object object = this.mSyncState;
        synchronized (object) {
            this.mRunAfterClosed = runAfterClosed;
            if (!this.isOpen()) {
                this.onMicrophoneClosed(error);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMicrophoneClosed(boolean error) {
        Object object = this.mSyncState;
        synchronized (object) {
            if (this.mListenerState != null) {
                this.mListenerState.onMicrophoneClosed(error, this.mRunAfterClosed);
            } else if (this.mRunAfterClosed != null) {
                this.mRunAfterClosed.run();
            }
            this.mRunAfterClosed = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMicrophoneBuffer(byte[] buffer, int offset, int length) {
        Object object = this.mSyncBuffer;
        synchronized (object) {
            sBytesCapturedLifetime += (long)length;
            if (this.mListenerBuffer != null) {
                this.mListenerBuffer.onMicrophoneBuffer(buffer, offset, length);
            }
        }
    }

    public int encode(short[] bufferUnencoded, int offset, int length, byte[] bufferEncoded) {
        int bytesEncoded = this.mMediaEncoder.encode(bufferUnencoded, offset, length, bufferEncoded);
        sBytesEncodedLifetime += (long)bytesEncoded;
        return bytesEncoded;
    }

    public static interface IWtcMediaMicrophoneBufferListener {
        public void onMicrophoneBuffer(byte[] var1, int var2, int var3);
    }

    public static interface IWtcMediaMicrophoneStateListener {
        public void onMicrophoneOpened(Runnable var1);

        public void onMicrophoneClosed(boolean var1, Runnable var2);
    }
}

