/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.media;

import android.media.AudioRecord;
import android.os.Process;
import com.twistpair.wave.thinclient.logging.WtcLog;
import java.io.IOException;

public abstract class AudioRecorder
implements Runnable {
    private static final String TAG = WtcLog.TAG(AudioRecorder.class);
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private final int mAudioSource;
    private final int mAudioSampleRate;
    private final int mAudioChannelConfig;
    private final int mAudioEncodingFormat;
    private final int mAudioFrameBytes;
    private final Object mSyncAudioRecord = new Object();
    private AudioRecord mAudioRecord;
    private boolean mIsRecording;

    public AudioRecorder(int audioSource, int audioSampleRate, int audioChannelConfig, int audioEncodingFormat, int audioFrameBytes) {
        this.mAudioSource = audioSource;
        this.mAudioSampleRate = audioSampleRate;
        this.mAudioChannelConfig = audioChannelConfig;
        this.mAudioEncodingFormat = audioEncodingFormat;
        this.mAudioFrameBytes = audioFrameBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findMinBufferSizeInBytes(int audioSource, int audioSampleRate, int audioChannelConfig, int audioEncodingFormat, int maxMultiplier) throws IllegalArgumentException {
        WtcLog.debug(TAG, "audioSource=" + audioSource);
        WtcLog.debug(TAG, "audioSampleRate=" + audioSampleRate);
        WtcLog.debug(TAG, "audioChannelConfig=" + audioChannelConfig);
        WtcLog.debug(TAG, "audioEncodingFormat=" + audioEncodingFormat);
        int minBufferSize = AudioRecord.getMinBufferSize((int)audioSampleRate, (int)audioChannelConfig, (int)audioEncodingFormat);
        if (minBufferSize == -2 || minBufferSize == -1) {
            throw new IllegalArgumentException();
        }
        WtcLog.info(TAG, "minBufferSize=" + minBufferSize);
        for (int i = 1; i < maxMultiplier; ++i) {
            int bufferSize = minBufferSize * i;
            WtcLog.info(TAG, "Trying bufferSize=" + bufferSize + " (" + minBufferSize + " * " + i + ")");
            AudioRecord audioRecord = null;
            try {
                audioRecord = new AudioRecord(audioSource, audioSampleRate, audioChannelConfig, audioEncodingFormat, bufferSize);
                if (audioRecord.getState() != 1) continue;
                WtcLog.info(TAG, "Found bufferSize=" + bufferSize + " (" + minBufferSize + " * " + i + ")");
                int n = bufferSize;
                return n;
            }
            catch (IllegalArgumentException e) {
                WtcLog.warn(TAG, "findMinBufferSize - IllegalArgumentException", e);
                continue;
            }
            finally {
                if (audioRecord != null) {
                    audioRecord.release();
                    audioRecord = null;
                }
            }
        }
        throw new IllegalArgumentException("Failed to initialize AudioRecord with bufferSize <= " + maxMultiplier + " * minBufferSize=" + minBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        WtcLog.info(TAG, "+stop()");
        Object object = this.mSyncAudioRecord;
        synchronized (object) {
            this.mIsRecording = false;
        }
        WtcLog.info(TAG, "-stop()");
    }

    protected abstract void onAudioRecorderStarted(int var1);

    protected abstract int onAudioRecorderGotBuffer(short[] var1, int var2, int var3) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAudioRecorderStopped(Exception error) {
        Object object = this.mSyncAudioRecord;
        synchronized (object) {
            this.mIsRecording = false;
            if (this.mAudioRecord != null) {
                WtcLog.info(TAG, "stop: mAudioRecord.getState() == " + this.mAudioRecord.getState());
                if (this.mAudioRecord.getState() == 1) {
                    WtcLog.info(TAG, "stop: +mAudioRecord.stop()");
                    this.mAudioRecord.stop();
                    WtcLog.info(TAG, "stop: -mAudioRecord.stop()");
                }
                WtcLog.info(TAG, "stop: +mAudioRecord.release()");
                this.mAudioRecord.release();
                WtcLog.info(TAG, "stop: -mAudioRecord.release()");
                this.mAudioRecord = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Exception error = null;
        try {
            WtcLog.info(TAG, "+run()");
            this.mIsRecording = true;
            int minBufferSizeInBytes = AudioRecorder.findMinBufferSizeInBytes(this.mAudioSource, this.mAudioSampleRate, this.mAudioChannelConfig, this.mAudioEncodingFormat, 10);
            WtcLog.info(TAG, "minBufferSizeInBytes(ORIGINAL)=" + minBufferSizeInBytes);
            WtcLog.info(TAG, "mAudioFrameBytes=" + this.mAudioFrameBytes);
            minBufferSizeInBytes = (int)Math.ceil((double)minBufferSizeInBytes / (double)this.mAudioFrameBytes) * this.mAudioFrameBytes;
            WtcLog.info(TAG, "minBufferSizeInBytes(FRAMED)=" + minBufferSizeInBytes);
            WtcLog.info(TAG, "+audioRecord = new AudioRecord(..., " + minBufferSizeInBytes + ")");
            this.mAudioRecord = new AudioRecord(this.mAudioSource, this.mAudioSampleRate, this.mAudioChannelConfig, this.mAudioEncodingFormat, minBufferSizeInBytes);
            WtcLog.info(TAG, "-audioRecord = new AudioRecord(..., " + minBufferSizeInBytes + ")");
            short[] buffer = new short[minBufferSizeInBytes];
            this.onAudioRecorderStarted(buffer.length);
            Process.setThreadPriority((int)-16);
            this.mAudioRecord.startRecording();
            while (this.mIsRecording) {
                String detailMessage;
                int length = this.mAudioRecord.read(buffer, 0, buffer.length);
                if (length > 0) {
                    length = this.onAudioRecorderGotBuffer(buffer, 0, length);
                }
                if (length > 0) continue;
                switch (length) {
                    case 0: {
                        WtcLog.warn(TAG, "length == 0; // ending recording");
                        detailMessage = null;
                        break;
                    }
                    case -1: {
                        detailMessage = "AudioRecord.ERROR(" + length + ")";
                        break;
                    }
                    case -2: {
                        detailMessage = "AudioRecord.ERROR_BAD_VALUE(" + length + ")";
                        break;
                    }
                    case -3: {
                        detailMessage = "AudioRecord.ERROR_INVALID_OPERATION(" + length + ")";
                        break;
                    }
                    default: {
                        detailMessage = "AudioRecord.ERROR UNKNOWN(" + length + ")";
                    }
                }
                if (detailMessage == null) break;
                WtcLog.error(TAG, detailMessage);
                throw new IOException(detailMessage);
            }
            this.onAudioRecorderStopped(error);
        }
        catch (Exception e) {
            try {
                WtcLog.error(TAG, "run: EXCEPTION", e);
                error = e;
                this.onAudioRecorderStopped(error);
            }
            catch (Throwable throwable) {
                this.onAudioRecorderStopped(error);
                WtcLog.info(TAG, "-run()");
                throw throwable;
            }
            WtcLog.info(TAG, "-run()");
        }
        WtcLog.info(TAG, "-run()");
    }
}

