/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.logging;

import android.os.Process;
import android.util.Log;
import com.twistpair.wave.thinclient.util.WtcString;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WtcLogPlatform {
    public static final int VERBOSE = 2;
    public static final int FATAL = 0;
    public static final int ERROR = 6;
    public static final int WARN = 5;
    public static final int INFO = 4;
    public static final int DEBUG = 3;
    private static final String[] LEVEL_NAMES = new String[]{"F", "?", "T", "D", "I", "W", "E"};
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss.SSS");

    public static boolean isLoggable(String tag, int level) {
        return Log.isLoggable((String)tag, (int)level);
    }

    public static void setTagLevel(String tag, int level) {
    }

    public static String format(String tag, int level, String msg, Throwable e) {
        StringBuffer sb = new StringBuffer().append(DATE_FORMAT.format(new Date())).append(' ').append(WtcString.padNumber(Process.myPid(), ' ', 5)).append(' ').append(WtcString.padNumber(Process.myTid(), ' ', 5)).append(' ').append(LEVEL_NAMES[level]).append(' ').append(tag).append(' ').append(msg);
        if (e != null) {
            sb.append(": throwable=").append(Log.getStackTraceString((Throwable)e));
        }
        return sb.toString();
    }

    public static String println(String tag, int level, String msg, Throwable e) {
        StringBuffer sb = new StringBuffer();
        sb.append('T').append(Process.myTid()).append(' ').append(msg);
        if (e != null) {
            sb.append(": throwable=").append(Log.getStackTraceString((Throwable)e));
            e = null;
        }
        msg = sb.toString();
        Log.println((int)level, (String)tag, (String)msg);
        msg = WtcLogPlatform.format(tag, level, msg, e);
        return msg;
    }

    public static String getStackTraceString(Object caller, Throwable throwable) {
        return Log.getStackTraceString((Throwable)throwable);
    }
}

