/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.kexcrypto;

import com.twistpair.wave.thinclient.kexcrypto.WtcCryptoUtilPlatform;
import com.twistpair.wave.thinclient.kexcrypto.WtcDhKeyPairPlatform;
import com.twistpair.wave.thinclient.kexcrypto.WtcKexCryptoBase;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcString;
import junit.framework.Assert;

public class WtcKexCryptoServerSimulator
extends WtcKexCryptoBase {
    public static final String TAG = WtcLog.TAG(WtcKexCryptoServerSimulator.class);
    public static final int BYTES_PER_BLOCK = 16;
    private final short numKeys;
    private final short numBytesPerKey;

    public WtcKexCryptoServerSimulator(short numKeys) {
        this.setMessageCipherMode(0);
        this.numKeys = numKeys;
        this.numBytesPerKey = (short)32;
    }

    protected static byte[] generateIV() {
        return WtcCryptoUtilPlatform.getRandomBytes(16);
    }

    protected static byte[] generateKey(int numBytesPerKey) {
        return WtcCryptoUtilPlatform.getRandomBytes(numBytesPerKey);
    }

    protected void generateKeys(int numKeys, int numBytesPerKey, byte[][] keysClientToServer, byte[][] keysServerToClient) {
        for (int i = 0; i < numKeys; ++i) {
            byte[] key = WtcKexCryptoServerSimulator.generateKey(numBytesPerKey);
            keysClientToServer[i] = key;
            key = WtcKexCryptoServerSimulator.generateKey(numBytesPerKey);
            keysServerToClient[i] = key;
        }
    }

    public IWtcMemoryStream simulateServerResponse(IWtcMemoryStream inputStream) throws WtcKexCryptoBase.WtcKexCryptoException {
        WtcLog.info(TAG, "+simulateServerResponse");
        try {
            this.reset();
            int readStart = inputStream.getPosition();
            byte[] header = new byte[HEADER.length];
            inputStream.read(header, 0, header.length);
            WtcLog.info(TAG, "header=" + WtcString.toHexString(header));
            int cookie = inputStream.readInt32();
            WtcLog.info(TAG, "cookie=" + cookie);
            String keyGroupId = WtcKexCryptoServerSimulator.readString(inputStream);
            WtcLog.info(TAG, "keyGroupId=" + keyGroupId);
            String capabilities = WtcKexCryptoServerSimulator.readString(inputStream);
            WtcLog.info(TAG, "capabilities=" + capabilities);
            byte[] G = WtcKexCryptoServerSimulator.readByteArray(inputStream);
            WtcLog.info(TAG, "G(" + G.length + ")=" + WtcString.toHexString(G));
            byte[] P = WtcKexCryptoServerSimulator.readByteArray(inputStream);
            WtcLog.info(TAG, "P(" + P.length + ")=" + WtcString.toHexString(P));
            byte[] E = WtcKexCryptoServerSimulator.readByteArray(inputStream);
            WtcLog.info(TAG, "E(" + E.length + ")=" + WtcString.toHexString(E));
            byte[] MAC1 = WtcKexCryptoServerSimulator.readByteArray(inputStream);
            WtcLog.info(TAG, "MAC1(" + MAC1.length + ")=" + WtcString.toHexString(MAC1));
            int readStop = inputStream.getPosition();
            byte[] hmacKey = this.findKeyAndThrowExceptionIfNotValidInput(header, keyGroupId, inputStream, readStart, readStop, MAC1);
            WtcLog.info(TAG, "hmacKey(" + hmacKey.length + ")=" + WtcString.toHexString(hmacKey));
            WtcLog.info(TAG, "numKeys=" + this.numKeys);
            WtcLog.info(TAG, "numBytesPerKey=" + this.numBytesPerKey);
            WtcDhKeyPairPlatform dhkp = new WtcDhKeyPairPlatform(P, G);
            byte[] F = dhkp.getDHPublicKeyBytes();
            WtcLog.info(TAG, "F(" + F.length + ")=" + WtcString.toHexString(F));
            byte[] sharedSecret = dhkp.calculateAgreement(E);
            WtcLog.info(TAG, "sharedSecret(" + sharedSecret.length + ")=" + WtcString.toHexString(sharedSecret));
            this.masterKey = WtcCryptoUtilPlatform.SHA256(sharedSecret);
            WtcLog.info(TAG, "masterKey(" + this.masterKey.length + ")=" + WtcString.toHexString(this.masterKey));
            this.setMessageCipherMode(0);
            String messageCipherMode = WtcKexCryptoServerSimulator.cipherModeToString(this.getMessageCipherMode());
            WtcLog.info(TAG, "messageCipherMode=" + messageCipherMode);
            byte[] ivClientToServer = WtcKexCryptoServerSimulator.generateIV();
            byte[] ivServerToClient = WtcKexCryptoServerSimulator.generateIV();
            WtcLog.info(TAG, "ivClientToServer(" + ivClientToServer.length + ")=" + WtcString.toHexString(ivClientToServer));
            WtcLog.info(TAG, "ivServerToClient(" + ivServerToClient.length + ")=" + WtcString.toHexString(ivServerToClient));
            Assert.assertEquals((String)"ivClientToServer.length != ivServerToClient.length", (int)ivClientToServer.length, (int)ivServerToClient.length);
            this.ivLocalToRemote = ivServerToClient;
            this.ivRemoteToLocal = ivClientToServer;
            byte[][] keysClientToServer = new byte[this.numKeys][];
            byte[][] keysServerToClient = new byte[this.numKeys][];
            WtcLog.info(TAG, "Keys generating...");
            this.generateKeys(this.numKeys, this.numBytesPerKey, keysClientToServer, keysServerToClient);
            WtcLog.info(TAG, "Keys generated!");
            WtcLog.info(TAG, "PayloadTransforms initializing (this can take awhile)...");
            this.initializePayloadTransforms(ivServerToClient, keysServerToClient, ivClientToServer, keysClientToServer, 1);
            WtcLog.info(TAG, "PayloadTransforms initialized!");
            byte[] keysEncrypted = this.encryptKeys(this.masterKey, keysClientToServer, keysServerToClient);
            WtcLog.info(TAG, "keysEncrypted(" + keysEncrypted.length + ")=" + WtcString.toHexString(keysEncrypted));
            WtcMemoryStream outputStream = new WtcMemoryStream();
            outputStream.writeInt16(this.numBytesPerKey);
            outputStream.writeInt16(this.numKeys);
            WtcKexCryptoServerSimulator.writeByteArray(outputStream, F);
            WtcKexCryptoServerSimulator.writeString(outputStream, messageCipherMode);
            WtcKexCryptoServerSimulator.writeByteArray(outputStream, ivClientToServer);
            WtcKexCryptoServerSimulator.writeByteArray(outputStream, ivServerToClient);
            WtcKexCryptoServerSimulator.writeByteArray(outputStream, keysEncrypted);
            byte[] MAC2 = WtcCryptoUtilPlatform.HMACSHA256(hmacKey, outputStream.getBuffer(), 0, outputStream.getLength());
            WtcLog.info(TAG, "MAC2(" + MAC2.length + ")=" + WtcString.toHexString(MAC2));
            WtcKexCryptoServerSimulator.writeByteArray(outputStream, MAC2);
            outputStream.setPosition(0);
            WtcMemoryStream wtcMemoryStream = outputStream;
            return wtcMemoryStream;
        }
        catch (WtcKexCryptoBase.WtcKexCryptoException e) {
            WtcLog.error(TAG, "EXCEPTION: processKexResponse", e);
            this.reset();
            throw e;
        }
        catch (Exception e) {
            WtcLog.error(TAG, "EXCEPTION: simulateServerResponse", e);
            this.reset();
            throw new WtcKexCryptoBase.WtcKexCryptoException("simulateServerResponse", e);
        }
        finally {
            WtcLog.info(TAG, "-simulateServerResponse");
        }
    }
}

