/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.kexcrypto;

import com.twistpair.wave.thinclient.kexcrypto.WtcCryptoUtilPlatform;
import com.twistpair.wave.thinclient.kexcrypto.WtcDhKeyPairPlatform;
import com.twistpair.wave.thinclient.kexcrypto.WtcKexCryptoBase;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcString;
import junit.framework.Assert;

public class WtcKexCryptoClient
extends WtcKexCryptoBase {
    private static final String TAG = WtcLog.TAG(WtcKexCryptoClient.class);
    public static boolean VERBOSE_LOG = false;
    public static final String DEFAULT_KEX_GROUP = "";
    public static final int DEFAULT_KEX_MODE = 0;
    public static final int DEFAULT_KEX_SIZE = 4096;
    public static byte[] DH64_P = new byte[]{-23, 8, 70, -125, -80, 83, 91, 11};
    public static byte[] DH64_G = new byte[]{2};
    public static byte[] DH1024_P = new byte[]{-18, -87, 71, 21, 51, 49, 87, -75, -23, -18, 21, 82, 105, 72, 76, -50, 78, 75, -13, 7, 5, -69, 104, -57, 14, -7, -59, 103, -76, 111, 115, -47, 123, -7, 18, -67, -82, -87, -59, 72, 28, 14, 13, 116, -123, 13, 97, 37, -41, -11, 113, -107, -117, 118, 41, 74, -82, 67, 120, -105, 76, 54, -36, 62, 66, -18, -94, -72, -7, 51, 126, -118, 103, 41, -3, 17, 118, 106, 109, 62, -80, 49, 124, 45, 88, -22, 82, 96, -114, -29, 10, -41, 122, 11, 119, 16, 124, 106, -46, -73, -47, 22, 111, -85, 36, -55, -19, 85, 115, -121, -82, 55, 23, 115, 27, 49, 8, -41, 62, 19, -126, -82, 124, 36, -59, 0, -120, 83};
    public static byte[] DH1024_G = new byte[]{2};
    public static byte[] DH2048_P = new byte[]{-122, 22, 32, 82, 113, -77, -121, -93, -43, 115, 51, -45, -106, 63, -96, -119, 125, -57, -6, -55, -100, 126, 6, -50, 98, 39, -55, -91, -13, -92, 36, 13, 127, -23, 77, -33, 5, 91, 77, 95, 23, -49, -99, -36, 13, 87, -105, -13, -38, 107, -71, 18, 98, -128, 92, 22, 119, -81, -78, 13, 16, 112, 9, 24, 114, -75, -108, 63, 112, 123, -103, 3, -54, -127, 21, 69, 14, -82, -76, 24, 39, 92, -113, 93, -45, -40, -63, 61, -51, -92, 100, 96, -103, 19, 59, 108, -2, -70, -125, -39, 21, 95, 60, 93, 95, 70, 93, 94, 55, 69, 17, 99, -75, 26, 74, 81, 78, -10, -50, 77, 3, 13, -89, 41, 53, -77, 120, 8, 105, -71, 126, 94, 100, -125, -121, -117, 113, -52, -102, -42, 85, 67, 81, -75, 31, -49, 71, -104, 38, -44, -126, 1, 77, 35, -56, 50, -97, -6, 65, 16, 62, 105, -109, 84, -109, 1, -82, -66, 123, 114, -96, 122, 74, -15, 35, 20, 117, 51, -32, -34, 39, 106, -92, -29, 124, 6, 60, -36, 95, 37, 52, -118, -68, -53, 34, 49, -58, -74, -86, -19, 113, -73, 109, -72, -54, 96, 10, -83, 103, -90, 85, 55, 7, 4, -80, -35, 112, 52, 35, -42, -82, 25, -37, 75, -13, -54, 104, 1, -47, -17, 111, -83, 56, 13, -122, 124, 6, 4, 41, 85, 103, -49, 103, -32, -117, -14, -98, 2, -22, 71, 14, 44, -4, -111, -64, -45};
    public static byte[] DH2048_G = new byte[]{2};
    public static byte[] DH4096_P = new byte[]{-103, -32, -35, 66, 40, -47, 85, 19, 39, -90, 73, 41, -21, 29, -22, -128, 34, 119, -100, 60, 1, -62, -22, -42, -28, -1, 1, 83, -25, -48, 46, 61, -63, 3, -22, -87, 92, -100, -12, -115, 62, -53, -28, 41, -16, -65, -108, 92, 59, 38, -70, 60, 14, -43, -14, 31, 76, 90, 30, 71, -44, -1, -125, -78, 37, 120, 111, 64, 70, -76, 50, 73, -53, -27, 56, 80, 16, -8, -55, 41, -93, 41, -6, -62, -13, -41, 8, 71, -33, -36, 101, 124, 117, 33, -91, -78, -116, 51, 77, 94, 125, 54, -82, 126, 100, -88, 3, 15, -34, -67, 118, -92, 92, -55, -98, 4, 65, -38, 72, -39, 59, 22, 10, -65, -109, -57, -21, -121, -38, -89, 15, -12, 36, 114, -63, 94, -102, -5, -64, -75, 80, -2, 26, -67, -81, 34, -74, -97, 82, 106, 103, 79, 5, -31, -12, 39, 86, -60, -20, 44, 38, 100, -15, 13, 69, 52, -19, 126, -65, -73, 126, -96, -29, -6, 34, 98, 38, 49, 48, 114, -107, -48, -32, 45, -127, 75, -117, -3, -7, -20, 83, 115, -115, 89, -106, -57, 105, 32, -89, -5, -56, 112, -95, -17, -86, 126, 54, 84, -22, 97, -40, 43, 0, 43, -99, -51, 16, -63, 68, 82, -124, -14, 86, 82, -112, 48, 8, -127, -85, -94, -72, -41, -44, -23, 93, 85, 87, 24, 63, -93, 98, -100, 7, -84, 74, -94, -34, 17, -125, -19, -115, 112, 60, 8, -7, 71, -78, -100, 41, 48, -120, 106, -23, -48, -58, 100, 110, -14, 46, 46, -61, 3, 102, -6, -111, -54, -111, 40, -73, 4, -83, -48, -22, -39, 88, 73, 93, -94, -88, 65, -90, -3, -4, -66, 44, -5, 123, 98, 121, -48, -14, 121, 75, -22, 34, 65, -33, -92, 7, -92, -18, 14, -75, 104, 122, -14, 12, -12, -102, 81, 113, 49, 27, 79, 35, -83, 93, -32, -19, -55, 70, -23, -28, -104, -7, -70, 102, -28, -102, 27, -84, 104, 119, -107, -22, 69, 31, -21, -125, 71, -64, -105, -128, -99, 19, -6, -15, -105, -61, -40, -60, 13, 110, -106, 97, -126, 112, 13, -110, -51, -76, 8, 58, -98, 38, -122, 5, -53, -80, 67, -97, -50, -122, -25, -72, 78, 103, -110, -101, -50, -7, 103, -119, -12, -8, 126, 121, -3, 125, -107, 50, -36, -34, -37, -110, 64, 54, 82, -21, 16, -55, -54, 43, 8, -52, -81, 103, -24, -45, -73, -68, 62, 16, 88, -104, -7, -69, -50, -97, 21, -124, 87, 11, -23, 116, 64, -52, 47, -15, -80, 26, 39, -23, 1, -7, 47, 54, 119, 123, 12, 84, 21, 28, -90, 17, 60, 67, -5, 99, 97, -111, 51, -60, 28, 57, 108, -6, -28, -27, -93, 104, 117, 9, -74, -38, 102, 67, -3, 55, -5, 85, -107, 14, -68, 24, 11, -118, -2, 7, -100, -86, -128, -46, -86, -127, 83, -16, 105, 88, 63, -41, -70, 93, 35, 22, -59, -117, -31, 18, -57, 67, -29};
    public static byte[] DH4096_G = new byte[]{2};
    public static byte[] DH8192_P = new byte[]{-61, -48, 90, -9, -95, -112, 0, -118, -109, -50, -13, -94, 52, 57, 1, -98, -121, -16, 78, -72, -5, -92, 24, 88, 16, -113, -44, -89, 0, 119, 49, 107, -95, 10, 102, -48, -31, 103, -108, -109, -56, -90, 19, 35, 57, 90, 102, 48, 26, -22, -100, 78, -3, 24, -23, 76, 1, 37, 44, -101, -121, 80, 60, 100, 57, 12, -71, -47, 30, -13, -113, 94, 8, -56, -87, 80, 40, 55, -98, -40, -123, 108, -56, -47, -111, -105, -56, -73, 49, 12, 100, 90, 54, -51, 97, 66, 22, 57, 98, -61, -39, -31, 10, 30, 72, -74, 31, -20, 114, -14, 110, -56, 29, 121, 37, -68, 123, 82, 103, 25, -80, -25, 9, -17, -9, -26, -108, 7, -12, -118, 103, 104, -4, 114, -112, -28, 102, 103, -111, -74, 60, 22, -55, 60, -94, 112, 59, 40, -81, -20, -22, 91, -41, -61, -51, 71, 120, 11, -98, -49, 5, 98, 43, 74, 99, -37, 83, -76, -93, 8, 106, 101, 110, 94, -42, -115, -113, -113, -96, -106, -92, -77, 4, 21, -69, 79, -63, 113, 34, -119, 106, 60, 16, -123, -21, 63, 16, -60, -55, -25, 41, 51, 79, 86, 24, 70, -5, 39, -89, 99, 45, 48, -126, 3, 11, 99, -73, -15, -27, 13, 118, 111, -86, -49, -107, 118, -77, 115, -32, -82, -11, -88, -53, 42, 80, -13, 36, 18, -95, 105, 110, -7, -95, 85, -73, -95, -45, 77, 92, -94, 117, 7, 21, -119, -61, 96, -81, 11, 76, -69, -114, 41, 103, 61, -107, -113, -35, 76, 14, 49, 15, -45, 31, -58, -41, 124, 98, 46, -109, 118, -24, 77, -48, -67, 86, 114, 53, -27, -40, -50, -35, 115, 10, 44, -27, -84, -85, -10, -127, 101, -118, 108, 71, 13, 51, -100, 15, 90, -72, 32, -126, 19, 91, -86, -27, -10, -121, 99, 107, 4, 4, 14, 33, 111, -81, -113, 86, 56, 18, 28, 25, -82, -105, -99, -37, -27, 61, -117, -52, -2, -123, 83, -45, 103, -77, -11, 88, 118, 120, -26, 84, -123, 24, -15, -123, -67, -45, 59, -17, 0, -91, 119, 55, 73, -22, -49, 71, -24, -64, -6, -4, -18, -71, 21, 52, 100, -65, -21, -28, 76, -124, 37, -26, 109, 93, 36, 99, 24, -94, 86, -84, 34, -34, 63, 64, 39, 25, 104, 1, -61, 31, 125, 67, 80, 21, -36, 119, 75, 50, 17, -66, -99, 119, 68, -108, -42, -4, -54, -33, -83, 104, -124, -95, -20, 52, -109, -66, 112, 70, 102, 112, 63, 18, 3, 66, -104, -27, 38, -102, -89, 45, -55, -7, -27, -28, 42, -114, 104, 46, 73, -88, 71, 23, 71, 19, -125, -37, -56, -83, -74, -83, 21, -11, -19, -52, -121, -74, -111, 104, -74, -124, 7, -70, 69, -62, 98, -96, -92, -18, -35, 103, 44, 120, 86, -66, 87, 44, 44, 25, 0, 8, 88, -88, -114, 101, -106, -113, -17, -54, 115, -18, -123, 56, -47, 67, 16, 88, -91, -65, 108, 12, 96, 1, -74, 89, -37, -102, 63, 72, -113, -15, 54, 101, -19, -43, -111, 43, 121, -107, 37, 18, 12, -66, 107, 114, 26, 42, -41, -84, -78, -59, -36, 76, 45, -70, -30, 14, -88, 82, 115, 121, 26, -63, 106, 25, -42, 62, -66, -94, 119, 4, -91, 27, 105, 26, -118, -77, 70, 51, -76, 100, 43, -20, -77, 109, 14, 42, -16, 122, -87, 0, 1, -45, 83, 19, 14, -88, -123, 46, -103, 40, 40, -123, -73, -76, 8, 111, 13, -36, 34, -116, -89, -58, -88, -9, -18, 106, -3, -117, -24, -20, 50, -47, -87, 88, 74, 17, -30, 0, 38, -3, 94, 32, -106, 120, 124, -108, 20, 64, -123, -116, 127, -53, -116, -80, 123, 113, 9, 127, 70, 106, 126, -113, -85, 54, 122, 41, 112, -20, -118, -64, -53, -97, -48, -46, 32, -63, -85, 40, 109, 43, 62, -100, -89, 36, -113, 77, -48, 36, -30, -11, -31, 0, -60, 73, -65, 117, -22, -29, -44, 20, -34, 51, 14, 96, 109, -78, 80, 125, -15, -71, 14, 42, 103, -24, -5, -124, -114, 111, 23, 121, -117, -25, -110, 58, -36, -112, -46, -28, -96, -115, 12, -46, -85, -112, -106, -47, -48, -110, 36, -21, 45, -66, 21, -105, -6, 126, -17, -104, 89, 127, -65, -51, -28, 9, -74, 100, -48, 12, 67, -15, 28, -84, -59, 23, 115, -125, 31, -116, -110, 64, -26, -114, -87, -97, -126, -45, -59, 97, 105, -96, -84, 61, -25, 79, -121, 78, 42, 75, -110, 25, -56, 53, 71, 21, -13, -41, 20, -100, 73, -28, 50, 36, 55, -24, 11, 34, -6, -56, 76, 90, -79, -14, 21, -107, 122, 127, 30, -71, 98, 12, -62, -111, -4, 82, -106, -8, -34, 67, 89, 103, 10, -70, 60, -68, 65, -57, -15, -124, -38, -21, -70, 102, 11, -72, 124, 72, 11, 11, -75, 17, -101, 31, -54, -7, -57, -51, 65, 19, -48, 84, -122, 97, 116, 111, 63, 92, -84, 62, -34, 15, 116, 97, 36, -110, -105, 65, -122, -47, -82, 61, 63, -101, 85, 44, 125, 126, -111, 63, -96, 61, 6, -112, 3, 102, 10, 67, 98, 101, 117, -24, 53, 12, 124, -30, -68, 0, -93, 116, 117, -13, -122, -53, 63, 115, 58, 45, -10, 92, -89, 72, -34, 117, -111, -82, -81, -116, 94, -39, 106, -68, 19, -39, -2, 67, -67, 39, 119, 30, -57, 27, 86, -70, 25, 20, 70, 53, -65, -51, 24, -26, 121, -57, -1, 116, -63, 120, 88, 99, 68, -114, -93, 10, 105, 118, -38, -95, -67, 49, -14, 10, 64, 89, 48, -15, 120, -119, 102, 126, -72, -112, -13, 103, 74, 82, -70, 49, 17, -71, -52, -79, -67, 105, -89, -48, 96, -87, -68, 113, -28, 78, -125, -79, 36, 31, 0, 104, -63, 36, -26, -4, 87, -6, 114, 43, -11, 51, -81, -74, 60, 121, -22, -45, 71, 12, 17, 108, -128, 20, 17, 71, -11, -40, 41, -108, 34, 1, 114, -63, 96, 60, -22, 120, -101};
    public static byte[] DH8192_G = new byte[]{2};
    protected byte[] hmacKey;
    protected WtcDhKeyPairPlatform dhKeyPair;
    protected final Object kexRequestSignal = new Object();
    protected boolean kexCompleted;
    protected Thread kexThread;
    protected int kexPrimeSize;
    protected IWtcMemoryStream kexRequest;
    protected WtcKexCryptoBase.WtcKexCryptoException kexException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        super.reset();
        this.hmacKey = null;
        this.dhKeyPair = null;
        if (this.kexRequestSignal == null) {
            this.kexCompleted = false;
            this.kexPrimeSize = 0;
            this.kexRequest = null;
            this.kexException = null;
        } else {
            Object object = this.kexRequestSignal;
            synchronized (object) {
                if (this.kexThread != null) {
                    this.kexThread.interrupt();
                    this.kexThread = null;
                }
                this.kexCompleted = false;
                this.kexPrimeSize = 0;
                this.kexRequest = null;
                this.kexException = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWtcMemoryStream waitForKexRequest() throws InterruptedException, WtcKexCryptoBase.WtcKexCryptoException {
        Object object = this.kexRequestSignal;
        synchronized (object) {
            if (!this.kexCompleted) {
                this.kexRequestSignal.wait();
            }
            if (this.kexPrimeSize == 0) {
                return null;
            }
            if (this.kexException != null) {
                throw this.kexException;
            }
            this.kexRequest.setPosition(0);
            return this.kexRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setKexRequest(IWtcMemoryStream kexRequest, WtcKexCryptoBase.WtcKexCryptoException kexException) {
        Object object = this.kexRequestSignal;
        synchronized (object) {
            if (kexRequest != null) {
                kexRequest.setPosition(0);
            }
            this.kexCompleted = true;
            this.kexRequest = kexRequest;
            this.kexException = kexException;
            this.kexRequestSignal.notifyAll();
        }
    }

    public void createKexRequestAsync() {
        this.createKexRequestAsync(4096);
    }

    public void createKexRequestAsync(int primeSize) throws IllegalArgumentException {
        this.createKexRequestAsync(DEFAULT_KEX_GROUP, 0, primeSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createKexRequestAsync(final String keyGroupId, int messageCipherMode, int primeSize) throws IllegalArgumentException {
        WtcLog.info(TAG, "+createKexRequestAsync");
        Object object = this.kexRequestSignal;
        synchronized (object) {
            byte[] G;
            byte[] P;
            this.reset();
            this.setMessageCipherMode(messageCipherMode);
            switch (primeSize) {
                case 0: {
                    this.setKexRequest(null, null);
                    return;
                }
                case 1024: {
                    P = DH1024_P;
                    G = DH1024_G;
                    break;
                }
                case 2048: {
                    P = DH2048_P;
                    G = DH2048_G;
                    break;
                }
                case 4096: {
                    P = DH4096_P;
                    G = DH4096_G;
                    break;
                }
                case 8192: {
                    P = DH8192_P;
                    G = DH8192_G;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("primeSize=" + primeSize + " not supported");
                }
            }
            this.kexPrimeSize = primeSize;
            this.kexThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        WtcLog.info(TAG, "+createKexRequestAsync.run()");
                        int cookie = WtcCryptoUtilPlatform.getRandomInt32();
                        String strMessageCipherMode = WtcKexCryptoBase.cipherModeToString(WtcKexCryptoClient.this.getMessageCipherMode());
                        WtcLog.info(TAG, "+new WtcDhKeyPairPlatform(...)");
                        long timeStart = System.currentTimeMillis();
                        WtcKexCryptoClient.this.dhKeyPair = new WtcDhKeyPairPlatform(P, G);
                        long timeStop = System.currentTimeMillis();
                        long timeElapsed = timeStop - timeStart;
                        WtcLog.warn(TAG, "-new WtcDhKeyPairPlatform(...): took " + timeElapsed + "ms");
                        byte[] E = WtcKexCryptoClient.this.dhKeyPair.getDHPublicKeyBytes();
                        WtcMemoryStream outputStream = new WtcMemoryStream();
                        if (VERBOSE_LOG) {
                            WtcLog.info(TAG, "HEADER(" + WtcKexCryptoBase.HEADER.length + ")=" + WtcKexCryptoBase.HEADER);
                        }
                        outputStream.write(WtcKexCryptoBase.HEADER, 0, WtcKexCryptoBase.HEADER.length);
                        if (VERBOSE_LOG) {
                            WtcLog.info(TAG, "cookie=" + cookie);
                        }
                        outputStream.writeInt32(cookie);
                        if (VERBOSE_LOG) {
                            WtcLog.info(TAG, "keyGroupId=" + keyGroupId);
                        }
                        WtcKexCryptoBase.writeString(outputStream, keyGroupId);
                        if (VERBOSE_LOG) {
                            WtcLog.info(TAG, "messageCipherMode=" + strMessageCipherMode);
                        }
                        WtcKexCryptoBase.writeString(outputStream, strMessageCipherMode);
                        if (VERBOSE_LOG) {
                            WtcLog.info(TAG, "G(" + G.length + ")=" + WtcString.toHexString(G));
                        }
                        WtcKexCryptoBase.writeByteArray(outputStream, G);
                        if (VERBOSE_LOG) {
                            WtcLog.info(TAG, "P(" + P.length + ")=" + WtcString.toHexString(P));
                        }
                        WtcKexCryptoBase.writeByteArray(outputStream, P);
                        if (VERBOSE_LOG) {
                            WtcLog.info(TAG, "E(" + E.length + ")=" + WtcString.toHexString(E));
                        }
                        WtcKexCryptoBase.writeByteArray(outputStream, E);
                        WtcKexCryptoClient.this.hmacKey = WtcKexCryptoBase.findKey(keyGroupId);
                        byte[] MAC1 = WtcCryptoUtilPlatform.HMACSHA256(WtcKexCryptoClient.this.hmacKey, outputStream.getBuffer(), 0, outputStream.getLength());
                        if (VERBOSE_LOG) {
                            WtcLog.info(TAG, "MAC1(" + MAC1.length + ")=" + WtcString.toHexString(MAC1));
                        }
                        WtcKexCryptoBase.writeByteArray(outputStream, MAC1);
                        WtcKexCryptoClient.this.setKexRequest(outputStream, null);
                    }
                    catch (WtcKexCryptoBase.WtcKexCryptoException e) {
                        WtcLog.error(TAG, "EXCEPTION: createKexRequestAsync.run", e);
                        WtcKexCryptoClient.this.setKexRequest(null, e);
                    }
                    catch (Exception e2) {
                        WtcLog.error(TAG, "EXCEPTION: createKexRequestAsync.run", e2);
                        WtcKexCryptoBase.WtcKexCryptoException e2 = new WtcKexCryptoBase.WtcKexCryptoException("createKexRequestAsync.run", e2);
                        WtcKexCryptoClient.this.setKexRequest(null, e2);
                    }
                    finally {
                        WtcLog.info(TAG, "-createKexRequestAsync.run()");
                    }
                }
            });
            this.kexThread.start();
        }
        WtcLog.info(TAG, "-createKexRequestAsync");
    }

    public void processKexResponse(IWtcMemoryStream inputStream) throws WtcKexCryptoBase.WtcKexCryptoException {
        WtcLog.info(TAG, "+processKexResponse");
        try {
            int readStart = inputStream.getPosition();
            short numBytesPerKey = inputStream.readInt16();
            if (VERBOSE_LOG) {
                WtcLog.info(TAG, "numBytesPerKey=" + numBytesPerKey);
            }
            short numKeys = inputStream.readInt16();
            if (VERBOSE_LOG) {
                WtcLog.info(TAG, "numKeys=" + numKeys);
            }
            byte[] F = WtcKexCryptoClient.readByteArray(inputStream);
            if (VERBOSE_LOG) {
                WtcLog.info(TAG, "F(" + F.length + ")=" + WtcString.toHexString(F));
            }
            String messageCipherMode = WtcKexCryptoClient.readString(inputStream);
            if (VERBOSE_LOG) {
                WtcLog.info(TAG, "messageCipherMode=" + messageCipherMode);
            }
            byte[] ivClientToServer = WtcKexCryptoClient.readByteArray(inputStream);
            if (VERBOSE_LOG) {
                WtcLog.info(TAG, "ivClientToServer(" + ivClientToServer.length + ")=" + WtcString.toHexString(ivClientToServer));
            }
            byte[] ivServerToClient = WtcKexCryptoClient.readByteArray(inputStream);
            if (VERBOSE_LOG) {
                WtcLog.info(TAG, "ivServerToClient(" + ivServerToClient.length + ")=" + WtcString.toHexString(ivServerToClient));
            }
            byte[] keysEncrypted = WtcKexCryptoClient.readByteArray(inputStream);
            if (VERBOSE_LOG) {
                WtcLog.info(TAG, "keysEncrypted(" + keysEncrypted.length + ")=" + WtcString.toHexString(keysEncrypted));
            }
            byte[] MAC2 = WtcKexCryptoClient.readByteArray(inputStream);
            if (VERBOSE_LOG) {
                WtcLog.info(TAG, "MAC2(" + MAC2.length + ")=" + WtcString.toHexString(MAC2));
            }
            int readStop = inputStream.getPosition();
            this.throwExceptionIfNotValidInput(inputStream, readStart, readStop, this.hmacKey, MAC2);
            this.setMessageCipherMode(WtcKexCryptoClient.parseCipherMode(messageCipherMode));
            Assert.assertEquals((String)"ivClientToServer.length != ivServerToClient.length", (int)ivClientToServer.length, (int)ivServerToClient.length);
            this.ivRemoteToLocal = ivServerToClient;
            this.ivLocalToRemote = ivClientToServer;
            byte[] sharedSecret = this.dhKeyPair.calculateAgreement(F);
            if (VERBOSE_LOG) {
                WtcLog.info(TAG, "sharedSecret(" + sharedSecret.length + ")=" + WtcString.toHexString(sharedSecret));
            }
            this.masterKey = WtcCryptoUtilPlatform.SHA256(sharedSecret);
            if (VERBOSE_LOG) {
                WtcLog.info(TAG, "masterKey(" + this.masterKey.length + ")=" + WtcString.toHexString(this.masterKey));
            }
            byte[][] keysClientToServer = new byte[numKeys][];
            byte[][] keysServerToClient = new byte[numKeys][];
            this.decryptKeys(this.masterKey, numKeys, numBytesPerKey, keysEncrypted, keysClientToServer, keysServerToClient);
            this.initializePayloadTransforms(ivClientToServer, keysClientToServer, ivServerToClient, keysServerToClient, 0);
        }
        catch (WtcKexCryptoBase.WtcKexCryptoException e) {
            WtcLog.error(TAG, "EXCEPTION: processKexResponse", e);
            this.reset();
            throw e;
        }
        catch (Exception e) {
            WtcLog.error(TAG, "EXCEPTION: processKexResponse", e);
            this.reset();
            throw new WtcKexCryptoBase.WtcKexCryptoException("processKexResponse", e);
        }
        finally {
            WtcLog.info(TAG, "-processKexResponse");
        }
    }

    public static interface WtcKexPrimeSize {
        public static final int NONE = 0;
        public static final int P64 = 64;
        public static final int P1024 = 1024;
        public static final int P2048 = 2048;
        public static final int P4096 = 4096;
        public static final int P8192 = 8192;
    }
}

