/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.kexcrypto;

import com.twistpair.wave.thinclient.WtcException;
import com.twistpair.wave.thinclient.kexcrypto.WtcCryptoUtilPlatform;
import com.twistpair.wave.thinclient.kexcrypto.WtcPayloadTransformerAes256Counter;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.protocol.WtcpMessage;
import com.twistpair.wave.thinclient.protocol.headers.WtcpHeader;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcArraysPlatform;
import com.twistpair.wave.thinclient.util.WtcString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import junit.framework.Assert;

public abstract class WtcKexCryptoBase {
    private static final String TAG = WtcLog.TAG(WtcKexCryptoBase.class);
    public static final boolean VERBOSE_LOG = false;
    public static final String DEFAULT_KEY = "TPS recommends that you use a private MAC key";
    public static Hashtable GroupMacKeys = new Hashtable();
    protected static final byte VERSION = 1;
    protected static final byte[] HEADER = new byte[]{107, 101, 88, 1};
    public static final int BLOCK_LENGTH = 16;
    protected static final byte[] IV_ZERO = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private boolean isInitialized;
    protected byte[] masterKey;
    protected byte[] ivLocalToRemote;
    protected byte[] ivRemoteToLocal;
    private IWtcPayloadTransformer payloadDecryptor;
    private IWtcPayloadTransformer payloadEncryptor;
    int messageCipherMode;

    public static byte[] findKey(String keyGroupId) {
        if (WtcString.isNullOrEmpty(keyGroupId)) {
            return DEFAULT_KEY.getBytes();
        }
        return (byte[])GroupMacKeys.get(keyGroupId);
    }

    public boolean getIsInitialized() {
        return this.isInitialized;
    }

    protected int getMessageCipherMode() {
        return this.messageCipherMode;
    }

    protected void setMessageCipherMode(int messageCipherMode) {
        switch (messageCipherMode) {
            case 0: {
                this.payloadDecryptor = new WtcPayloadTransformerAes256Counter();
                this.payloadEncryptor = new WtcPayloadTransformerAes256Counter();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported WtcMessageCipherMode=" + messageCipherMode);
            }
        }
        this.messageCipherMode = messageCipherMode;
    }

    protected WtcKexCryptoBase() {
        this.reset();
        this.messageCipherMode = 1;
    }

    protected void reset() {
        this.isInitialized = false;
        this.masterKey = null;
        this.ivLocalToRemote = null;
        this.ivRemoteToLocal = null;
        this.payloadDecryptor = null;
        this.payloadEncryptor = null;
    }

    protected static String cipherModeToString(int messageCipherMode) {
        return WtcMessageCipherMode.names[messageCipherMode];
    }

    protected static int parseCipherMode(String messageCipherMode) {
        String[] names = WtcMessageCipherMode.names;
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(messageCipherMode)) continue;
            return i;
        }
        throw new IllegalArgumentException("Could not parse a value for messageCipherMode=\"" + messageCipherMode + "\"");
    }

    protected static byte[] readByteArray(IWtcMemoryStream inputStream) throws IOException {
        short payloadLength = inputStream.readInt16();
        byte[] value = new byte[payloadLength];
        inputStream.read(value, 0, payloadLength);
        return value;
    }

    protected static void writeByteArray(IWtcMemoryStream outputStream, byte[] value) throws IOException {
        int length = value == null ? 0 : value.length;
        outputStream.writeInt16((short)length);
        if (length > 0) {
            outputStream.write(value, 0, length);
        }
    }

    protected static String readString(IWtcMemoryStream inputStream) throws IOException {
        byte[] value = WtcKexCryptoBase.readByteArray(inputStream);
        return value == null || value.length == 0 ? "" : WtcString.getString(value, 0, value.length);
    }

    protected static void writeString(IWtcMemoryStream outputStream, String value) throws IOException {
        byte[] bytes = WtcString.isNullOrEmpty(value) ? null : value.getBytes();
        WtcKexCryptoBase.writeByteArray(outputStream, bytes);
    }

    protected byte[] throwExceptionIfNotValidInput(IWtcMemoryStream inputStream, int readStart, int readStop, byte[] key, byte[] macSpecified) throws WtcKexCryptoException {
        int inputLength = inputStream.getLength();
        if (readStop != inputLength) {
            throw new IllegalArgumentException(inputLength - readStop + " unread bytes in inputStream");
        }
        int messageNoHashLength = readStop - readStart - (2 + macSpecified.length);
        byte[] macComputed = WtcCryptoUtilPlatform.HMACSHA256(key, inputStream.getBuffer(), readStart, messageNoHashLength);
        if (!WtcArraysPlatform.equals(macComputed, macSpecified)) {
            throw new IllegalArgumentException("Specified MAC does not equal computed/expected MAC");
        }
        return key;
    }

    protected byte[] findKeyAndThrowExceptionIfNotValidInput(byte[] header, String keyGroupId, IWtcMemoryStream inputStream, int readStart, int readStop, byte[] macSpecified) throws WtcKexCryptoException {
        if (!WtcArraysPlatform.equals(header, HEADER)) {
            throw new IllegalArgumentException("KEX header invalid");
        }
        byte[] key = WtcKexCryptoBase.findKey(keyGroupId);
        return this.throwExceptionIfNotValidInput(inputStream, readStart, readStop, key, macSpecified);
    }

    protected byte[] encryptKeys(byte[] masterKey, byte[][] keysClientToServer, byte[][] keysServerToClient) throws WtcKexCryptoException {
        Assert.assertEquals((String)"keysClientToServer.length != keysServerToClient.length", (int)keysClientToServer.length, (int)keysServerToClient.length);
        ByteArrayOutputStream streamKeys = new ByteArrayOutputStream();
        for (byte[] key : keysClientToServer) {
            streamKeys.write(key, 0, key.length);
        }
        for (byte[] key : keysServerToClient) {
            streamKeys.write(key, 0, key.length);
        }
        WtcCryptoUtilPlatform.WtcEncryptorAes256Ecb encryptor = new WtcCryptoUtilPlatform.WtcEncryptorAes256Ecb(masterKey);
        byte[] keysDecrypted = streamKeys.toByteArray();
        byte[] keysEncrypted = encryptor.transform(keysDecrypted, 0, keysDecrypted.length);
        return keysEncrypted;
    }

    protected void decryptKeys(byte[] masterKey, int numKeys, int numBytesPerKey, byte[] keysEncrypted, byte[][] keysClientToServer, byte[][] keysServerToClient) throws WtcKexCryptoException, IOException {
        byte[] key;
        int i;
        Assert.assertEquals((String)"keysClientToServer.length != keysServerToClient.length", (int)keysClientToServer.length, (int)keysServerToClient.length);
        WtcCryptoUtilPlatform.WtcDecryptorAes256Ecb decryptor = new WtcCryptoUtilPlatform.WtcDecryptorAes256Ecb(masterKey);
        byte[] keysDecrypted = decryptor.transform(keysEncrypted, 0, keysEncrypted.length);
        int baseOffset = 0;
        for (i = 0; i < numKeys; ++i) {
            key = WtcArraysPlatform.copy(keysDecrypted, baseOffset + i * numBytesPerKey, numBytesPerKey);
            keysClientToServer[i] = key;
        }
        baseOffset = numKeys * numBytesPerKey;
        for (i = 0; i < numKeys; ++i) {
            key = WtcArraysPlatform.copy(keysDecrypted, baseOffset + i * numBytesPerKey, numBytesPerKey);
            keysServerToClient[i] = key;
        }
    }

    protected void initializePayloadTransforms(byte[] ivLocalToRemote, byte[][] keysLocalToRemote, byte[] ivRemoteToLocal, byte[][] keysRemoteToLocal, int side) throws WtcKexCryptoException {
        Assert.assertEquals((String)"keysLocalToRemote.length != keysRemoteToLocal.length", (int)keysLocalToRemote.length, (int)keysRemoteToLocal.length);
        int numKeys = keysLocalToRemote.length;
        IWtcTransformer[] decryptors = new IWtcTransformer[numKeys];
        IWtcTransformer[] encryptors = new IWtcTransformer[numKeys];
        WtcCryptoUtilPlatform.WtcEncryptorAes256Ecb transform = null;
        byte[] nonceDecryptor = null;
        byte[] nonceEncryptor = null;
        switch (this.messageCipherMode) {
            case 0: {
                byte[] key;
                int i;
                nonceDecryptor = ivRemoteToLocal;
                for (i = 0; i < numKeys; ++i) {
                    key = keysRemoteToLocal[i];
                    transform = new WtcCryptoUtilPlatform.WtcEncryptorAes256Ecb(key);
                    decryptors[i] = transform;
                }
                nonceEncryptor = ivLocalToRemote;
                for (i = 0; i < numKeys; ++i) {
                    key = keysLocalToRemote[i];
                    transform = new WtcCryptoUtilPlatform.WtcEncryptorAes256Ecb(key);
                    encryptors[i] = transform;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported WtcMessageCipherMode=" + this.messageCipherMode);
            }
        }
        this.payloadDecryptor.initialize(decryptors, nonceDecryptor);
        this.payloadEncryptor.initialize(encryptors, nonceEncryptor);
        this.isInitialized = true;
    }

    public void decryptPayload(long extendedSequenceNumber, WtcpMessage message, byte[] workingBlockBuffer) throws WtcKexCryptoException {
        if (!this.isInitialized || !message.getShouldBeCrypted()) {
            return;
        }
        WtcpHeader header = message.getHeader();
        int payloadOffset = header.getPayloadOffset();
        int payloadLength = header.getPayloadLength();
        byte[] messageBuffer = message.stream.getBuffer();
        this.decryptPayload(extendedSequenceNumber, messageBuffer, payloadOffset, payloadLength, workingBlockBuffer);
    }

    protected void decryptPayload(long extendedSequenceNumber, byte[] messageBuffer, int payloadOffset, int payloadLength, byte[] workingBlockBuffer) throws WtcKexCryptoException {
        if (!this.isInitialized) {
            return;
        }
        this.payloadDecryptor.transformPayload(extendedSequenceNumber, messageBuffer, payloadOffset, payloadLength, workingBlockBuffer);
    }

    public void encryptPayload(long extendedSequenceNumber, WtcpMessage message, byte[] workingBlockBuffer) throws WtcKexCryptoException {
        if (!this.isInitialized || !message.getShouldBeCrypted()) {
            return;
        }
        WtcpHeader header = message.getHeader();
        int payloadOffset = header.getPayloadOffset();
        int payloadLength = header.getPayloadLength();
        byte[] messageBuffer = message.stream.getBuffer();
        this.encryptPayload(extendedSequenceNumber, messageBuffer, payloadOffset, payloadLength, workingBlockBuffer);
    }

    protected void encryptPayload(long extendedSequenceNumber, byte[] messageBuffer, int payloadOffset, int payloadLength, byte[] workingBlockBuffer) throws WtcKexCryptoException {
        if (!this.isInitialized) {
            return;
        }
        this.payloadEncryptor.transformPayload(extendedSequenceNumber, messageBuffer, payloadOffset, payloadLength, workingBlockBuffer);
    }

    protected static interface WtcCipherSide {
        public static final int Client = 0;
        public static final int Server = 1;
        public static final String[] names = new String[]{"Client", "Server"};
    }

    public static interface WtcMessageCipherMode {
        public static final int AES256CTR = 0;
        public static final int Unknown = 1;
        public static final String[] names = new String[]{"AES256-CTR", "Unknown"};
    }

    public static abstract class WtcTransformerAes256EcbBase
    implements IWtcTransformer {
        public static final int BLOCK_LENGTH = 16;
    }

    public static interface IWtcDhKeyPair {
        public byte[] getDHPublicKeyBytes() throws WtcKexCryptoException;

        public byte[] calculateAgreement(byte[] var1) throws WtcKexCryptoException;
    }

    public static interface IWtcPayloadTransformer {
        public int getBlockLength();

        public void initialize(IWtcTransformer[] var1, byte[] var2) throws WtcKexCryptoException;

        public void transformPayload(long var1, byte[] var3, int var4, int var5, byte[] var6) throws WtcKexCryptoException;
    }

    public static interface IWtcTransformer {
        public byte[] transform(byte[] var1, int var2, int var3) throws WtcKexCryptoException;

        public void transform(byte[] var1, int var2, byte[] var3, int var4) throws WtcKexCryptoException;
    }

    public static class WtcKexCryptoException
    extends WtcException {
        public WtcKexCryptoException(String source, String message) {
            super(source, message);
        }

        public WtcKexCryptoException(String source, Exception innerException) {
            super(source, innerException);
        }

        public WtcKexCryptoException(String source, String message, Exception innerException) {
            super(source, message, innerException);
        }
    }
}

