/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.kexcrypto;

import com.twistpair.wave.thinclient.kexcrypto.WtcKexCryptoBase;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class WtcDhKeyPairPlatform
implements WtcKexCryptoBase.IWtcDhKeyPair {
    protected static final String DIFFIE_HELLMAN = "DH";
    private final DHPrivateKey dhLocalPrivateKey;
    private final DHPublicKey dhLocalPublicKey;

    public WtcDhKeyPairPlatform(byte[] P, byte[] G) throws WtcKexCryptoBase.WtcKexCryptoException {
        try {
            KeyPairGenerator dhkpg = KeyPairGenerator.getInstance(DIFFIE_HELLMAN);
            DHParameterSpec dhps = new DHParameterSpec(new BigInteger(1, P), new BigInteger(1, G));
            dhkpg.initialize(dhps);
            KeyPair dhkp = dhkpg.generateKeyPair();
            this.dhLocalPrivateKey = (DHPrivateKey)dhkp.getPrivate();
            this.dhLocalPublicKey = (DHPublicKey)dhkp.getPublic();
        }
        catch (Exception e) {
            throw new WtcKexCryptoBase.WtcKexCryptoException("new WtcDhKeyPairPlatform(...)", e);
        }
    }

    @Override
    public byte[] getDHPublicKeyBytes() {
        return this.dhLocalPublicKey.getY().toByteArray();
    }

    @Override
    public byte[] calculateAgreement(byte[] remotePublicKey) throws WtcKexCryptoBase.WtcKexCryptoException {
        KeyAgreement dhKeyAgreement;
        DHPublicKey dhRemotePublicKey;
        KeyFactory dhKeyFactory;
        BigInteger y = new BigInteger(1, remotePublicKey);
        try {
            dhKeyFactory = KeyFactory.getInstance(DIFFIE_HELLMAN);
        }
        catch (NoSuchAlgorithmException e) {
            throw new WtcKexCryptoBase.WtcKexCryptoException("WtcDhKeyPairPlatform.calculateAgreement(...)", e);
        }
        DHParameterSpec dhParameterSpec = this.dhLocalPrivateKey.getParams();
        BigInteger p = dhParameterSpec.getP();
        BigInteger g = dhParameterSpec.getG();
        DHPublicKeySpec dhRemotePublicKeySpec = new DHPublicKeySpec(y, p, g);
        try {
            dhRemotePublicKey = (DHPublicKey)dhKeyFactory.generatePublic(dhRemotePublicKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new WtcKexCryptoBase.WtcKexCryptoException("WtcDhKeyPairPlatform.calculateAgreement(...)", e);
        }
        try {
            dhKeyAgreement = KeyAgreement.getInstance(DIFFIE_HELLMAN);
        }
        catch (NoSuchAlgorithmException e) {
            throw new WtcKexCryptoBase.WtcKexCryptoException("WtcDhKeyPairPlatform.calculateAgreement(...)", e);
        }
        try {
            dhKeyAgreement.init(this.dhLocalPrivateKey);
            dhKeyAgreement.doPhase(dhRemotePublicKey, true);
        }
        catch (InvalidKeyException e) {
            throw new WtcKexCryptoBase.WtcKexCryptoException("WtcDhKeyPairPlatform.calculateAgreement(...)", e);
        }
        catch (IllegalStateException e) {
            throw new WtcKexCryptoBase.WtcKexCryptoException("WtcDhKeyPairPlatform.calculateAgreement(...)", e);
        }
        return dhKeyAgreement.generateSecret();
    }
}

