/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.net.WtcInetSocketAddressPlatform;
import com.twistpair.wave.thinclient.net.WtcUri;
import com.twistpair.wave.thinclient.protocol.WtcpConstants;
import com.twistpair.wave.thinclient.protocol.WtcpMessage;
import com.twistpair.wave.thinclient.protocol.headers.WtcpHeader;
import com.twistpair.wave.thinclient.protocol.types.WtcpErrorCode;
import com.twistpair.wave.thinclient.util.WtcString;
import com.twistpair.wave.thinclient.util.WtcThrowablePlatform;

public class WtcStackException
extends Exception {
    private static final long serialVersionUID = -5817927286364811188L;
    public final Throwable innerThrowable;

    protected WtcStackException() {
        this((Throwable)null);
    }

    protected WtcStackException(Throwable innerThrowable) {
        this.innerThrowable = innerThrowable;
    }

    public static class WtcStackRemoteDisconnectException
    extends WtcStackException {
        private static final long serialVersionUID = -116123158739893286L;

        @Override
        public String toString() {
            return WtcString.getShortClassName(this);
        }
    }

    public static class WtcStackSessionCloseException
    extends WtcStackException {
        private static final long serialVersionUID = 9018546009310564639L;
        public final boolean unsolicited;
        public final WtcpErrorCode errorCode;

        public WtcStackSessionCloseException(boolean unsolicited, WtcpErrorCode errorCode) {
            this.unsolicited = unsolicited;
            if (errorCode == null) {
                errorCode = WtcpErrorCode.OK;
            }
            this.errorCode = errorCode;
        }

        @Override
        public String toString() {
            return WtcString.getShortClassName(this) + " [unsolicited=" + this.unsolicited + ", errorCode=" + this.errorCode + "]";
        }
    }

    public static class WtcStackUserProfilesEmptyException
    extends WtcStackException {
        private static final long serialVersionUID = -7950612428704358476L;

        @Override
        public String toString() {
            return WtcString.getShortClassName(this);
        }
    }

    public static class WtcStackMessageReceiveResponseUnexpectedException
    extends WtcStackMessageReceiveException {
        private static final long serialVersionUID = 360662926229738916L;
        public final int opCode;
        public final int transactionId;

        public WtcStackMessageReceiveResponseUnexpectedException(int opCode, int transactionId) {
            this.opCode = opCode;
            this.transactionId = transactionId;
        }

        @Override
        public String toString() {
            return WtcString.getShortClassName(this) + " [opCode=" + WtcpConstants.WtcpOpCode.toString(this.opCode) + ", transactionId=" + this.transactionId + "]";
        }
    }

    public static class WtcStackMessageReceiveHeaderInvalidException
    extends WtcStackMessageReceiveException {
        private static final long serialVersionUID = -7949453646823246973L;
        public final WtcpHeader header;

        public WtcStackMessageReceiveHeaderInvalidException(WtcpHeader header) {
            this.header = header;
        }

        @Override
        public String toString() {
            return WtcString.getShortClassName(this) + " [header=" + this.header + "]";
        }
    }

    public static class WtcStackMessageReceiveTypeUnknownException
    extends WtcStackMessageReceiveException {
        private static final long serialVersionUID = -7268841278103344103L;
        public final byte messageType;

        public WtcStackMessageReceiveTypeUnknownException(byte messageType) {
            this.messageType = messageType;
        }

        @Override
        public String toString() {
            return WtcString.getShortClassName(this) + " [messageType=" + WtcpConstants.WtcpMessageType.toString(this.messageType) + "]";
        }
    }

    public static class WtcStackMessageReceiveUnderflowException
    extends WtcStackMessageReceiveException {
        private static final long serialVersionUID = -6582578480348308616L;
        public final int minimumLength;
        public final int actualLength;

        public WtcStackMessageReceiveUnderflowException(int minimumLength, int actualLength) {
            this.minimumLength = minimumLength;
            this.actualLength = actualLength;
        }

        @Override
        public String toString() {
            return new StringBuffer().append(WtcString.getShortClassName(this)).append(" [").append("minimumLength=").append(this.minimumLength).append(", actualLength=").append(this.actualLength).append(']').toString();
        }
    }

    public static class WtcStackMessageReceiveOverflowException
    extends WtcStackMessageReceiveException {
        private static final long serialVersionUID = -4196740541075378088L;
        public final int maximumLength;
        public final int actualLength;

        public WtcStackMessageReceiveOverflowException(int maximumLength, int actualLength) {
            this.maximumLength = maximumLength;
            this.actualLength = actualLength;
        }

        @Override
        public String toString() {
            return new StringBuffer().append(WtcString.getShortClassName(this)).append(" [").append("maximumLength=").append(this.maximumLength).append(", actualLength=").append(this.actualLength).append(']').toString();
        }
    }

    public static class WtcStackMessageReceiveException
    extends WtcStackException {
        private static final long serialVersionUID = -6610253798267797196L;

        protected WtcStackMessageReceiveException() {
        }
    }

    public static class WtcStackMessageRequestResponseTimeoutException
    extends WtcStackException {
        private static final long serialVersionUID = -2055063305631083722L;
        public final long expectedMs;
        public final long actualMs;
        public final byte messageType;
        public final int opCode;
        public final int transactionId;

        public WtcStackMessageRequestResponseTimeoutException(long expectedMs, long actualMs, byte messageType, int opCode, int transactionId) {
            this.expectedMs = expectedMs;
            this.actualMs = actualMs;
            this.messageType = messageType;
            this.opCode = opCode;
            this.transactionId = transactionId;
        }

        @Override
        public String toString() {
            return new StringBuffer().append(WtcString.getShortClassName(this)).append(" [").append("expectedMs=").append(this.expectedMs).append(", actualMs=").append(this.actualMs).append(", messageType=").append(WtcpConstants.WtcpMessageType.toString(this.messageType)).append(", opCode=").append(WtcpConstants.WtcpOpCode.toString(this.opCode)).append(", transactionId=").append(this.transactionId).append(']').toString();
        }
    }

    public static class WtcStackThreadProcessReceivedMessagesException
    extends WtcStackThreadException {
        private static final long serialVersionUID = -3452870499323479648L;

        public WtcStackThreadProcessReceivedMessagesException(String source, WtcpMessage message, Throwable innerThrowable) {
            super(source, message, innerThrowable);
        }
    }

    public static class WtcStackThreadSendException
    extends WtcStackThreadException {
        private static final long serialVersionUID = 7260979662066040144L;

        public WtcStackThreadSendException(String source, WtcpMessage message, Throwable innerThrowable) {
            super(source, message, innerThrowable);
        }
    }

    public static class WtcStackThreadException
    extends WtcStackException {
        private static final long serialVersionUID = 4892213481531605691L;
        public final String source;
        public final WtcpMessage message;

        protected WtcStackThreadException(String source, WtcpMessage message, Throwable innerThrowable) {
            super(innerThrowable);
            this.source = source;
            this.message = message;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer().append(WtcString.getShortClassName(this)).append(" [source=").append(this.source).append(", message=");
            switch (this.message.getMessageType()) {
                case 4: {
                    sb.append(this.message.toString('a'));
                    break;
                }
                default: {
                    sb.append(this.message.toString('x'));
                }
            }
            sb.append(", innerThrowable=").append(this.innerThrowable).append(", stackTrace=").append(WtcThrowablePlatform.toStackTraceString(this.innerThrowable)).append(']');
            return sb.toString();
        }
    }

    public static class WtcStackProxyConnectException
    extends WtcStackException {
        private static final long serialVersionUID = 7666409524855840032L;
        public final WtcInetSocketAddressPlatform proxy;

        public WtcStackProxyConnectException(WtcInetSocketAddressPlatform proxy, Throwable innerThrowable) {
            super(innerThrowable);
            this.proxy = proxy;
        }

        @Override
        public String toString() {
            return WtcString.getShortClassName(this) + " [proxy=" + this.proxy + ", innerThrowable=" + this.innerThrowable + ", stackTrace=" + WtcThrowablePlatform.toStackTraceString(this.innerThrowable) + "]";
        }
    }

    public static class WtcStackProxyLocateLocatorException
    extends WtcStackProxyLocateException {
        private static final long serialVersionUID = -6208816106633309795L;
        public final WtcUri locator;

        public WtcStackProxyLocateLocatorException(WtcUri locator, Throwable innerThrowable) {
            super(innerThrowable);
            this.locator = locator;
        }

        @Override
        public String toString() {
            return WtcString.getShortClassName(this) + " [locator=" + this.locator + ", innerThrowable=" + this.innerThrowable + ", stackTrace=" + WtcThrowablePlatform.toStackTraceString(this.innerThrowable) + "]";
        }
    }

    public static class WtcStackProxyLocateException
    extends WtcStackException {
        private static final long serialVersionUID = -8726861258264729352L;

        protected WtcStackProxyLocateException() {
        }

        protected WtcStackProxyLocateException(Throwable innerThrowable) {
            super(innerThrowable);
        }
    }

    public static class WtcStackSecurityAgreementException
    extends WtcStackSecurityException {
        private static final long serialVersionUID = -3110075628675143764L;

        public WtcStackSecurityAgreementException(int kexSize, Throwable innerThrowable) {
            super(kexSize, innerThrowable);
        }
    }

    public static class WtcStackSecurityInitializationException
    extends WtcStackSecurityException {
        private static final long serialVersionUID = 5103920114279898806L;

        public WtcStackSecurityInitializationException(int kexSize, Throwable innerThrowable) {
            super(kexSize, innerThrowable);
        }
    }

    public static class WtcStackSecurityException
    extends WtcStackException {
        private static final long serialVersionUID = -7598473310715972155L;
        public final int kexSize;

        protected WtcStackSecurityException(int kexSize, Throwable innerThrowable) {
            super(innerThrowable);
            this.kexSize = kexSize;
        }

        @Override
        public String toString() {
            return WtcString.getShortClassName(this) + " [kexSize=" + this.kexSize + ", innerThrowable=" + this.innerThrowable + ", stackTrace=" + WtcThrowablePlatform.toStackTraceString(this.innerThrowable) + "]";
        }
    }
}

