/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcConnectionStatistics;
import com.twistpair.wave.thinclient.WtcLocator;
import com.twistpair.wave.thinclient.WtcLocatorException;
import com.twistpair.wave.thinclient.WtcLocatorResponse;
import com.twistpair.wave.thinclient.WtcMessageFilter;
import com.twistpair.wave.thinclient.WtcProxyInfo;
import com.twistpair.wave.thinclient.WtcStack;
import com.twistpair.wave.thinclient.WtcStackException;
import com.twistpair.wave.thinclient.WtcStackListener;
import com.twistpair.wave.thinclient.kexcrypto.WtcKexCryptoBase;
import com.twistpair.wave.thinclient.kexcrypto.WtcKexCryptoClient;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.logging.WtcLogPlatform;
import com.twistpair.wave.thinclient.net.WtcInetSocketAddressPlatform;
import com.twistpair.wave.thinclient.net.WtcNetworkExceptionPlatform;
import com.twistpair.wave.thinclient.net.WtcSocket;
import com.twistpair.wave.thinclient.net.WtcSocketExceptionPlatform;
import com.twistpair.wave.thinclient.net.WtcSocketPlatform;
import com.twistpair.wave.thinclient.net.WtcSocketTimeoutException;
import com.twistpair.wave.thinclient.net.WtcUri;
import com.twistpair.wave.thinclient.protocol.WtcpMessage;
import com.twistpair.wave.thinclient.protocol.WtcpMessagePool;
import com.twistpair.wave.thinclient.protocol.headers.WtcpControlHeader;
import com.twistpair.wave.thinclient.protocol.headers.WtcpHeader;
import com.twistpair.wave.thinclient.protocol.headers.WtcpMediaHeader;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.IntegerPlatform;
import com.twistpair.wave.thinclient.util.WtcArrayBlockingQueue;
import com.twistpair.wave.thinclient.util.WtcArrayQueue;
import com.twistpair.wave.thinclient.util.WtcString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WtcStackConnectionManager
extends Thread
implements WtcMessageFilter.IRequestTxResponseRxTimeoutListener {
    private static final String TAG = WtcLog.TAG(WtcStackConnectionManager.class);
    private final boolean dedicatedMediaThreads = false;
    public boolean traceMessageMediaRx = false;
    public boolean traceMessageMediaTx = false;
    public boolean traceKeyExchange = false;
    public boolean traceMessageRawBytes = false;
    public boolean traceMessageRawBytesAfterSessionOpen = false;
    public boolean traceMessageHeaders = false;
    private WtcSocket socketTcp;
    private WtcInetSocketAddressPlatform proxyAddress;
    private ThreadWorker threadWorkerMainProcessTx;
    private ThreadWorker threadWorkerMediaRx;
    private ThreadWorker threadWorkerMediaTx;
    private long lastTXedWtcpSequenceNumberExtended;
    private long lastTXedWtcpControlSequenceNumber;
    private long lastTXedWtcpMediaSequenceNumber;
    private int lastTXingWtcpControlTransactionId;
    private final WtcStack stack;
    private final WtcConnectionStatistics connectionStatistics;
    private final WtcpMessagePool messagePool;
    private final WtcKexCryptoClient kexCryptoClient;
    private final int kexSize;
    private final WtcMessageFilter messageFilter;
    private final Object syncObject = new Object();
    private boolean exitReasonSet = false;
    private Exception exitReason = null;

    public WtcStackConnectionManager(WtcStack stack, int threadPriority, int kexSize) {
        super("ThreadConnection");
        this.stack = stack;
        this.setPriority(threadPriority);
        this.connectionStatistics = stack.connectionStatistics;
        this.messagePool = new WtcpMessagePool();
        this.kexCryptoClient = new WtcKexCryptoClient();
        this.kexSize = kexSize;
        this.messageFilter = new WtcMessageFilter(this, this.stack, this.connectionStatistics);
    }

    @Override
    public void onRequestTxResponseRxTimeout(long timeoutMs, long elapsedMs, byte messageType, int opCode, int transactionId) {
        WtcStackException.WtcStackMessageRequestResponseTimeoutException exitReason = new WtcStackException.WtcStackMessageRequestResponseTimeoutException(timeoutMs, elapsedMs, messageType, opCode, transactionId);
        WtcLog.error(TAG, "RequestTxResponseRxTimeout", exitReason);
        this.disconnect(exitReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExitReason(Exception exitReason) {
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.exitReasonSet) {
                this.exitReasonSet = true;
                this.exitReason = exitReason;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception getExitReason() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.exitReason;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(Exception exitReason) {
        try {
            WtcLog.debug(TAG, "+disconnect(exitReason=" + (exitReason == null ? "null" : exitReason.toString()) + ')');
            Object object = this.syncObject;
            synchronized (object) {
                this.setExitReason(exitReason);
                this.shutdown(exitReason != null);
                WtcStack.interrupt(this, false);
            }
        }
        finally {
            WtcLog.debug(TAG, "-disconnect(...)");
        }
    }

    public void maintenance() {
        boolean isSpeakerClosed = !this.stack.speaker.isOpen();
        boolean isMicrophoneClosed = !this.stack.microphone.isOpen();
        boolean clear = isSpeakerClosed && isMicrophoneClosed;
        this.messagePool.maintenance(clear);
        if (this.threadWorkerMainProcessTx != null) {
            this.threadWorkerMainProcessTx.maintenance(clear);
        }
        if (this.threadWorkerMediaRx != null) {
            this.threadWorkerMediaRx.maintenance(clear);
        }
        if (this.threadWorkerMediaTx != null) {
            this.threadWorkerMediaTx.maintenance(clear);
        }
        this.stack.speaker.maintenance(clear);
        this.connectionStatistics.log();
    }

    private void logRxMessage(WtcpMessage message) {
        if (!WtcLog.isEnabled()) {
            return;
        }
        switch (message.getMessageType()) {
            case 5: {
                if (!this.traceMessageMediaRx) break;
                WtcLog.debug(TAG, "RX " + message.stream.getLength() + "b: Media");
                break;
            }
            case 3: {
                if (this.traceMessageRawBytes) {
                    int length = message.stream.getLength();
                    String raw = WtcString.toHexString(message.stream.getBuffer(), 0, length);
                    WtcLog.debug(TAG, "RX " + length + "b (decrypted): " + raw);
                }
                if (!this.traceKeyExchange) break;
                WtcLog.debug(TAG, "RX " + message.stream.getLength() + "b: " + message.toString('x'));
                break;
            }
            default: {
                if (this.traceMessageRawBytes) {
                    int length = message.stream.getLength();
                    String raw = WtcString.toHexString(message.stream.getBuffer(), 0, length);
                    WtcLog.debug(TAG, "RX " + length + "b (decrypted): " + raw);
                }
                WtcLog.debug(TAG, "RX " + message.stream.getLength() + "b: " + message.toString());
            }
        }
    }

    private void logTxMessage(WtcpMessage message) {
        if (!WtcLog.isEnabled()) {
            return;
        }
        switch (message.getMessageType()) {
            case 5: {
                if (!this.traceMessageMediaTx) break;
                WtcLog.debug(TAG, "TX " + message.stream.getLength() + "b: Media");
                break;
            }
            case 3: {
                if (this.traceKeyExchange) {
                    WtcLog.debug(TAG, "TX " + message.stream.getLength() + "b: " + message.toString('x'));
                }
                if (!this.traceMessageRawBytes) break;
                int length = message.stream.getLength();
                String raw = WtcString.toHexString(message.stream.getBuffer(), 0, length);
                WtcLog.debug(TAG, "TX " + length + "b (decrypted): " + raw);
                break;
            }
            default: {
                WtcLog.debug(TAG, "TX " + message.stream.getLength() + "b: " + message.toString());
                if (!this.traceMessageRawBytes) break;
                int length = message.stream.getLength();
                String raw = WtcString.toHexString(message.stream.getBuffer(), 0, length);
                WtcLog.debug(TAG, "TX " + length + "b (decrypted): " + raw);
            }
        }
    }

    public WtcpMessage getMessage(byte messageType) {
        return this.messagePool.get(messageType);
    }

    public WtcpMessage getMessage(WtcpMediaHeader headerMedia) {
        return this.messagePool.get(headerMedia);
    }

    public WtcpMessage getMessage(int opCode) {
        return this.messagePool.get(opCode);
    }

    public WtcpMessage getMessage(int opType, int opCode) {
        return this.messagePool.get(opType, opCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKeyExchange(IWtcMemoryStream kexRequest) {
        try {
            WtcLog.info(TAG, "+sendKeyExchange([" + kexRequest.getLength() + " bytes])");
            WtcpMessage message = this.getMessage((byte)3);
            message.payloadAppend(kexRequest);
            this.send(message);
        }
        finally {
            WtcLog.info(TAG, "-sendKeyExchange([" + kexRequest.getLength() + " bytes])");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer send(WtcpMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        if (message.getIsMessageType(5)) {
            this.threadWorkerMainProcessTx.enqueue(1, -1L, message);
            return null;
        }
        if (message.getShouldBeCrypted() && !this.kexCryptoClient.getIsInitialized() && this.kexSize != 0) {
            throw new IllegalStateException("message requires secure connection");
        }
        Object object = this.syncObject;
        synchronized (object) {
            if (this.socketTcp == null) {
                return null;
            }
            if (this.threadWorkerMainProcessTx == null) {
                IllegalStateException e = new IllegalStateException("threadWorkerMainProcessTx == null; Cannot send message either over TCP or UDP");
                this.disconnect(e);
                return null;
            }
            Integer transactionId = null;
            if (message.getIsMessageType(4)) {
                this.lastTXingWtcpControlTransactionId = WtcpControlHeader.getNextTransactionId(this.lastTXingWtcpControlTransactionId++);
                WtcpControlHeader controlHeader = (WtcpControlHeader)message.getSubHeader();
                controlHeader.transactionId = this.lastTXingWtcpControlTransactionId;
                message.setSubHeader(controlHeader);
                transactionId = IntegerPlatform.valueOf(this.lastTXingWtcpControlTransactionId);
            }
            this.threadWorkerMainProcessTx.enqueue(1, -1L, message);
            return transactionId;
        }
    }

    protected void onMessageReceived(WtcpHeader.ExtendedNumber lastRXedWtcpSequenceNumberExtended, WtcpMessage message) {
        int length;
        WtcpHeader header = message.getHeader();
        IWtcMemoryStream inputStream = message.stream;
        header.loadNetworkToHostOrder(inputStream);
        int expectedSequenceNumber = header.normalizeSequenceNumber(lastRXedWtcpSequenceNumberExtended.large + 1L);
        int actualSequenceNumber = header.getSequenceNumber();
        if (lastRXedWtcpSequenceNumberExtended.large != 0L && actualSequenceNumber != 0 && actualSequenceNumber != expectedSequenceNumber) {
            WtcLog.warn(TAG, "*POSSIBLY* invalid Header: lastReceivedWtcpSequenceNumberExtended=0x" + WtcString.toHexString(lastRXedWtcpSequenceNumberExtended.large, 8) + ", expected sequenceNumber=" + WtcString.toHexString(expectedSequenceNumber, 2) + ", actual sequenceNumber=" + WtcString.toHexString(actualSequenceNumber, 2) + ", difference=" + (actualSequenceNumber - expectedSequenceNumber) + ", header=" + header.toString());
        }
        if (this.traceMessageRawBytes && WtcLog.isEnabled()) {
            length = inputStream.getLength();
            String raw = WtcString.toHexString(inputStream.getBuffer(), 0, length);
            WtcLog.debug(TAG, "RX " + length + "b (encrypted): " + raw);
        }
        if (this.traceMessageHeaders) {
            length = inputStream.getLength();
            WtcLog.debug(TAG, "RX " + length + "b: header=" + header.toString());
        }
        lastRXedWtcpSequenceNumberExtended.small = header.getSequenceNumber();
        header.extendSequenceNumber(lastRXedWtcpSequenceNumberExtended);
        byte messageType = message.getMessageType();
        switch (messageType) {
            case 5: {
                this.threadWorkerMainProcessTx.enqueue(2, lastRXedWtcpSequenceNumberExtended.large, message);
                break;
            }
            default: {
                this.threadWorkerMainProcessTx.enqueue(2, lastRXedWtcpSequenceNumberExtended.large, message);
            }
        }
    }

    private boolean mayTryNextServer(Throwable throwable) {
        boolean mayTryNextServer = false;
        mayTryNextServer |= throwable instanceof WtcNetworkExceptionPlatform.WtcNetworkUnknownHostException;
        return mayTryNextServer |= throwable instanceof WtcSocketTimeoutException;
    }

    private WtcProxyInfo[] findFirstProxyInfos(WtcUri[] uriServers) throws InterruptedException, WtcStackException.WtcStackProxyLocateException {
        if (uriServers == null || uriServers.length == 0) {
            throw new IllegalArgumentException("uriServers cannot be null or empty");
        }
        WtcProxyInfo[] proxyInfos = null;
        WtcUri lastServer = null;
        Throwable lastThrowable = null;
        for (int i = 0; i < uriServers.length; ++i) {
            WtcStack.checkForInterruptedException();
            lastServer = uriServers[i];
            try {
                proxyInfos = this.findProxyInfos(lastServer);
                break;
            }
            catch (Throwable throwable) {
                lastThrowable = throwable;
                if (!this.mayTryNextServer(lastThrowable)) break;
                continue;
            }
        }
        if (proxyInfos == null) {
            throw new WtcStackException.WtcStackProxyLocateLocatorException(lastServer, lastThrowable);
        }
        return proxyInfos;
    }

    private WtcProxyInfo[] findProxyInfos(WtcUri uriServer) throws InterruptedException, IOException, WtcLocatorException.WtcLocatorResponseInvalidException, WtcLocatorException.WtcLocatorErrorException {
        WtcStackListener listener;
        if (uriServer == null) {
            throw new IllegalArgumentException("uriServer cannot be null");
        }
        WtcProxyInfo[] proxyInfos = null;
        String scheme = uriServer.getScheme();
        if ("wtcp".equalsIgnoreCase(scheme)) {
            int port = uriServer.getPort();
            if (port == -1) {
                port = 4502;
            }
            proxyInfos = new WtcProxyInfo[]{new WtcProxyInfo(new WtcInetSocketAddressPlatform(uriServer.getHost(), port))};
            return proxyInfos;
        }
        if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("remoteAddress scheme must be either wtcp, http, or https");
        }
        if (this.stack.version != null) {
            WtcUri.Builder builder = uriServer.buildUpon();
            builder.appendQueryParameter("version", this.stack.version.toString());
            uriServer = builder.build();
        }
        if ((listener = this.stack._listener) != null) {
            listener.onProxyLocating(this.stack, uriServer);
        }
        this.connectionStatistics.incLocatorAttempts();
        WtcLocatorResponse locatorResponse = WtcLocator.locateProxies(uriServer);
        WtcStack.checkForInterruptedException();
        if (locatorResponse.isError()) {
            throw new WtcLocatorException.WtcLocatorErrorException(locatorResponse.errorCode);
        }
        this.connectionStatistics.incLocatorSuccess();
        listener = this.stack._listener;
        if (listener != null) {
            listener.onProxyLocated(this.stack, locatorResponse.proxyInfos);
        }
        return locatorResponse.proxyInfos;
    }

    private InputStream connectFirstProxyAddress(WtcUri[] uriServers) throws InterruptedException, IOException, WtcStackException.WtcStackProxyLocateException, WtcStackException.WtcStackProxyConnectException {
        WtcProxyInfo[] proxyInfos = this.findFirstProxyInfos(uriServers);
        if (proxyInfos == null || proxyInfos.length == 0) {
            throw new IllegalArgumentException("proxyInfos cannot be null or empty");
        }
        WtcInetSocketAddressPlatform proxyAddress = null;
        Throwable lastThrowable = null;
        for (int i = 0; i < proxyInfos.length; ++i) {
            WtcProxyInfo proxyInfo = proxyInfos[i];
            WtcInetSocketAddressPlatform[] proxyAddresses = proxyInfo.getInetSocketAddresses();
            for (int j = 0; j < proxyAddresses.length; ++j) {
                WtcStack.checkForInterruptedException();
                proxyAddress = proxyAddresses[j];
                WtcStackListener listener = this.stack._listener;
                if (listener != null) {
                    listener.onProxyConnecting(this.stack, proxyAddress);
                }
                this.connectionStatistics.incProxyConnectAttempts();
                WtcSocketPlatform proxySocket = new WtcSocketPlatform();
                try {
                    WtcLog.info(TAG, "+proxySocket.connect(" + proxyAddress + ", " + this.stack.connectTimeoutMs + ", " + this.stack.localAddress + ")");
                    proxySocket.connect(proxyAddress, this.stack.connectTimeoutMs, this.stack.localAddress);
                    WtcLog.info(TAG, "-proxySocket.connect(" + proxyAddress + ", " + this.stack.connectTimeoutMs + ", " + this.stack.localAddress + ")");
                    WtcStack.checkForInterruptedException();
                    proxyAddress = proxySocket.getRemoteAddress();
                    WtcLog.info(TAG, "Connected: " + proxyAddress);
                }
                catch (Throwable throwable) {
                    WtcLog.warn(TAG, "-proxySocket.connect(" + proxyAddress + ", " + this.stack.connectTimeoutMs + ", " + this.stack.localAddress + ")", throwable);
                    lastThrowable = throwable;
                    if (!this.mayTryNextServer(lastThrowable)) {
                        WtcLog.error(TAG, "Connect Error: " + proxyAddress, lastThrowable);
                        throw new WtcStackException.WtcStackProxyConnectException(proxyAddress, lastThrowable);
                    }
                    WtcLog.warn(TAG, "Connect Error: " + proxyAddress, lastThrowable);
                    continue;
                }
                this.connectionStatistics.incProxyConnectSuccess();
                InputStream inputStreamTcp = this.startup(proxySocket);
                listener = this.stack._listener;
                if (listener != null) {
                    listener.onProxyConnected(this.stack, proxyInfo, proxyAddress);
                }
                return inputStreamTcp;
            }
        }
        throw new WtcStackException.WtcStackProxyConnectException(proxyAddress, lastThrowable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream startup(WtcSocket proxySocketTcp) throws IOException, InterruptedException {
        try {
            WtcLog.info(TAG, "+startup(proxySocketTcp=" + proxySocketTcp + ')');
            Object object = this.syncObject;
            synchronized (object) {
                this.proxyAddress = proxySocketTcp.getRemoteAddress();
                this.socketTcp = proxySocketTcp;
                InputStream inputStreamTcp = proxySocketTcp.getInputStream();
                OutputStream outputStreamTcp = proxySocketTcp.getOutputStream();
                OutputStream outputStreamUdp = null;
                this.stack.microphone.setBufferListener(this.stack);
                int threadPriorityRx = this.getPriority();
                int threadPriorityMainProcessTx = threadPriorityRx - 1;
                int threadPriorityMediaRx = threadPriorityRx + 1;
                int threadPriorityMediaTx = threadPriorityRx + 1;
                WtcLog.info(TAG, "Starting threadWorkerMainProcessTx");
                this.threadWorkerMainProcessTx = new ThreadWorker("threadWorkerMainProcessTx", threadPriorityMainProcessTx, outputStreamTcp, outputStreamUdp);
                Object object2 = this.threadWorkerMainProcessTx;
                synchronized (object2) {
                    this.threadWorkerMainProcessTx.start();
                    this.threadWorkerMainProcessTx.wait();
                }
                WtcLog.info(TAG, "Started threadWorkerMainProcessTx");
                object2 = inputStreamTcp;
                return object2;
            }
        }
        finally {
            WtcLog.info(TAG, "-startup(proxySocketTcp=" + proxySocketTcp + ')');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(boolean error) {
        try {
            WtcLog.info(TAG, "+shutdown(error=" + error + ')');
            Object object = this.syncObject;
            synchronized (object) {
                block27: {
                    try {
                        WtcLog.info(TAG, "+shutdown microphone");
                        this.stack.microphone.setBufferListener(null);
                        this.stack.microphone.close(error, null);
                    }
                    finally {
                        WtcLog.info(TAG, "-shutdown microphone");
                    }
                    try {
                        WtcLog.info(TAG, "+shutdown speaker");
                        this.stack.speaker.close(error);
                    }
                    finally {
                        WtcLog.info(TAG, "-shutdown speaker");
                    }
                    try {
                        WtcLog.info(TAG, "+shutdown messageFilter");
                        this.messageFilter.close();
                    }
                    finally {
                        WtcLog.info(TAG, "-shutdown timeoutTxRequestRxResponse");
                    }
                    try {
                        WtcLog.info(TAG, "+shutdown socketTcp");
                        if (this.socketTcp != null) {
                            this.socketTcp.shutdown();
                            try {
                                WtcLog.info(TAG, "+socketTcp.close()");
                                this.socketTcp.close();
                                WtcLog.info(TAG, "-socketTcp.close()");
                            }
                            catch (IOException e) {
                                WtcLog.error(TAG, "socketTcp.close(); // ignore", e);
                            }
                            this.socketTcp = null;
                            break block27;
                        }
                        WtcLog.info(TAG, "socketTcp == null; // ignore");
                    }
                    finally {
                        WtcLog.info(TAG, "-shutdown socketTcp");
                    }
                }
                try {
                    WtcLog.info(TAG, "+shutdown threads");
                    WtcStack.interrupt(this.threadWorkerMainProcessTx, false);
                    this.threadWorkerMainProcessTx = null;
                    WtcStack.interrupt(this.threadWorkerMediaRx, false);
                    this.threadWorkerMediaRx = null;
                    WtcStack.interrupt(this.threadWorkerMediaTx, false);
                    this.threadWorkerMediaTx = null;
                }
                finally {
                    WtcLog.info(TAG, "-shutdown threads");
                }
            }
        }
        finally {
            WtcLog.info(TAG, "-shutdown(error=" + error + ')');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                WtcStackListener listener;
                WtcLog.info(TAG, "+run()");
                int kexSize = this.kexSize;
                try {
                    this.kexCryptoClient.createKexRequestAsync(kexSize);
                }
                catch (Exception e) {
                    WtcLog.error(TAG, "createKexRequest", e);
                    throw new WtcStackException.WtcStackSecurityInitializationException(kexSize, (Throwable)e);
                }
                InputStream inputStreamTcp = this.connectFirstProxyAddress(this.stack.remoteAddresses);
                WtcStack.checkForInterruptedException();
                if (kexSize == 0) {
                    listener = this.stack._listener;
                    if (listener != null) {
                        listener.onProxySecured(this.stack, kexSize);
                    }
                } else {
                    IWtcMemoryStream kexRequest;
                    listener = this.stack._listener;
                    if (listener != null) {
                        listener.onProxySecuring(this.stack, kexSize);
                    }
                    try {
                        kexRequest = this.kexCryptoClient.waitForKexRequest();
                    }
                    catch (Exception e) {
                        WtcLog.error(TAG, "waitForKexRequest", e);
                        throw new WtcStackException.WtcStackSecurityInitializationException(kexSize, (Throwable)e);
                    }
                    this.sendKeyExchange(kexRequest);
                    WtcStack.checkForInterruptedException();
                }
                WtcpMessage message = null;
                IWtcMemoryStream inputStream = null;
                int remaining = 0;
                WtcpHeader.ExtendedNumber lastRXedWtcpSequenceNumberExtended = new WtcpHeader.ExtendedNumber();
                while (true) {
                    Thread.yield();
                    if (remaining == 0) {
                        message = this.messagePool.get();
                        inputStream = message.stream;
                        remaining = inputStream.getLength();
                    } else {
                        inputStream = message.stream;
                        inputStream.setLength(inputStream.getPosition() + remaining);
                    }
                    byte[] buffer = inputStream.getBuffer();
                    int position = inputStream.getPosition();
                    int received = inputStreamTcp.read(buffer, position, remaining);
                    if (received == -1) {
                        WtcLog.warn(TAG, "received " + received + " bytes; remote disconnect (end of stream)");
                        throw new WtcStackException.WtcStackRemoteDisconnectException();
                    }
                    remaining = this.getBytesRemaining(received, message);
                    if (remaining != 0) continue;
                    this.onMessageReceived(lastRXedWtcpSequenceNumberExtended, message);
                }
            }
            catch (Exception e) {
                WtcStackListener listener;
                boolean isError;
                this.setExitReason(e);
                Exception exitReason = this.getExitReason();
                boolean bl = isError = exitReason != null;
                if (isError) {
                    if (exitReason instanceof WtcStackException.WtcStackSessionCloseException) {
                        WtcLog.warn(TAG, "run(): EXCEPTION " + exitReason);
                    } else if (exitReason instanceof WtcSocketExceptionPlatform) {
                        WtcLog.warn(TAG, "run(): EXCEPTION", exitReason);
                    } else {
                        WtcLog.error(TAG, "run(): EXCEPTION", exitReason);
                    }
                }
                if (this.proxyAddress != null) {
                    this.connectionStatistics.incProxyDisconnects();
                }
                if ((listener = this.stack._listener) != null) {
                    listener.onDisconnected(this.stack, this.proxyAddress, exitReason, this.connectionStatistics);
                }
                this.shutdown(isError);
                WtcLog.info(TAG, "-run()");
            }
        }
        catch (Throwable throwable) {
            WtcStackListener listener;
            boolean isError;
            Exception exitReason = this.getExitReason();
            boolean bl = isError = exitReason != null;
            if (isError) {
                if (exitReason instanceof WtcStackException.WtcStackSessionCloseException) {
                    WtcLog.warn(TAG, "run(): EXCEPTION " + exitReason);
                } else if (exitReason instanceof WtcSocketExceptionPlatform) {
                    WtcLog.warn(TAG, "run(): EXCEPTION", exitReason);
                } else {
                    WtcLog.error(TAG, "run(): EXCEPTION", exitReason);
                }
            }
            if (this.proxyAddress != null) {
                this.connectionStatistics.incProxyDisconnects();
            }
            if ((listener = this.stack._listener) != null) {
                listener.onDisconnected(this.stack, this.proxyAddress, exitReason, this.connectionStatistics);
            }
            this.shutdown(isError);
            WtcLog.info(TAG, "-run()");
            throw throwable;
        }
    }

    private int getBytesRemaining(int received, WtcpMessage message) throws WtcStackException.WtcStackMessageReceiveOverflowException, WtcStackException.WtcStackMessageReceiveHeaderInvalidException {
        if (received < 0) {
            throw new IllegalArgumentException("received must be >= 0");
        }
        if (received > 65531) {
            throw new WtcStackException.WtcStackMessageReceiveOverflowException(65531, received);
        }
        IWtcMemoryStream inputStream = message.stream;
        if (received > inputStream.getLength()) {
            throw new WtcStackException.WtcStackMessageReceiveOverflowException(inputStream.getLength(), received);
        }
        inputStream.setPosition(inputStream.getPosition() + received);
        int bufferPosition = inputStream.getPosition();
        if (bufferPosition < 4) {
            WtcLog.warn(TAG, "Message Underflow: expected=4, actual=" + received);
            return 4 - bufferPosition;
        }
        WtcpHeader header = message.getHeader();
        if (bufferPosition == 4) {
            header.loadNetworkToHostOrder(inputStream);
        }
        if (header.getVersion() != 1) {
            throw new WtcStackException.WtcStackMessageReceiveHeaderInvalidException(header);
        }
        byte messageType = header.getMessageType();
        if (messageType != 5 && messageType != 4 && messageType != 3) {
            throw new WtcStackException.WtcStackMessageReceiveHeaderInvalidException(header);
        }
        int remaining = 4 + header.getPayloadLength() - bufferPosition;
        return remaining;
    }

    private class ThreadWorker
    extends Thread {
        private final String TAG;
        private final WtcStackWorkItemPool workItemPool;
        private final WtcArrayBlockingQueue workItemQueue;
        private final OutputStream outputStreamTcp;
        private final OutputStream outputStreamUdp;
        private final byte[] workingBlockBufferEncrypt;
        private final byte[] workingBlockBufferDecrypt;

        public ThreadWorker(String name, int priority, OutputStream outputStreamTcp, OutputStream outputStreamUdp) {
            super(name);
            this.setPriority(priority);
            this.TAG = name;
            name = name.substring(0, 1).toUpperCase() + name.substring(1);
            this.workItemPool = new WtcStackWorkItemPool("WorkItemPool" + name);
            this.workItemQueue = new WtcArrayBlockingQueue("WorkItemQueue" + name);
            this.outputStreamTcp = outputStreamTcp;
            this.outputStreamUdp = outputStreamUdp;
            this.workingBlockBufferEncrypt = new byte[16];
            this.workingBlockBufferDecrypt = new byte[16];
        }

        private void maintenance(boolean clear) {
            this.workItemPool.maintenance(clear);
            this.workItemQueue.maintenance();
        }

        public void enqueue(int workItemType, long lastRXedWtcpSequenceNumberExtended, WtcpMessage workItemMessage) {
            WtcStackWorkItem workItem = this.workItemPool.get(workItemType, lastRXedWtcpSequenceNumberExtended, workItemMessage);
            this.workItemQueue.add(workItem);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                WtcLog.info(this.TAG, "+run()");
                ThreadWorker threadWorker = this;
                synchronized (threadWorker) {
                    this.notifyAll();
                }
                while (true) {
                    Thread.yield();
                    WtcStackWorkItem workItem = (WtcStackWorkItem)this.workItemQueue.take();
                    int workItemType = workItem.workItemType;
                    WtcpMessage message = workItem.workItemMessage;
                    switch (workItemType) {
                        case 1: {
                            try {
                                OutputStream outputStream;
                                byte messageType = message.getMessageType();
                                if (this.outputStreamUdp != null && messageType == 5) {
                                    WtcStackConnectionManager.this.stack.getClass();
                                }
                                if (messageType == 2) {
                                    outputStream = this.outputStreamUdp;
                                } else if (this.outputStreamTcp != null) {
                                    outputStream = this.outputStreamTcp;
                                } else {
                                    throw new WtcStackException.WtcStackThreadSendException("Cannot obtain TCP or UDP outputStream", message, new IllegalStateException());
                                }
                                this.doMessageSend(outputStream, message);
                                break;
                            }
                            catch (Exception e2) {
                                WtcStackException.WtcStackThreadSendException e2;
                                if (!(e2 instanceof WtcStackException.WtcStackThreadSendException)) {
                                    e2 = new WtcStackException.WtcStackThreadSendException("UNEXPECTED", message, e2);
                                }
                                WtcLog.error(this.TAG, "run(): EXCEPTION", e2);
                                throw e2;
                            }
                        }
                        case 2: {
                            long lastRXedWtcpSequenceNumberExtended = workItem.lastRXedWtcpSequenceNumberExtended;
                            try {
                                this.processMessageReceived(lastRXedWtcpSequenceNumberExtended, message);
                                break;
                            }
                            catch (Exception e3) {
                                WtcStackException.WtcStackThreadProcessReceivedMessagesException e3;
                                if (e3 instanceof WtcStackException.WtcStackSessionCloseException) {
                                    WtcLog.warn(this.TAG, "run(): WtcStackSessionCloseException; gracefully closing thread");
                                } else {
                                    if (!(e3 instanceof WtcStackException.WtcStackThreadProcessReceivedMessagesException)) {
                                        e3 = new WtcStackException.WtcStackThreadProcessReceivedMessagesException("UNEXPECTED", message, e3);
                                    }
                                    WtcLog.error(this.TAG, "run(): EXCEPTION", e3);
                                }
                                throw e3;
                            }
                        }
                        default: {
                            WtcLog.error(this.TAG, "UNHANDLED WtcStackWorkItem type " + workItemType);
                        }
                    }
                    WtcStackConnectionManager.this.messagePool.add(message);
                    this.workItemPool.add(workItem);
                }
            }
            catch (InterruptedException e) {
                WtcLog.info(this.TAG, "run(): InterruptedException; gracefully closing thread");
                WtcLog.info(this.TAG, "-run()");
            }
            catch (Exception e) {
                try {
                    WtcStackConnectionManager.this.disconnect(e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    WtcLog.info(this.TAG, "-run()");
                }
            }
        }

        private void doMessageSend(OutputStream outputStream, WtcpMessage message) throws WtcStackException.WtcStackThreadSendException {
            try {
                this.prepareToSend(message);
            }
            catch (Exception e) {
                throw new WtcStackException.WtcStackThreadSendException("prepareToSend", message, e);
            }
            try {
                this.sendToSocket(outputStream, message);
            }
            catch (Exception e) {
                String note = WtcStackConnectionManager.this.kexSize != 0 ? "[ENCRYPTED & NETWORK_ORDER]" : "[NETWORK_ORDER]";
                throw new WtcStackException.WtcStackThreadSendException("sendToSocket " + note, message, e);
            }
        }

        private void prepareToSend(WtcpMessage message) throws WtcKexCryptoBase.WtcKexCryptoException {
            long extendedSequenceNumber = this.adjustFields(message);
            message.dumpHeaderHostToNetworkOrder();
            WtcStackConnectionManager.this.logTxMessage(message);
            WtcStackConnectionManager.this.messageFilter.start(message);
            WtcStackConnectionManager.this.kexCryptoClient.encryptPayload(extendedSequenceNumber, message, this.workingBlockBufferEncrypt);
            message.dumpHeaderHostToNetworkOrder();
        }

        private long adjustFields(WtcpMessage message) {
            WtcpHeader header = message.getHeader();
            long extendedSequenceNumber = WtcStackConnectionManager.this.lastTXedWtcpSequenceNumberExtended++;
            header.setSequenceNumber(header.normalizeSequenceNumber(extendedSequenceNumber));
            IWtcMemoryStream outputStream = message.stream;
            byte[] buffer = outputStream.getBuffer();
            int length = outputStream.getLength();
            byte messageType = header.getMessageType();
            WtcStackConnectionManager.this.connectionStatistics.incTxed(messageType, length);
            header.setPayloadLength(Math.max(0, length - header.getSize()));
            switch (header.getMessageType()) {
                case 4: {
                    WtcpControlHeader controlHeader = (WtcpControlHeader)message.getSubHeader();
                    controlHeader.sequenceNumber = controlHeader.normalizeSequenceNumber(++WtcStackConnectionManager.this.lastTXedWtcpControlSequenceNumber);
                    controlHeader.dumpHostToNetworkOrder(outputStream);
                    controlHeader.crc = controlHeader.calculateCrc(buffer, length);
                    message.setSubHeader(controlHeader);
                    break;
                }
                case 5: {
                    WtcpMediaHeader mediaHeader = (WtcpMediaHeader)message.getSubHeader();
                    mediaHeader.setSequenceNumber(mediaHeader.normalizeSequenceNumber(++WtcStackConnectionManager.this.lastTXedWtcpMediaSequenceNumber));
                    mediaHeader.dumpHostToNetworkOrder(outputStream);
                    message.setSubHeader(mediaHeader);
                }
            }
            return extendedSequenceNumber;
        }

        private void sendToSocket(OutputStream networkOutputStream, WtcpMessage message) throws IOException {
            IWtcMemoryStream outputStream = message.stream;
            byte[] buffer = outputStream.getBuffer();
            int length = outputStream.getLength();
            if (WtcStackConnectionManager.this.traceMessageHeaders) {
                WtcpHeader header = message.getHeader();
                WtcLog.debug(this.TAG, "TX " + length + "b: header=" + header.toString());
            }
            if (WtcStackConnectionManager.this.traceMessageRawBytes && WtcLog.isEnabled()) {
                String raw = WtcString.toHexString(buffer, 0, length);
                WtcLog.debug(this.TAG, "TX " + length + "b (encrypted): " + raw);
            }
            networkOutputStream.write(buffer, 0, length);
            networkOutputStream.flush();
        }

        private void processMessageReceived(long lastRXedWtcpSequenceNumberExtended, WtcpMessage message) throws WtcStackException.WtcStackThreadProcessReceivedMessagesException, WtcStackException.WtcStackSessionCloseException, WtcStackException.WtcStackSecurityAgreementException {
            boolean shouldIgnore;
            WtcpHeader header = message.getHeader();
            IWtcMemoryStream inputStream = message.stream;
            header.loadNetworkToHostOrder(inputStream);
            try {
                WtcStackConnectionManager.this.kexCryptoClient.decryptPayload(lastRXedWtcpSequenceNumberExtended, message, this.workingBlockBufferDecrypt);
            }
            catch (Exception e) {
                throw new WtcStackException.WtcStackThreadProcessReceivedMessagesException("decryptMessage", message, e);
            }
            WtcStackConnectionManager.this.logRxMessage(message);
            try {
                shouldIgnore = WtcStackConnectionManager.this.messageFilter.cancel(message);
            }
            catch (Throwable tr) {
                String stackTrace = WtcLogPlatform.getStackTraceString(this, tr);
                WtcLog.error(this.TAG, stackTrace);
                Exception e = (Exception)tr;
                throw new WtcStackException.WtcStackThreadProcessReceivedMessagesException("messageFilter.cancel(message)", message, e);
            }
            byte messageType = message.getMessageType();
            switch (messageType) {
                case 3: {
                    try {
                        WtcStackConnectionManager.this.kexCryptoClient.processKexResponse(inputStream);
                        WtcStackConnectionManager.this.stack.processKeyExchangeMessage(inputStream);
                        break;
                    }
                    catch (Exception e) {
                        throw new WtcStackException.WtcStackSecurityAgreementException(WtcStackConnectionManager.this.kexSize, (Throwable)e);
                    }
                }
                default: {
                    try {
                        WtcStackConnectionManager.this.stack.processReceivedMessage(message, shouldIgnore);
                        break;
                    }
                    catch (WtcStackException.WtcStackSessionCloseException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new WtcStackException.WtcStackThreadProcessReceivedMessagesException("processReceivedMessage", message, e);
                    }
                }
            }
        }
    }

    public class WtcStackWorkItemPool {
        private final String TAG = WtcLog.TAG(WtcStackWorkItemPool.class);
        private final WtcArrayQueue pool;

        public WtcStackWorkItemPool(String name) {
            this.pool = new WtcArrayQueue(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(WtcStackWorkItem workItem) {
            workItem.reset();
            WtcArrayQueue wtcArrayQueue = this.pool;
            synchronized (wtcArrayQueue) {
                this.pool.add(workItem);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WtcStackWorkItem get(int workItemType, long lastRXedWtcpSequenceNumberExtended, WtcpMessage workItemMessage) {
            WtcStackWorkItem workItem;
            WtcArrayQueue wtcArrayQueue = this.pool;
            synchronized (wtcArrayQueue) {
                workItem = (WtcStackWorkItem)(this.pool.isEmpty() ? new WtcStackWorkItem() : this.pool.remove());
            }
            workItem.set(workItemType, lastRXedWtcpSequenceNumberExtended, workItemMessage);
            return workItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void maintenance(boolean clear) {
            WtcArrayQueue wtcArrayQueue = this.pool;
            synchronized (wtcArrayQueue) {
                this.pool.maintenance(clear);
            }
        }
    }

    public class WtcStackWorkItem {
        private static final int TYPE_UNKNOWN = -1;
        public static final int TYPE_TXing = 1;
        public static final int TYPE_RXed = 2;
        private int workItemType;
        private long lastRXedWtcpSequenceNumberExtended;
        private WtcpMessage workItemMessage;

        private WtcStackWorkItem() {
            this.reset();
        }

        private void reset() {
            this.set(-1, -1L, null);
        }

        private void set(int workItemType, long lastRXedWtcpSequenceNumberExtended, WtcpMessage workItemMessage) {
            this.workItemType = workItemType;
            this.lastRXedWtcpSequenceNumberExtended = lastRXedWtcpSequenceNumberExtended;
            this.workItemMessage = workItemMessage;
        }
    }
}

