/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcConnectionStatistics;
import com.twistpair.wave.thinclient.WtcPingRequestRxTimeout;
import com.twistpair.wave.thinclient.WtcStackConnectionManager;
import com.twistpair.wave.thinclient.WtcStackException;
import com.twistpair.wave.thinclient.WtcStackListener;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.media.WtcMediaDeviceMicrophone;
import com.twistpair.wave.thinclient.media.WtcMediaDeviceSpeaker;
import com.twistpair.wave.thinclient.media.WtcMediaExceptionPlatform;
import com.twistpair.wave.thinclient.net.WtcInetSocketAddressPlatform;
import com.twistpair.wave.thinclient.net.WtcUri;
import com.twistpair.wave.thinclient.net.WtcUriPlatform;
import com.twistpair.wave.thinclient.protocol.WtcpConstants;
import com.twistpair.wave.thinclient.protocol.WtcpMessage;
import com.twistpair.wave.thinclient.protocol.headers.WtcpControlHeader;
import com.twistpair.wave.thinclient.protocol.headers.WtcpHeader;
import com.twistpair.wave.thinclient.protocol.headers.WtcpMediaHeader;
import com.twistpair.wave.thinclient.protocol.types.WtcpAddressBookInfoList;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallAnswer;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallDtmf;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallHangup;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallInfo;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallOffer;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallProgress;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelActivity;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelIdErrorDictionary;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelIdList;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelInfoList;
import com.twistpair.wave.thinclient.protocol.types.WtcpEndpointInfoList;
import com.twistpair.wave.thinclient.protocol.types.WtcpEndpointProperties;
import com.twistpair.wave.thinclient.protocol.types.WtcpErrorCode;
import com.twistpair.wave.thinclient.protocol.types.WtcpKeyValueList;
import com.twistpair.wave.thinclient.protocol.types.WtcpProfileInfoList;
import com.twistpair.wave.thinclient.protocol.types.WtcpStringList;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcInt16;
import com.twistpair.wave.thinclient.util.WtcInt32;
import com.twistpair.wave.thinclient.util.WtcInt8;
import com.twistpair.wave.thinclient.util.WtcSimpleDateFormatPlatform;
import com.twistpair.wave.thinclient.util.WtcString;
import com.twistpair.wave.thinclient.util.WtcVersionString;
import java.util.Calendar;
import java.util.Date;

public class WtcStack
implements WtcMediaDeviceMicrophone.IWtcMediaMicrophoneBufferListener,
WtcPingRequestRxTimeout.IPingRequestRxTimeoutListener {
    private static final String TAG = WtcLog.TAG(WtcStack.class);
    private static final boolean CENSOR = true;
    public static final int TIMEOUT_CONNECT_MS_DEFAULT = 10000;
    public static final int TIMEOUT_REQUEST_TX_RESPONSE_RX_MS_DEFAULT = 30000;
    public static final int TIMEOUT_REQUEST_TX_RESPONSE_RX_MS_MIN = 10000;
    public static final byte TIMEOUT_SESSION_SECONDS_MAX = 120;
    public static final byte TIMEOUT_SESSION_SECONDS_MIN = 5;
    public static final String URI_SCHEMA_WTCP = "wtcp";
    public static final int PORT_WTCP_DEFAULT = 4502;
    public static final String ID_ENDPOINT_SELF = "1";
    public static final int ID_CHANNEL_SPC = 0;
    protected final boolean useUdpForMedia = false;
    protected final WtcMediaDeviceMicrophone microphone;
    protected final WtcMediaDeviceSpeaker speaker;
    protected final WtcConnectionStatistics connectionStatistics;
    protected final WtcVersionString version;
    protected final WtcUri[] remoteAddresses;
    private final int kexSize;
    protected final int connectTimeoutMs;
    protected final WtcInetSocketAddressPlatform localAddress;
    private final Object connectionSync = new Object();
    private WtcStackConnectionManager connectionManager;
    WtcStackListener _listener;
    private final WtcpMediaHeader mAudioHeader = new WtcpMediaHeader(false);
    private static final WtcSimpleDateFormatPlatform sLogCatDateFormat = new WtcSimpleDateFormatPlatform("MM-dd HH:mm:ss.SSS");
    private int lastPingRequestId = 0;
    private final Object syncPingId = new Object();
    public static boolean FAKE_ADDRESS_BOOK = true;

    public static String censor(String s) {
        return "*censored*";
    }

    public WtcStack(WtcMediaDeviceMicrophone microphone, WtcMediaDeviceSpeaker speaker, WtcConnectionStatistics connectionStatistics, WtcVersionString version, WtcUri[] remoteAddresses, int kexSize) {
        this(microphone, speaker, connectionStatistics, version, remoteAddresses, kexSize, 10000, null);
    }

    public WtcStack(WtcMediaDeviceMicrophone microphone, WtcMediaDeviceSpeaker speaker, WtcConnectionStatistics connectionStatistics, WtcVersionString version, WtcUri[] remoteAddresses, int kexSize, int connectTimeoutMs) {
        this(microphone, speaker, connectionStatistics, version, remoteAddresses, kexSize, connectTimeoutMs, null);
    }

    public WtcStack(WtcMediaDeviceMicrophone microphone, WtcMediaDeviceSpeaker speaker, WtcConnectionStatistics connectionStatistics, WtcVersionString version, WtcUri[] remoteAddresses, int kexSize, WtcInetSocketAddressPlatform localAddress) {
        this(microphone, speaker, connectionStatistics, version, remoteAddresses, kexSize, 10000, localAddress);
    }

    public WtcStack(WtcMediaDeviceMicrophone microphone, WtcMediaDeviceSpeaker speaker, WtcConnectionStatistics connectionStatistics, WtcVersionString version, WtcUri[] remoteAddresses, int kexSize, int connectTimeoutMs, WtcInetSocketAddressPlatform localAddress) {
        if (microphone == null) {
            throw new IllegalArgumentException("microphone cannot be null");
        }
        if (speaker == null) {
            throw new IllegalArgumentException("speaker cannot be null");
        }
        if (connectionStatistics == null) {
            throw new IllegalArgumentException("connectionStatistics cannot be null");
        }
        if (WtcUriPlatform.isNullOrEmpty(remoteAddresses)) {
            throw new IllegalArgumentException("remoteAddresses cannot be null, empty, or contain null/EMPTY values");
        }
        this.microphone = microphone;
        this.speaker = speaker;
        this.connectionStatistics = connectionStatistics;
        this.version = version;
        this.remoteAddresses = remoteAddresses;
        this.kexSize = kexSize;
        this.connectTimeoutMs = connectTimeoutMs;
        this.localAddress = localAddress;
    }

    public void setListener(WtcStackListener listener) {
        this._listener = listener;
    }

    protected static void interrupt(Thread thread, boolean join) {
        if (thread == null) {
            return;
        }
        String threadName = thread.getName();
        WtcLog.debug(TAG, "+" + threadName + ".interrupt()");
        try {
            thread.interrupt();
        }
        catch (Exception e) {
            WtcLog.error(TAG, threadName + ".interrupt()", e);
        }
        WtcLog.debug(TAG, "-" + threadName + ".interrupt()");
        if (join) {
            WtcLog.debug(TAG, "+" + threadName + ".join()");
            try {
                thread.join();
            }
            catch (Exception e) {
                WtcLog.error(TAG, threadName + ".join()", e);
            }
            WtcLog.debug(TAG, "-" + threadName + ".join()");
        }
    }

    protected static void checkForInterruptedException() throws InterruptedException {
        Thread.sleep(0L);
    }

    public void disconnect() {
        this.disconnect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(Exception exitReason) {
        try {
            WtcLog.info(TAG, "+disconnect(" + WtcString.repr(exitReason) + ")");
            Object object = this.connectionSync;
            synchronized (object) {
                if (this.connectionManager != null) {
                    this.connectionManager.disconnect(null);
                    WtcStack.interrupt(this.connectionManager, false);
                    this.connectionManager = null;
                }
            }
        }
        finally {
            WtcLog.info(TAG, "-disconnect(" + WtcString.repr(exitReason) + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        try {
            WtcLog.debug(TAG, "+connect()");
            Object object = this.connectionSync;
            synchronized (object) {
                this.disconnect();
                this.connectionManager = new WtcStackConnectionManager(this, 6, this.kexSize);
                this.connectionManager.start();
            }
        }
        finally {
            WtcLog.debug(TAG, "-connect()");
        }
    }

    void processReceivedMessage(WtcpMessage message, boolean shouldIgnore) throws WtcStackException.WtcStackMessageReceiveTypeUnknownException, WtcStackException.WtcStackSecurityAgreementException, WtcStackException.WtcStackSessionCloseException, WtcStackException.WtcStackUserProfilesEmptyException {
        WtcpHeader header = message.getHeader();
        IWtcMemoryStream inputStream = message.stream;
        byte messageType = header.getMessageType();
        long length = inputStream.getLength();
        this.connectionStatistics.incRxed(messageType, length);
        if (shouldIgnore) {
            WtcLog.warn(TAG, "processReceivedMessage ignoring " + message);
            return;
        }
        switch (messageType) {
            case 5: {
                WtcpMediaHeader mediaHeader = (WtcpMediaHeader)message.getSubHeader();
                this.processMediaMessage(mediaHeader, inputStream);
                break;
            }
            case 4: {
                WtcpControlHeader controlHeader = (WtcpControlHeader)message.getSubHeader();
                this.processControlMessage(controlHeader, inputStream);
                break;
            }
            case 2: {
                this.processUdpHelloMessage(message);
                break;
            }
            case 1: {
                this.processHelloMessage(message);
                break;
            }
            default: {
                throw new WtcStackException.WtcStackMessageReceiveTypeUnknownException(header.getMessageType());
            }
        }
    }

    private void processHelloMessage(WtcpMessage message) {
    }

    private void processUdpHelloMessage(WtcpMessage message) {
    }

    protected void processKeyExchangeMessage(IWtcMemoryStream inputStream) throws WtcStackException.WtcStackSecurityAgreementException {
        try {
            WtcStackListener listener = this._listener;
            if (listener != null) {
                listener.onProxySecured(this, this.kexSize);
            }
        }
        catch (Exception e) {
            throw new WtcStackException.WtcStackSecurityAgreementException(this.kexSize, (Throwable)e);
        }
    }

    private void processMediaMessage(WtcpMediaHeader mediaHeader, IWtcMemoryStream inputStream) {
        if (mediaHeader.getHas16BitCrcAfterHeader()) {
            inputStream.incPosition(2);
        }
        byte[] buffer = inputStream.getBuffer();
        int payloadOffset = inputStream.getPosition();
        int payloadLength = inputStream.getLength() - payloadOffset;
        try {
            this.speaker.write(buffer, payloadOffset, payloadLength);
        }
        catch (WtcMediaExceptionPlatform e) {
            WtcLog.error(TAG, "processMediaMessage: speaker.write(...)", e);
        }
        WtcStackListener listener = this._listener;
        if (listener != null) {
            listener.onMessageReceivedMedia(this, mediaHeader, payloadLength);
        }
    }

    @Override
    public void onMicrophoneBuffer(byte[] buffer, int offset, int length) {
        this.sendMediaMessage(buffer, offset, length);
    }

    public void sendMediaMessage(byte[] buffer, int offset, int length) {
        WtcStackConnectionManager connectionManager = this.connectionManager;
        if (connectionManager != null) {
            WtcpMessage message = connectionManager.getMessage(this.mAudioHeader);
            message.payloadSet(buffer, offset, length);
            connectionManager.send(message);
        }
    }

    private void logControlMessageIgnored(WtcpControlHeader controlHeader) {
        this.logWarnControlMessage(controlHeader, "Ignored");
    }

    private void LOG_CONTROL_MESSAGE_NOT_IMPLEMENTED(WtcpControlHeader controlHeader) {
        this.logWarnControlMessage(controlHeader, "Not Implemented");
    }

    private void logWarnControlMessage(WtcpControlHeader controlHeader, String text) {
        WtcLog.warn(TAG, "opType=" + WtcpConstants.WtcpOpType.toString(controlHeader.getOpType()) + ", opCode=\"" + WtcpConstants.WtcpOpCode.toString(controlHeader.getOpCode()) + "), transactionId=" + controlHeader.transactionId + ": " + text);
    }

    private void processControlMessage(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) throws WtcStackException.WtcStackSessionCloseException, WtcStackException.WtcStackUserProfilesEmptyException {
        WtcpControlHeader.WtcpVersionedOpCode verOpCode = controlHeader.verOpCode;
        int opCode = verOpCode.getOpCode();
        if (controlHeader.isUnsolicited()) {
            WtcLog.debug(TAG, "Unsolicited Message: " + WtcpConstants.WtcpOpCode.toString(opCode));
        }
        if (controlHeader.isError()) {
            WtcLog.error(TAG, "ERROR Message: " + WtcpConstants.WtcpOpCode.toString(opCode));
        }
        switch (opCode) {
            case 1: {
                WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                this.LOG_CONTROL_MESSAGE_NOT_IMPLEMENTED(controlHeader);
                break;
            }
            case 2: {
                this.processPing(controlHeader, inputStream);
                break;
            }
            case 3: {
                this.LOG_CONTROL_MESSAGE_NOT_IMPLEMENTED(controlHeader);
                break;
            }
            case 5: {
                this.processSessionOpen(controlHeader, inputStream);
                break;
            }
            case 6: {
                this.processSessionClose(controlHeader, inputStream);
                break;
            }
            case 7: {
                this.processSetCredentials(controlHeader, inputStream);
                break;
            }
            case 8: {
                this.processSessionResume(controlHeader, inputStream);
                break;
            }
            case 10: {
                this.processChannelSetActive(controlHeader, inputStream);
                break;
            }
            case 11: {
                this.LOG_CONTROL_MESSAGE_NOT_IMPLEMENTED(controlHeader);
                break;
            }
            case 12: {
                this.processChannelActivity(controlHeader, inputStream);
                break;
            }
            case 13: {
                this.processChannelPushToTalk(controlHeader, inputStream);
                break;
            }
            case 14: {
                this.processChannelMute(controlHeader, inputStream);
                break;
            }
            case 15: {
                this.processChannelPropertiesGet(controlHeader, inputStream);
                break;
            }
            case 16: {
                this.processChannelPropertiesSet(controlHeader, inputStream);
                break;
            }
            case 20: {
                this.processEndpointPropertiesSet(controlHeader, inputStream);
                break;
            }
            case 21: {
                this.processEndpointLookup(controlHeader, inputStream);
                break;
            }
            case 22: {
                this.processEndpointPropertiesGet(controlHeader, inputStream);
                break;
            }
            case 23: {
                this.processEndpointPropertyFilterSet(controlHeader, inputStream);
                break;
            }
            case 30: {
                this.processPhoneLinesSetActive(controlHeader, inputStream);
                break;
            }
            case 31: {
                this.processPhoneLineStatus(controlHeader, inputStream);
                break;
            }
            case 32: {
                this.processCallMake(controlHeader, inputStream);
                break;
            }
            case 33: {
                this.processCallOffer(controlHeader, inputStream);
                break;
            }
            case 34: {
                this.processCallAnswer(controlHeader, inputStream);
                break;
            }
            case 35: {
                this.processCallHangup(controlHeader, inputStream);
                break;
            }
            case 37: {
                this.processCallProgress(controlHeader, inputStream);
                break;
            }
            case 36: {
                this.processCallDtmf(controlHeader, inputStream);
                break;
            }
            case 38: {
                this.processCallPushToTalkOn(controlHeader, inputStream);
                break;
            }
            case 39: {
                this.processCallPushToTalkOff(controlHeader, inputStream);
                break;
            }
            case 50: {
                this.processAddressBook(controlHeader, inputStream);
                break;
            }
            default: {
                this.logControlMessageIgnored(controlHeader);
            }
        }
        if (inputStream.getPosition() != inputStream.getLength()) {
            int remain = inputStream.getLength() - inputStream.getPosition();
            WtcLog.warn(TAG, remain + " unprocessed/stray trailing bytes in payload!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendSessionOpen(WtcInt8 audioCodec, WtcInt8 audioScale, WtcInt8 sessionTimeoutSeconds, String platformDescription) {
        try {
            WtcLog.info(TAG, "+sendSessionOpen(" + audioCodec + ", " + audioScale + ", " + sessionTimeoutSeconds + ", " + WtcString.quote(platformDescription) + ")");
            if (sessionTimeoutSeconds.value < 5 || sessionTimeoutSeconds.value > 120) {
                throw new IllegalArgumentException("sessionTimeoutSeconds must be >= 5 and <= 120");
            }
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(5);
                message.payloadAppend(audioCodec);
                message.payloadAppend(audioScale);
                message.payloadAppend(sessionTimeoutSeconds);
                message.payloadAppend(platformDescription);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.debug(TAG, "-sendSessionOpen(" + audioCodec + ", " + audioScale + ", " + sessionTimeoutSeconds + ", " + WtcString.quote(platformDescription) + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSessionOpen(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.debug(TAG, "+processSessionOpen");
            this.connectionManager.traceMessageRawBytes = this.connectionManager.traceMessageRawBytesAfterSessionOpen;
            switch (controlHeader.getOpType()) {
                case 2: {
                    WtcStackListener listener;
                    WtcVersionString serverVersion;
                    String sessionId = inputStream.readString();
                    WtcInt32 serverTime = inputStream.getPosition() < inputStream.getLength() ? WtcInt32.valueOf(inputStream.readInt32(), false) : null;
                    if (inputStream.getPosition() < inputStream.getLength()) {
                        try {
                            serverVersion = new WtcVersionString(inputStream.readString());
                        }
                        catch (Exception e) {
                            serverVersion = null;
                        }
                    } else {
                        serverVersion = null;
                    }
                    if ((listener = this._listener) == null) return;
                    listener.onSessionOpen(this, controlHeader, sessionId, serverTime, serverVersion);
                    return;
                }
                case 4: {
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onSessionOpen(this, controlHeader, errorCode);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processSessionOpen");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendSessionClose() {
        try {
            WtcLog.info(TAG, "+sendSessionClose()");
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(6);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.debug(TAG, "-sendSessionClose()");
        }
    }

    private void processSessionClose(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) throws WtcStackException.WtcStackSessionCloseException {
        try {
            WtcLog.debug(TAG, "+processSessionClose");
            WtcpErrorCode errorCode = null;
            switch (controlHeader.getOpType()) {
                case 3: {
                    errorCode = new WtcpErrorCode(inputStream);
                    break;
                }
                case 2: {
                    errorCode = null;
                    break;
                }
            }
            WtcStackListener listener = this._listener;
            if (listener != null) {
                listener.onSessionClose(this, controlHeader, errorCode);
            }
            throw new WtcStackException.WtcStackSessionCloseException(controlHeader.isUnsolicited(), errorCode);
        }
        catch (Throwable throwable) {
            WtcLog.debug(TAG, "-processSessionClose");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendSetCredentials(String username, String password, String license, String profileId) {
        try {
            WtcStackConnectionManager connectionManager;
            WtcLog.info(TAG, "+sendSetCredentials(" + WtcString.quote(username) + ", " + WtcStack.censor(password) + ", " + WtcString.quote(license) + ", " + WtcString.quote(profileId) + ")");
            if (WtcString.isNullOrEmpty(profileId)) {
                profileId = "";
            }
            if ((connectionManager = this.connectionManager) != null) {
                WtcpMessage message = connectionManager.getMessage(7);
                message.payloadAppend(username);
                message.payloadAppend(password);
                message.payloadAppend(license);
                message.payloadAppend(profileId);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.info(TAG, "-sendSetCredentials(" + WtcString.quote(username) + ", " + WtcStack.censor(password) + ", " + WtcString.quote(license) + ", " + WtcString.quote(profileId) + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSetCredentials(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) throws WtcStackException.WtcStackUserProfilesEmptyException {
        try {
            WtcLog.debug(TAG, "+processSetCredentials");
            switch (controlHeader.getOpType()) {
                case 2: {
                    String localEndpointId = inputStream.readString();
                    byte profileIndex = inputStream.readInt8();
                    WtcpProfileInfoList profiles = new WtcpProfileInfoList(inputStream);
                    WtcpChannelInfoList channels = new WtcpChannelInfoList(inputStream);
                    WtcpStringList phoneLines = new WtcpStringList(inputStream);
                    if (profiles.size() == 0) {
                        throw new WtcStackException.WtcStackUserProfilesEmptyException();
                    }
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    WtcLog.info(TAG, "processSetCredentials(...): Received channels: " + channels);
                    listener.onSetCredentials(this, controlHeader, localEndpointId, profileIndex, profiles, channels, phoneLines);
                    return;
                }
                case 4: {
                    WtcStackListener listener;
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    WtcpProfileInfoList profiles = null;
                    if (errorCode.getErrorCode() == 8) {
                        profiles = new WtcpProfileInfoList(inputStream);
                    }
                    if ((listener = this._listener) == null) return;
                    listener.onSetCredentials(this, controlHeader, errorCode, profiles);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processSetCredentials");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSessionResume(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.debug(TAG, "+processSessionResume");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 4: {
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    String sessionId = inputStream.readString();
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onSessionResume(this, controlHeader, errorCode, sessionId);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processSessionResume");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendChannelSetActive(WtcpChannelIdList channelIds) {
        try {
            WtcStackConnectionManager connectionManager;
            WtcLog.info(TAG, "+sendChannelSetActive(" + channelIds + ")");
            if (channelIds == null) {
                channelIds = new WtcpChannelIdList();
            }
            if ((connectionManager = this.connectionManager) != null) {
                WtcpMessage message = connectionManager.getMessage(10);
                message.payloadAppend(channelIds);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.debug(TAG, "-sendChannelSetActive(" + channelIds + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processChannelSetActive(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.debug(TAG, "+processChannelSetActive");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 3: {
                    WtcpChannelIdErrorDictionary channelIdErrorDictionary = new WtcpChannelIdErrorDictionary(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onChannelSetActive(this, controlHeader, channelIdErrorDictionary);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processChannelSetActive");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer sendChannelActivityRequest(WtcInt32 channelId) {
        try {
            WtcLog.info(TAG, "+sendChannelActivityRequest(" + channelId + ")");
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(12);
                message.payloadAppend(channelId);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.debug(TAG, "-sendChannelActivityRequest(" + channelId + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processChannelActivity(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.debug(TAG, "+processChannelActivity");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 3: {
                    WtcpChannelActivity channelActivity = new WtcpChannelActivity(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onChannelActivity(this, controlHeader, channelActivity);
                    return;
                }
                case 4: {
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onChannelActivity(this, controlHeader, errorCode);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processChannelActivity");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendChannelPushToTalk(WtcpChannelIdList channelIds) {
        try {
            WtcStackConnectionManager connectionManager;
            WtcLog.info(TAG, "+sendChannelPushToTalk(" + channelIds + ")");
            if (channelIds == null) {
                channelIds = new WtcpChannelIdList();
            }
            if ((connectionManager = this.connectionManager) != null) {
                WtcpMessage message = connectionManager.getMessage(13);
                message.payloadAppend(channelIds);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.debug(TAG, "-sendChannelPushToTalk(" + channelIds + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processChannelPushToTalk(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.debug(TAG, "+processChannelPushToTalk");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 3: {
                    WtcpChannelIdErrorDictionary channelIdErrorDictionary = new WtcpChannelIdErrorDictionary(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onChannelPushToTalk(this, controlHeader, channelIdErrorDictionary);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processChannelPushToTalk");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendChannelMute(WtcpChannelIdList channelIds) {
        try {
            WtcStackConnectionManager connectionManager;
            WtcLog.info(TAG, "+sendChannelMute(" + channelIds + ")");
            if (channelIds == null) {
                channelIds = new WtcpChannelIdList();
            }
            if ((connectionManager = this.connectionManager) != null) {
                WtcpMessage message = connectionManager.getMessage(14);
                message.payloadAppend(channelIds);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.debug(TAG, "-sendChannelMute(" + channelIds + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processChannelMute(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.debug(TAG, "+processChannelMute");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 3: {
                    WtcpChannelIdErrorDictionary channelIdErrorDictionary = new WtcpChannelIdErrorDictionary(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onChannelMute(this, controlHeader, channelIdErrorDictionary);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processChannelMute");
        }
    }

    public Integer sendChannelPropertiesGet(int channelId, String[] propertyNames) {
        return this.sendChannelPropertiesGet(WtcInt32.valueOf(channelId, true), new WtcpStringList(propertyNames));
    }

    public Integer sendChannelPropertiesGet(WtcInt32 channelId, String[] propertyNames) {
        return this.sendChannelPropertiesGet(channelId, new WtcpStringList(propertyNames));
    }

    public Integer sendChannelPropertiesGet(int channelId, WtcpStringList propertyNames) {
        return this.sendChannelPropertiesGet(WtcInt32.valueOf(channelId, true), propertyNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendChannelPropertiesGet(WtcInt32 channelId, WtcpStringList propertyNames) {
        try {
            WtcLog.info(TAG, "+sendChannelPropertiesGet(" + channelId + ", " + propertyNames + ")");
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(15);
                message.payloadAppend(channelId);
                message.payloadAppend(propertyNames);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.debug(TAG, "-sendChannelPropertiesGet(" + channelId + ", " + propertyNames + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processChannelPropertiesGet(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.debug(TAG, "+processChannelPropertiesGet");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 3: {
                    int channelId = inputStream.readInt32();
                    WtcpKeyValueList properties = new WtcpKeyValueList(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onChannelPropertiesGet(this, controlHeader, channelId, properties);
                    return;
                }
                case 4: {
                    int channelId = inputStream.readInt32();
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onChannelPropertiesGet(this, controlHeader, channelId, errorCode);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processChannelPropertiesGet");
        }
    }

    public Integer sendChannelPropertiesSet(int channelId, WtcpKeyValueList properties) {
        return this.sendChannelPropertiesSet(WtcInt32.valueOf(channelId, true), properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendChannelPropertiesSet(WtcInt32 channelId, WtcpKeyValueList properties) {
        try {
            WtcLog.info(TAG, "+sendChannelPropertiesSet(" + channelId + ", " + properties + ")");
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(16);
                message.payloadAppend(channelId);
                message.payloadAppend(properties);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.debug(TAG, "-sendChannelPropertiesSet(" + channelId + ", " + properties + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processChannelPropertiesSet(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.debug(TAG, "+processChannelPropertiesSet");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 4: {
                    int channelId = inputStream.readInt32();
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onChannelPropertiesSet(this, controlHeader, channelId, errorCode);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processChannelPropertiesSet");
        }
    }

    public Integer sendEndpointPropertiesSet(WtcpKeyValueList properties) {
        return this.sendEndpointPropertiesSet(ID_ENDPOINT_SELF, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendEndpointPropertiesSet(String endpointId, WtcpKeyValueList properties) {
        try {
            WtcLog.info(TAG, "+sendEndpointPropertiesSet(" + WtcString.quote(endpointId) + ", " + properties + ")");
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(20);
                message.payloadAppend(endpointId);
                message.payloadAppend(properties);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.debug(TAG, "-sendEndpointPropertiesSet(" + WtcString.quote(endpointId) + ", " + properties + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processEndpointPropertiesSet(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.debug(TAG, "+processEndpointPropertiesSet");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 4: {
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    if (!errorCode.isError()) return;
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onEndpointPropertiesSet(this, controlHeader, errorCode);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processEndpointPropertiesSet");
        }
    }

    public Integer sendEndpointLookup(String searchString) {
        WtcInt32 channelId = WtcInt32.valueOf(0, true);
        return this.sendEndpointLookup(channelId, searchString);
    }

    public Integer sendEndpointLookup(WtcInt32 channelId, String searchString) {
        WtcInt32 flagsInclude = WtcInt32.valueOf(64, true);
        return this.sendEndpointLookup(channelId, flagsInclude, searchString);
    }

    public Integer sendEndpointLookup(WtcInt32 channelId, WtcInt32 flagsInclude, String searchString) {
        WtcInt32 flagsExclude = WtcInt32.valueOf(0, true);
        return this.sendEndpointLookup(channelId, flagsInclude, flagsExclude, searchString);
    }

    public Integer sendEndpointLookup(WtcInt32 channelId, WtcInt32 flagsInclude, WtcInt32 flagsExclude, String searchString) {
        return this.sendEndpointLookup(channelId, flagsInclude, flagsExclude, WtcInt8.ZERO, WtcInt16.ZERO, searchString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendEndpointLookup(WtcInt32 channelId, WtcInt32 flagsInclude, WtcInt32 flagsExclude, WtcInt8 pageSize, WtcInt16 pageNumber, String searchString) {
        try {
            WtcLog.info(TAG, "+sendEndpointLookup(" + channelId + ", " + flagsInclude + ", " + flagsExclude + ", " + pageSize + ", " + pageNumber + ", " + WtcString.quote(searchString) + ")");
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(21);
                message.payloadAppend(channelId);
                message.payloadAppend(flagsInclude);
                message.payloadAppend(flagsExclude);
                message.payloadAppend(pageSize);
                message.payloadAppend(pageNumber);
                message.payloadAppend(searchString);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.debug(TAG, "-sendEndpointLookup(" + channelId + ", " + flagsInclude + ", " + flagsExclude + ", " + pageSize + ", " + pageNumber + ", " + WtcString.quote(searchString) + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processEndpointLookup(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.debug(TAG, "+processEndpointLookup");
            switch (controlHeader.getOpType()) {
                case 2: {
                    int channelId = inputStream.readInt32();
                    short pageNumber = inputStream.readInt16();
                    short numberOfPages = inputStream.readInt16();
                    WtcpEndpointInfoList endpoints = new WtcpEndpointInfoList(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onEndpointLookup(this, controlHeader, channelId, pageNumber, numberOfPages, endpoints);
                    return;
                }
                case 4: {
                    int channelId = inputStream.readInt32();
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onEndpointLookup(this, controlHeader, channelId, errorCode);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processEndpointLookup");
        }
    }

    public Integer sendEndpointPropertiesGet(String endpointId, String[] propertyNames) {
        return this.sendEndpointPropertiesGet(endpointId, new WtcpStringList(propertyNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendEndpointPropertiesGet(String endpointId, WtcpStringList propertyNames) {
        try {
            WtcLog.info(TAG, "+sendEndpointPropertiesGet(" + WtcString.quote(endpointId) + ", " + propertyNames + ")");
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(22);
                message.payloadAppend(endpointId);
                message.payloadAppend(propertyNames);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.debug(TAG, "-sendEndpointPropertiesGet(" + WtcString.quote(endpointId) + ", " + propertyNames + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processEndpointPropertiesGet(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.debug(TAG, "+processEndpointPropertiesGet");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 3: {
                    WtcpEndpointProperties endpointProperties = new WtcpEndpointProperties(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onEndpointPropertiesGet(this, controlHeader, endpointProperties);
                    return;
                }
                case 4: {
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onEndpointPropertiesGet(this, controlHeader, errorCode);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processEndpointPropertiesGet");
        }
    }

    public Integer sendEndpointPropertyFilterSet(int filterType, String filter) {
        return this.sendEndpointPropertyFilterSet(WtcInt32.valueOf(filterType, true), filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendEndpointPropertyFilterSet(WtcInt32 filterType, String filter) {
        try {
            WtcLog.info(TAG, "+sendEndpointPropertyFilterSet(" + filterType + ", " + WtcString.quote(filter) + ")");
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(23);
                message.payloadAppend(filterType);
                message.payloadAppend(filter);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.debug(TAG, "-sendEndpointPropertyFilterSet(" + filterType + ", " + WtcString.quote(filter) + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processEndpointPropertyFilterSet(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.debug(TAG, "+processEndpointPropertyFilterSet");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 4: {
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    if (!errorCode.isError()) return;
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onEndpointPropertyFilterSet(this, controlHeader, errorCode);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processEndpointPropertyFilterSet");
        }
    }

    @Override
    public short onPingRequestRxTimeout(long timeoutMs, long elapsedMs, short lastPingRequestTxId) {
        Date ago = new Date(System.currentTimeMillis() - elapsedMs);
        Calendar cal = Calendar.getInstance();
        cal.setTime(ago);
        String since = sLogCatDateFormat.format(cal.getTime());
        WtcLog.warn(TAG, "$HEALTH: Did not RX PING Request in " + timeoutMs + "ms since " + since);
        WtcLog.warn(TAG, "$HEALTH: TXing PING Request; expecting RX PING Response or onMessageResponseTimeout.");
        int result = -1;
        WtcStackListener listener = this._listener;
        if (listener != null) {
            result = listener.onPingRequestRxTimeout(this, timeoutMs, elapsedMs, lastPingRequestTxId);
        }
        if (result == -1) {
            lastPingRequestTxId = (short)(lastPingRequestTxId + 1);
            this.sendPingRequest(lastPingRequestTxId);
        }
        return lastPingRequestTxId;
    }

    public Integer sendPingRequest(short id) {
        return this.sendPingRequest(new WtcInt16(id));
    }

    public Integer sendPingRequest(WtcInt16 id) {
        return this.sendPing(1, id);
    }

    public void sendPingResponse(WtcInt16 id) {
        this.sendPing(2, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Integer sendPing(int opType, WtcInt16 id) {
        block7: {
            Integer n;
            try {
                WtcStackConnectionManager connectionManager;
                WtcLog.info(TAG, "+sendPing(" + WtcpConstants.WtcpOpType.toString(opType) + ", " + id + ")");
                Object object = this.syncPingId;
                // MONITORENTER : object
                if (opType == 1) {
                    this.lastPingRequestId = id.value;
                }
                if ((connectionManager = this.connectionManager) == null) break block7;
                WtcpMessage message = connectionManager.getMessage(opType, 2);
                message.payloadAppend(id);
                n = connectionManager.send(message);
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                WtcLog.debug(TAG, "-sendPing(" + WtcpConstants.WtcpOpType.toString(opType) + ", " + id + ")");
                throw throwable;
            }
            WtcLog.debug(TAG, "-sendPing(" + WtcpConstants.WtcpOpType.toString(opType) + ", " + id + ")");
            return n;
        }
        Integer n = null;
        // MONITOREXIT : object
        WtcLog.debug(TAG, "-sendPing(" + WtcpConstants.WtcpOpType.toString(opType) + ", " + id + ")");
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPing(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcStackConnectionManager connectionManager;
            WtcStackListener listener;
            WtcLog.debug(TAG, "+processPing");
            WtcInt16 pingId = null;
            switch (controlHeader.getOpType()) {
                case 1: {
                    pingId = new WtcInt16(inputStream);
                    WtcLog.info(TAG, "lastPingRequestId=" + this.lastPingRequestId);
                    WtcLog.info(TAG, "RX Ping Request id=" + pingId + "; TX Ping Response id=" + pingId);
                    this.sendPingResponse(pingId);
                    break;
                }
                case 2: {
                    pingId = new WtcInt16(inputStream);
                    WtcLog.info(TAG, "RX Ping Response id=" + pingId);
                    break;
                }
                case 3: {
                    pingId = new WtcInt16(inputStream);
                    WtcLog.info(TAG, "RX Ping Unsolicited id=" + pingId + "; ignoring");
                    break;
                }
            }
            if (pingId != null && (listener = this._listener) != null) {
                listener.onPing(this, controlHeader, pingId.value);
            }
            if ((connectionManager = this.connectionManager) != null) {
                connectionManager.maintenance();
            }
        }
        finally {
            WtcLog.debug(TAG, "-processPing");
        }
    }

    public Integer sendPhoneLineSetActive(String phoneLine) {
        WtcpStringList phoneLines = new WtcpStringList();
        phoneLines.addElement(phoneLine);
        return this.sendPhoneLinesSetActive(phoneLines);
    }

    public Integer sendPhoneLinesSetActive(String[] phoneLines) {
        return this.sendPhoneLinesSetActive(new WtcpStringList(phoneLines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendPhoneLinesSetActive(WtcpStringList phoneLines) {
        try {
            WtcLog.info(TAG, "+sendPhoneLinesSetActive(" + phoneLines + ")");
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(30);
                message.payloadAppend(phoneLines);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.debug(TAG, "-sendPhoneLinesSetActive(" + phoneLines + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPhoneLinesSetActive(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.info(TAG, "+processPhoneLinesSetActive");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 4: {
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onPhoneLinesSetActive(this, controlHeader, errorCode);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.info(TAG, "-processPhoneLinesSetActive");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPhoneLineStatus(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.info(TAG, "+processPhoneLineStatus");
            switch (controlHeader.getOpType()) {
                case 3: {
                    String phoneLine = inputStream.readString();
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onPhoneLineStatus(this, controlHeader, phoneLine, errorCode);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.info(TAG, "-processPhoneLineStatus");
        }
    }

    public Integer sendCallMake(byte callType, String source, String destination) {
        return this.sendCallMake(new WtcInt8(callType), source, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendCallMake(WtcInt8 callType, String source, String destination) {
        try {
            WtcLog.info(TAG, "+sendCallMake(" + callType + ", " + WtcString.quote(source) + ", " + WtcString.quote(destination) + ")");
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(32);
                message.payloadAppend(callType);
                message.payloadAppend(source);
                message.payloadAppend(destination);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.info(TAG, "-sendCallMake(" + callType + ", " + WtcString.quote(source) + ", " + WtcString.quote(destination) + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCallMake(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.info(TAG, "+processCallMake");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 4: {
                    WtcpCallInfo callInfo = new WtcpCallInfo(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onCallMake(this, controlHeader, callInfo);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.info(TAG, "-processCallMake");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCallProgress(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.info(TAG, "+processCallProgress");
            switch (controlHeader.getOpType()) {
                case 3: {
                    WtcpCallProgress callProgress = new WtcpCallProgress(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onCallProgress(this, controlHeader, callProgress);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.info(TAG, "-processCallProgress");
        }
    }

    public Integer sendCallHangup(int callId) {
        return this.sendCallHangup(WtcInt32.valueOf(callId, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendCallHangup(WtcInt32 callId) {
        try {
            WtcLog.info(TAG, "+sendCallHangup(" + callId + ")");
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(35);
                message.payloadAppend(callId);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.info(TAG, "-sendCallHangup(" + callId + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCallHangup(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.info(TAG, "+processCallHangup");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 3: 
                case 4: {
                    WtcpCallHangup callHangup = new WtcpCallHangup(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onCallHangup(this, controlHeader, callHangup);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.info(TAG, "-processCallHangup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCallOffer(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.info(TAG, "+processCallOffer");
            switch (controlHeader.getOpType()) {
                case 3: {
                    WtcpCallOffer callOffer = new WtcpCallOffer(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onCallOffer(this, controlHeader, callOffer);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.info(TAG, "-processCallOffer");
        }
    }

    public Integer sendCallAnswer(int callId) {
        return this.sendCallAnswer(WtcInt32.valueOf(callId, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendCallAnswer(WtcInt32 callId) {
        try {
            WtcLog.info(TAG, "+sendCallAnswer(" + callId + ")");
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(34);
                message.payloadAppend(callId);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.info(TAG, "-sendCallAnswer(" + callId + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCallAnswer(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.info(TAG, "+processCallAnswer");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 4: {
                    WtcpCallAnswer callAnswer = new WtcpCallAnswer(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onCallAnswer(this, controlHeader, callAnswer);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.info(TAG, "-processCallAnswer");
        }
    }

    public Integer sendCallDtmf(int callId, String digits) {
        return this.sendCallDtmf(WtcInt32.valueOf(callId, true), digits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendCallDtmf(WtcInt32 callId, String digits) {
        try {
            WtcLog.info(TAG, "+sendCallDtmf(" + callId + ", " + WtcString.quote(digits) + ")");
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(36);
                message.payloadAppend(callId);
                message.payloadAppend(digits);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.info(TAG, "-sendCallDtmf(" + callId + ", " + WtcString.quote(digits) + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCallDtmf(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.info(TAG, "+processCallDtmf");
            switch (controlHeader.getOpType()) {
                case 2: {
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onCallDtmf(this, controlHeader);
                    return;
                }
                case 4: {
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onCallDtmf(this, controlHeader, errorCode);
                    return;
                }
                case 3: {
                    WtcpCallDtmf callDtmf = new WtcpCallDtmf(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onCallDtmf(this, controlHeader, callDtmf);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.info(TAG, "-processCallDtmf");
        }
    }

    public Integer sendCallPushToTalk(int callId, boolean on) {
        return this.sendCallPushToTalk(WtcInt32.valueOf(callId, true), on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendCallPushToTalk(WtcInt32 callId, boolean on) {
        try {
            WtcLog.info(TAG, "+sendCallPushToTalk(" + callId + ", " + on + ")");
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                int opCode = on ? 38 : 39;
                WtcpMessage message = connectionManager.getMessage(opCode);
                message.payloadAppend(callId);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.debug(TAG, "-sendCallPushToTalk(" + callId + ", " + on + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCallPushToTalkOn(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.debug(TAG, "+processCallPushToTalkOn");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 3: 
                case 4: {
                    WtcInt32 callId = WtcInt32.valueOf(inputStream.readInt32(), true);
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onCallPushToTalkOn(this, controlHeader, callId, errorCode);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processCallPushToTalkOn");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCallPushToTalkOff(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.debug(TAG, "+processCallPushToTalkOff");
            switch (controlHeader.getOpType()) {
                case 2: 
                case 3: 
                case 4: {
                    WtcInt32 callId = WtcInt32.valueOf(inputStream.readInt32(), true);
                    WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onCallPushToTalkOff(this, controlHeader, callId, errorCode);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.debug(TAG, "-processCallPushToTalkOff");
        }
    }

    public Integer sendAddressBookRequest(short version, String filter) {
        return this.sendAddressBookRequest(new WtcInt16(version), filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sendAddressBookRequest(WtcInt16 version, String filter) {
        try {
            WtcLog.info(TAG, "+sendAddressBookRequest(" + version + ", " + WtcString.quote(filter) + ")");
            if (FAKE_ADDRESS_BOOK) {
                this.processAddressBook(new WtcpControlHeader(-1, -1, 2, 50), null);
                Integer n = null;
                return n;
            }
            WtcStackConnectionManager connectionManager = this.connectionManager;
            if (connectionManager != null) {
                WtcpMessage message = connectionManager.getMessage(50);
                message.payloadAppend(version);
                message.payloadAppend(filter);
                Integer n = connectionManager.send(message);
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            WtcLog.info(TAG, "-sendAddressBookRequest(" + version + ", " + WtcString.quote(filter) + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processAddressBook(WtcpControlHeader controlHeader, IWtcMemoryStream inputStream) {
        try {
            WtcLog.info(TAG, "+processAddressBook");
            switch (controlHeader.getOpType()) {
                case 2: {
                    WtcpAddressBookInfoList addressBookInfoList;
                    WtcpErrorCode errorCode;
                    WtcInt16 version;
                    if (FAKE_ADDRESS_BOOK) {
                        version = new WtcInt16(1);
                        errorCode = WtcpErrorCode.OK;
                        addressBookInfoList = WtcpAddressBookInfoList.FAKE;
                    } else {
                        version = new WtcInt16(inputStream);
                        errorCode = new WtcpErrorCode(inputStream);
                        addressBookInfoList = new WtcpAddressBookInfoList(inputStream);
                    }
                    WtcStackListener listener = this._listener;
                    if (listener == null) return;
                    listener.onAddressBook(this, controlHeader, version, errorCode, addressBookInfoList);
                    return;
                }
            }
            return;
        }
        finally {
            WtcLog.info(TAG, "-processAddressBook");
        }
    }
}

