/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcLocatorErrorCodes;
import com.twistpair.wave.thinclient.util.StringWriterPlatform;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class WtcLocatorException
extends Exception {
    private static final long serialVersionUID = 2549854582528627988L;
    public final Exception innerException;

    protected WtcLocatorException() {
        this.innerException = null;
    }

    protected WtcLocatorException(Exception innerException) {
        this.innerException = innerException;
    }

    protected WtcLocatorException(String message) {
        super(message);
        this.innerException = null;
    }

    public static class WtcLocatorErrorException
    extends WtcLocatorException {
        private static final long serialVersionUID = -2792764847097376908L;
        public final int errorCode;

        public WtcLocatorErrorException(int errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public String toString() {
            return "WtcLocatorErrorException [errorCode=" + WtcLocatorErrorCodes.toString(this.errorCode) + "]";
        }
    }

    public static class WtcLocatorResponseInvalidException
    extends WtcLocatorException {
        private static final long serialVersionUID = -8172904600287497520L;
        public final String response;

        public WtcLocatorResponseInvalidException(String message, Node response) {
            super(message);
            this.response = WtcLocatorResponseInvalidException.xmlToString1(response);
        }

        public WtcLocatorResponseInvalidException(Exception innerException, String response) {
            super(innerException);
            this.response = response;
        }

        public static String xmlToString1(Node node) {
            if (node == null) {
                throw new IllegalArgumentException("node cannot be null");
            }
            Document document = node.getOwnerDocument();
            DOMImplementation domImplementation = document.getImplementation();
            if (domImplementation.hasFeature("LS", "3.0") && domImplementation.hasFeature("Core", "2.0")) {
                DOMImplementationLS domImplementationLS = (DOMImplementationLS)domImplementation.getFeature("LS", "3.0");
                LSSerializer lsSerializer = domImplementationLS.createLSSerializer();
                DOMConfiguration domConfiguration = lsSerializer.getDomConfig();
                if (domConfiguration.canSetParameter("format-pretty-print", Boolean.TRUE)) {
                    lsSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
                    LSOutput lsOutput = domImplementationLS.createLSOutput();
                    lsOutput.setEncoding("UTF-8");
                    StringWriterPlatform stringWriter = new StringWriterPlatform();
                    lsOutput.setCharacterStream(stringWriter);
                    lsSerializer.write(document, lsOutput);
                    return stringWriter.toString();
                }
                throw new RuntimeException("DOMConfiguration 'format-pretty-print' parameter isn't settable.");
            }
            throw new RuntimeException("DOM 3.0 LS and/or DOM 2.0 Core not supported.");
        }
    }
}

