/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.protocol.WtcpConstants;
import com.twistpair.wave.thinclient.util.WtcIntegerObjectMapPlatform;
import java.util.Enumeration;

public class WtcConnectionStatistics {
    private static final String TAG = WtcLog.TAG(WtcConnectionStatistics.class);
    private static final boolean VERBOSE_LOG = false;
    private int locatorAttempts = 0;
    private int locatorSuccess = 0;
    private int proxyConnectAttempts = 0;
    private int proxyConnectSuccess = 0;
    private int proxyDisconnects = 0;
    private final WtcMessageCounter messageCounterTotal;
    private final WtcIntegerObjectMapPlatform messageCounterByType;
    public final LatencyHistory latency = new LatencyHistory();
    public final Jitter jitter = new Jitter();

    public WtcConnectionStatistics() {
        this.messageCounterTotal = new WtcMessageCounter();
        this.messageCounterByType = new WtcIntegerObjectMapPlatform();
        this.messageCounterByType.put(0, (Object)new WtcMessageCounter());
        this.messageCounterByType.put(1, (Object)new WtcMessageCounter());
        this.messageCounterByType.put(2, (Object)new WtcMessageCounter());
        this.messageCounterByType.put(3, (Object)new WtcMessageCounter());
        this.messageCounterByType.put(4, (Object)new WtcMessageCounter());
        this.messageCounterByType.put(5, (Object)new WtcMessageCounter());
        this.messageCounterByType.put(6, (Object)new WtcMessageCounter());
        this.messageCounterByType.put(7, (Object)new WtcMessageCounter());
        this.reset();
    }

    public void reset() {
        this.locatorAttempts = 0;
        this.locatorSuccess = 0;
        this.proxyConnectAttempts = 0;
        this.proxyConnectSuccess = 0;
        this.proxyDisconnects = 0;
        this.messageCounterTotal.reset();
        Enumeration keys = this.messageCounterByType.keys();
        while (keys.hasMoreElements()) {
            byte messageType = ((Integer)keys.nextElement()).byteValue();
            WtcMessageCounter messageCounter = (WtcMessageCounter)this.messageCounterByType.get(messageType);
            messageCounter.reset();
        }
        this.latency.reset();
        this.jitter.reset();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append('{').append("locatorAttempts=").append(this.locatorAttempts).append(", locatorSuccess=").append(this.locatorSuccess).append(", proxyConnectAttempts=").append(this.proxyConnectAttempts).append(", proxyConnectSuccess=").append(this.proxyConnectSuccess).append(", proxyDisconnects=").append(this.proxyDisconnects).append(", messageCounterTotal=").append(this.messageCounterTotal);
        sb.append(", messageCounterByType={");
        Enumeration keys = this.messageCounterByType.keys();
        while (keys.hasMoreElements()) {
            byte messageType = ((Integer)keys.nextElement()).byteValue();
            WtcMessageCounter messageCounter = (WtcMessageCounter)this.messageCounterByType.get(messageType);
            sb.append(WtcpConstants.WtcpMessageType.toString(messageType)).append(':').append(messageCounter);
            if (!keys.hasMoreElements()) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.append(", Latency=").append(this.latency).append('}').toString();
    }

    public void log() {
        WtcLog.debug(TAG, "$STATISTICS: " + this.toString());
        this.latency.log();
    }

    public void incLocatorAttempts() {
        ++this.locatorAttempts;
    }

    public int getLocatorAttempts() {
        return this.locatorAttempts;
    }

    public void incLocatorSuccess() {
        ++this.locatorSuccess;
    }

    public int getLocatorSuccess() {
        return this.locatorSuccess;
    }

    public void incProxyConnectAttempts() {
        ++this.proxyConnectAttempts;
    }

    public int getProxyConnectAttempts() {
        return this.proxyConnectAttempts;
    }

    public void incProxyConnectSuccess() {
        ++this.proxyConnectSuccess;
    }

    public int getProxyConnectSuccess() {
        return this.proxyConnectSuccess;
    }

    public void incProxyDisconnects() {
        ++this.proxyDisconnects;
    }

    public int getProxyDisconnects() {
        return this.proxyDisconnects;
    }

    void incTxed(byte messageType, long length) {
        this.messageCounterTotal.incTxed(length);
        this.getMessageCounterByType(messageType).incTxed(length);
    }

    void incRxed(byte messageType, long length) {
        this.messageCounterTotal.incRxed(length);
        this.getMessageCounterByType(messageType).incRxed(length);
    }

    public WtcMessageCounter getMessageCounterTotal() {
        return this.messageCounterTotal;
    }

    public WtcMessageCounter getMessageCounterByType(byte messageType) {
        return (WtcMessageCounter)this.messageCounterByType.get(messageType);
    }

    public class WtcMessageCounter {
        long txedMessages;
        long txedBytes;
        long rxedMessages;
        long rxedBytes;

        public long getTxedMessages() {
            return this.txedMessages;
        }

        public long getTxedBytes() {
            return this.txedBytes;
        }

        public long getRxedMessages() {
            return this.rxedMessages;
        }

        public long getRxedBytes() {
            return this.rxedBytes;
        }

        public void reset() {
            this.txedMessages = 0L;
            this.txedBytes = 0L;
            this.rxedMessages = 0L;
            this.rxedBytes = 0L;
        }

        void incTxed(long length) {
            ++this.txedMessages;
            this.txedBytes += length;
        }

        void incRxed(long length) {
            ++this.rxedMessages;
            this.rxedBytes += length;
        }

        public String toString() {
            return new StringBuffer().append('{').append("TxedMessages=").append(this.txedMessages).append(", TxedBytes=").append(this.txedBytes).append(", RxedMessages=").append(this.rxedMessages).append(", RxedBytes=").append(this.rxedBytes).append('}').toString();
        }
    }

    public class Jitter {
        private final String TAG = WtcLog.TAG(Jitter.class);
        public static final int HISTORY_SIZE = 10;
        private long count;
        private long sumMs;
        private int bestMs;
        private int worstMs;
        private int averageMs;
        private int averageMsLastX;
        private int sumMsLastX;
        private long previousMs;

        public long getCount() {
            return this.count;
        }

        public long getSumMs() {
            return this.sumMs;
        }

        public int getBestMs() {
            return this.bestMs;
        }

        public int getWorstMs() {
            return this.worstMs;
        }

        public int getAverageMs() {
            return this.averageMs;
        }

        public int getAverageMsLastX() {
            return this.averageMsLastX;
        }

        public Jitter() {
            this.reset();
        }

        public synchronized void reset() {
            this.count = 0L;
            this.sumMs = 0L;
            this.bestMs = Integer.MAX_VALUE;
            this.worstMs = Integer.MIN_VALUE;
            this.averageMs = 0;
            this.averageMsLastX = 0;
            this.sumMsLastX = 0;
            this.previousMs = 0L;
        }

        public synchronized void log() {
            WtcLog.debug(this.TAG, "$JITTER: count=" + this.count + ", sumMs=" + this.sumMs);
        }

        public synchronized void add(int latencyMs) {
            if (latencyMs < this.bestMs) {
                this.bestMs = latencyMs;
            }
            if (latencyMs > this.worstMs) {
                this.worstMs = latencyMs;
            }
            ++this.count;
            this.sumMs += (long)latencyMs;
            this.averageMs = (int)(this.sumMs / this.count);
            if (this.count >= 10L) {
                this.sumMsLastX = (int)((long)this.sumMsLastX - this.previousMs + (long)latencyMs);
                this.averageMsLastX = this.sumMsLastX / 10;
            } else {
                this.sumMsLastX = (int)this.sumMs;
                this.averageMsLastX = this.averageMs;
            }
            this.previousMs = latencyMs;
        }
    }

    public class LatencyHistory {
        private final String TAG = WtcLog.TAG(LatencyHistory.class);
        public static final int HISTORY_SIZE = 10;
        private long count;
        private long sumMs;
        private int bestMs;
        private int worstMs;
        private int averageMs;
        private int averageMsLastX;
        private int sumMsLastX;
        private long previousMs;
        private int requestTimeoutMs;

        public long getCount() {
            return this.count;
        }

        public long getSumMs() {
            return this.sumMs;
        }

        public int getBestMs() {
            return this.bestMs;
        }

        public int getWorstMs() {
            return this.worstMs;
        }

        public int getAverageMs() {
            return this.averageMs;
        }

        public int getAverageMsLastX() {
            return this.averageMsLastX;
        }

        public int getRequestTimeoutMs() {
            return this.requestTimeoutMs;
        }

        public LatencyHistory() {
            this.reset();
        }

        public synchronized void reset() {
            this.count = 0L;
            this.sumMs = 0L;
            this.bestMs = Integer.MAX_VALUE;
            this.worstMs = Integer.MIN_VALUE;
            this.averageMs = 0;
            this.averageMsLastX = 0;
            this.sumMsLastX = 0;
            this.previousMs = 0L;
            this.requestTimeoutMs = 30000;
        }

        public synchronized void log() {
            WtcLog.debug(this.TAG, "$LATENCY: " + this);
        }

        public synchronized int add(int latencyMs) {
            if (latencyMs < this.bestMs) {
                this.bestMs = latencyMs;
            }
            if (latencyMs > this.worstMs) {
                this.worstMs = latencyMs;
            }
            ++this.count;
            this.sumMs += (long)latencyMs;
            this.averageMs = (int)(this.sumMs / this.count);
            if (this.count >= 10L) {
                this.sumMsLastX = (int)((long)this.sumMsLastX - this.previousMs + (long)latencyMs);
                this.averageMsLastX = this.sumMsLastX / 10;
            } else {
                this.sumMsLastX = (int)this.sumMs;
                this.averageMsLastX = this.averageMs;
            }
            this.requestTimeoutMs = 10000 + 2 * Math.max(this.averageMs, this.averageMsLastX);
            this.previousMs = latencyMs;
            return this.requestTimeoutMs;
        }

        public String toString() {
            return new StringBuffer().append('{').append("count=").append(this.count).append(", sumMs=").append(this.sumMs).append(", bestMs=").append(this.bestMs).append(", worstMs=").append(this.worstMs).append(", averageMs=").append(this.averageMs).append(", sumMsLastX=").append(this.sumMsLastX).append(", averageMsLastX=").append(this.averageMsLastX).append(", requestTimeoutMs=").append(this.requestTimeoutMs).append('}').toString();
        }
    }
}

