/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcClientPhoneCall;
import com.twistpair.wave.thinclient.WtcClientPhoneCallManager;
import com.twistpair.wave.thinclient.WtcClientPhoneLineManager;
import com.twistpair.wave.thinclient.WtcStack;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.util.WtcString;

public class WtcClientPhoneLine {
    private static final String TAG = WtcLog.TAG(WtcClientPhoneLine.class);
    private final WtcStack mStack;
    private final WtcClientPhoneLineManager mLineManager;
    private final String mNumber;
    protected boolean mIsActivated;
    private WtcClientPhoneCall mPhoneCall;

    protected WtcClientPhoneLine(WtcStack stack, WtcClientPhoneLineManager lineManager, String number) {
        if (stack == null) {
            throw new IllegalArgumentException("stack cannot be null");
        }
        if (lineManager == null) {
            throw new IllegalArgumentException("lineManager cannot be null");
        }
        if (WtcString.isNullOrEmpty(number)) {
            throw new IllegalArgumentException("number cannot be null/\"\"");
        }
        this.mStack = stack;
        this.mLineManager = lineManager;
        this.mNumber = number;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append('{').append("number=").append(WtcString.quote(this.mNumber)).append(", activated=").append(this.mIsActivated).append('}');
        return sb.toString();
    }

    protected WtcStack getStack() {
        return this.mStack;
    }

    public String getNumber() {
        return this.mNumber;
    }

    public boolean getIsActivated() {
        return this.mIsActivated;
    }

    public WtcClientPhoneCall getPhoneCall() {
        return this.mPhoneCall;
    }

    protected void setPhoneCall(WtcClientPhoneCall phoneCall) {
        this.mPhoneCall = phoneCall;
    }

    public Integer activate(boolean on) {
        return this.mLineManager.activate(this, on);
    }

    public Integer callEndpoint(String remoteEndpointId, String remoteName) {
        return this.call((byte)1, remoteEndpointId, remoteName);
    }

    public Integer callNumber(String remoteNumber, String remoteName) {
        return this.call((byte)2, remoteNumber, remoteName);
    }

    protected Integer call(byte callType, String remoteNumberOrEndpointId, String remoteName) {
        WtcClientPhoneCallManager callManager = this.mLineManager.getPhoneCallManager();
        return callManager == null ? null : callManager.call(this, callType, remoteNumberOrEndpointId, remoteName);
    }
}

