/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcClient;
import com.twistpair.wave.thinclient.WtcClientListener;
import com.twistpair.wave.thinclient.WtcClientPhoneCall;
import com.twistpair.wave.thinclient.WtcClientPhoneLine;
import com.twistpair.wave.thinclient.WtcClientPhoneLineManager;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.protocol.WtcpConstants;
import com.twistpair.wave.thinclient.protocol.headers.WtcpControlHeader;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallAnswer;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallDtmf;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallHangup;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallInfo;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallOffer;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallProgress;
import com.twistpair.wave.thinclient.protocol.types.WtcpErrorCode;
import com.twistpair.wave.thinclient.util.WtcInt32;
import com.twistpair.wave.thinclient.util.WtcIntegerObjectMapPlatform;
import com.twistpair.wave.thinclient.util.WtcString;

public class WtcClientPhoneCallManager {
    private static final String TAG = WtcLog.TAG(WtcClientPhoneCallManager.class);
    private final WtcClientListener mListener;
    private final WtcClient mClient;
    private final Object mSyncLock = new Object();
    private final WtcIntegerObjectMapPlatform mPhoneCalls = new WtcIntegerObjectMapPlatform();
    private final WtcIntegerObjectMapPlatform mCallMakeTransactionIdToCallMakeWrapper = new WtcIntegerObjectMapPlatform();
    private final WtcIntegerObjectMapPlatform mCallDtmfTransactionIdToCallDtmfWrapper = new WtcIntegerObjectMapPlatform();
    private WtcClientPhoneCall mPhoneCallConnected;

    protected WtcClientPhoneCallManager(WtcClient client, WtcClientListener listener) {
        if (client == null) {
            throw new IllegalArgumentException("client cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.mClient = client;
        this.mListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        WtcLog.info(TAG, "+clear()");
        Object object = this.mSyncLock;
        synchronized (object) {
            this.mPhoneCalls.clear();
            this.mPhoneCallConnected = null;
            this.mCallMakeTransactionIdToCallMakeWrapper.clear();
            this.mCallDtmfTransactionIdToCallDtmfWrapper.clear();
        }
        WtcLog.info(TAG, "-clear()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsCallInProgressOrConnected() {
        Object object = this.mSyncLock;
        synchronized (object) {
            return this.mPhoneCallConnected != null || this.mPhoneCalls.size() > 0 || this.mCallMakeTransactionIdToCallMakeWrapper.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WtcClientPhoneCall getConnectedPhoneCall() {
        Object object = this.mSyncLock;
        synchronized (object) {
            return this.mPhoneCallConnected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WtcClientPhoneCall getPhoneCall(int callId) {
        Object object = this.mSyncLock;
        synchronized (object) {
            return (WtcClientPhoneCall)this.mPhoneCalls.get(callId);
        }
    }

    protected Integer call(byte callType, String phoneLineNumber, String remoteNumber, String remoteName) {
        WtcClientPhoneLine phoneLine;
        Integer transactionId = null;
        WtcClientPhoneLineManager lineManager = this.mClient.getPhoneLineManager();
        if (lineManager != null && (phoneLine = lineManager.getPhoneLine(phoneLineNumber)) != null) {
            transactionId = this.call(phoneLine, callType, remoteNumber, remoteName);
        }
        return transactionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer call(WtcClientPhoneLine phoneLine, byte callType, String remoteNumber, String remoteName) {
        Integer n;
        Integer transactionId = null;
        String signature = "call(phoneLine=" + phoneLine + ", callType=" + WtcpConstants.WtcpCallType.toString(callType) + ", remoteNumber=" + WtcString.quote(remoteNumber) + ", remoteName=" + WtcString.quote(remoteName) + ")";
        try {
            WtcLog.info(TAG, "+" + signature);
            transactionId = phoneLine.getStack().sendCallMake(callType, phoneLine.getNumber(), remoteNumber);
            if (transactionId != null) {
                CallMakeWrapper callMakeWrapper = new CallMakeWrapper(phoneLine, callType, remoteName);
                Object object = this.mSyncLock;
                synchronized (object) {
                    this.mCallMakeTransactionIdToCallMakeWrapper.put((int)transactionId, (Object)callMakeWrapper);
                }
            }
            n = transactionId;
        }
        catch (Throwable throwable) {
            WtcLog.info(TAG, "-" + signature + "; return " + transactionId);
            throw throwable;
        }
        WtcLog.info(TAG, "-" + signature + "; return " + transactionId);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCallMake(WtcpControlHeader controlHeader, WtcpCallInfo callInfo) {
        String signature = "onCallMake(..., callInfo=" + callInfo + ")";
        boolean isOK = callInfo.errorCode.isOK();
        try {
            CallMakeWrapper callMakeWrapper;
            if (isOK) {
                WtcLog.info(TAG, "+" + signature);
            } else {
                WtcLog.warn(TAG, "+" + signature);
            }
            int transactionId = controlHeader.transactionId;
            Object object = this.mSyncLock;
            synchronized (object) {
                callMakeWrapper = (CallMakeWrapper)this.mCallMakeTransactionIdToCallMakeWrapper.remove(transactionId);
            }
            boolean handled = false;
            if (callMakeWrapper != null) {
                if (isOK) {
                    WtcClientPhoneCall phoneCall = null;
                    int callId = callInfo.callId;
                    phoneCall = new WtcClientPhoneCall(this, callMakeWrapper, callInfo);
                    Object object2 = this.mSyncLock;
                    synchronized (object2) {
                        this.mPhoneCalls.put(callId, (Object)phoneCall);
                    }
                    if (this.mListener != null) {
                        handled = this.mListener.onCallMake(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneCall);
                    }
                } else if (this.mListener != null) {
                    handled = this.mListener.onCallMakeError(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, callMakeWrapper.mCallType, callMakeWrapper.mPhoneLine, callInfo.remoteNumber, callMakeWrapper.mRemoteName, callInfo.errorCode);
                }
            } else {
                WtcLog.error(TAG, "mCallMakeTransactionIdToCallMakeInfo.remove(" + transactionId + ") returned null!");
            }
            if (!handled && this.mListener != null) {
                this.mListener.onCallMake(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, callInfo);
            }
        }
        finally {
            if (isOK) {
                WtcLog.info(TAG, "-" + signature);
            } else {
                WtcLog.warn(TAG, "-" + signature);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCallProgress(WtcpControlHeader controlHeader, WtcpCallProgress callProgress) {
        try {
            WtcLog.info(TAG, "+onCallProgress(..., callProgress=" + callProgress + ")");
            int callId = callProgress.callId;
            boolean handled = false;
            WtcClientPhoneCall phoneCall = this.getPhoneCall(callId);
            if (phoneCall != null) {
                phoneCall.setCallProgressState(callProgress.progress);
                if (this.mListener != null) {
                    switch (callProgress.progress) {
                        case 1: {
                            handled = this.mListener.onCallProceeding(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneCall);
                            break;
                        }
                        case 2: {
                            handled = this.mListener.onCallRinging(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneCall);
                            break;
                        }
                        case 3: {
                            Object object = this.mSyncLock;
                            synchronized (object) {
                                this.mPhoneCallConnected = phoneCall;
                            }
                            handled = this.mListener.onCallConnected(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneCall);
                            break;
                        }
                        default: {
                            WtcLog.error(TAG, "onCallProgress: UNKNOWN progress=" + callProgress.progress);
                        }
                    }
                }
            }
            if (!handled && this.mListener != null) {
                this.mListener.onCallProgress(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, callProgress);
            }
        }
        finally {
            WtcLog.info(TAG, "-onCallProgress(..., callProgress=" + callProgress + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCallOffer(WtcpControlHeader controlHeader, WtcpCallOffer callOffer) {
        try {
            String phoneLineNumber;
            WtcClientPhoneLine phoneLine;
            WtcLog.info(TAG, "+onCallOffer(..., callOffer=" + callOffer + ")");
            int callId = callOffer.callId;
            WtcClientPhoneCall phoneCall = null;
            WtcClientPhoneLineManager lineManager = this.mClient.getPhoneLineManager();
            if (lineManager != null && (phoneLine = lineManager.getPhoneLine(phoneLineNumber = callOffer.toNumber)) != null) {
                phoneCall = new WtcClientPhoneCall(this, phoneLine, callOffer);
                Object object = this.mSyncLock;
                synchronized (object) {
                    this.mPhoneCalls.put(callId, (Object)phoneCall);
                }
            }
            boolean handled = false;
            if (phoneCall != null && this.mListener != null) {
                handled = this.mListener.onCallOffer(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneCall);
            }
            if (!handled && this.mListener != null) {
                this.mListener.onCallOffer(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, callOffer);
            }
        }
        finally {
            WtcLog.info(TAG, "-onCallOffer(..., callOffer=" + callOffer + ")");
        }
    }

    protected Integer answer(int callId) {
        WtcClientPhoneCall phoneCall = this.getPhoneCall(callId);
        return phoneCall == null ? null : this.answer(phoneCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer answer(WtcClientPhoneCall phoneCall) {
        Integer n;
        Integer transactionId = null;
        try {
            WtcLog.info(TAG, "+answer(phoneCall=" + phoneCall + ")");
            n = transactionId = phoneCall.getStack().sendCallAnswer(phoneCall.getCallId());
        }
        catch (Throwable throwable) {
            WtcLog.info(TAG, "-answer(phoneCall=" + phoneCall + "); return " + transactionId);
            throw throwable;
        }
        WtcLog.info(TAG, "-answer(phoneCall=" + phoneCall + "); return " + transactionId);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCallAnswer(WtcpControlHeader controlHeader, WtcpCallAnswer callAnswer) {
        String signature = "onCallAnswer(..., callAnswer=" + callAnswer + ")";
        WtcpErrorCode errorCode = callAnswer.errorCode;
        boolean isOK = errorCode.isOK();
        try {
            if (isOK) {
                WtcLog.info(TAG, "+" + signature);
            } else {
                WtcLog.warn(TAG, "+" + signature);
            }
            int callId = callAnswer.callId;
            boolean handled = false;
            WtcClientPhoneCall phoneCall = this.getPhoneCall(callId);
            if (phoneCall != null) {
                if (isOK) {
                    if (this.mListener != null) {
                        handled = this.mListener.onCallAnswered(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneCall);
                    }
                } else if (this.mListener != null) {
                    handled = this.mListener.onCallAnswerError(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneCall, errorCode);
                }
            }
            if (!handled && this.mListener != null) {
                this.mListener.onCallAnswer(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, callAnswer);
            }
        }
        finally {
            if (isOK) {
                WtcLog.info(TAG, "-" + signature);
            } else {
                WtcLog.warn(TAG, "-" + signature);
            }
        }
    }

    public Integer hangup(int callId) {
        WtcClientPhoneCall phoneCall = this.getPhoneCall(callId);
        return phoneCall == null ? null : this.hangup(phoneCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer hangup(WtcClientPhoneCall phoneCall) {
        Integer n;
        Integer transactionId = null;
        try {
            boolean handled;
            WtcLog.info(TAG, "+hangup(phoneCall=" + phoneCall + ")");
            int callId = phoneCall.getCallId();
            phoneCall.onCallHangup();
            transactionId = phoneCall.getStack().sendCallHangup(callId);
            if (transactionId == null) {
                transactionId = new Integer(-1);
            }
            this.onCallHangup(callId);
            if (this.mListener != null && !(handled = this.mListener.onCallHangup(this.mClient, 1, (int)transactionId, phoneCall))) {
                WtcpCallHangup callHangup = new WtcpCallHangup(callId, WtcpErrorCode.OK);
                this.mListener.onCallHangup(this.mClient, 1, (int)transactionId, callHangup);
            }
            n = transactionId;
        }
        catch (Throwable throwable) {
            WtcLog.info(TAG, "-hangup(phoneCall=" + phoneCall + "); return " + transactionId);
            throw throwable;
        }
        WtcLog.info(TAG, "-hangup(phoneCall=" + phoneCall + "); return " + transactionId);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WtcClientPhoneCall onCallHangup(int callId) {
        WtcClientPhoneCall phoneCall;
        Object object = this.mSyncLock;
        synchronized (object) {
            phoneCall = (WtcClientPhoneCall)this.mPhoneCalls.remove(callId);
            if (this.mPhoneCallConnected != null && this.mPhoneCallConnected.getCallId() == callId) {
                this.mPhoneCallConnected = null;
            }
        }
        return phoneCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCallHangup(WtcpControlHeader controlHeader, WtcpCallHangup callHangup) {
        String signature = "onCallHangup(..., callHangup=" + callHangup + ")";
        WtcpErrorCode errorCode = callHangup.errorCode;
        boolean isOK = errorCode.isOK();
        try {
            if (isOK) {
                WtcLog.info(TAG, "+" + signature);
            } else {
                WtcLog.warn(TAG, "+" + signature);
            }
            int callId = callHangup.callId;
            WtcClientPhoneCall phoneCall = this.onCallHangup(callId);
            if (controlHeader.isUnsolicited()) {
                boolean handled = false;
                if (phoneCall != null) {
                    phoneCall.onCallHangup();
                    if (this.mListener != null) {
                        handled = this.mListener.onCallHangup(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneCall);
                    }
                }
                if (!handled && this.mListener != null) {
                    this.mListener.onCallHangup(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, callHangup);
                }
            }
        }
        finally {
            if (isOK) {
                WtcLog.info(TAG, "-" + signature);
            } else {
                WtcLog.warn(TAG, "-" + signature);
            }
        }
    }

    public Integer dtmf(int callId, String digits) {
        WtcClientPhoneCall phoneCall = this.getPhoneCall(callId);
        return phoneCall == null ? null : this.dtmf(phoneCall, digits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer dtmf(WtcClientPhoneCall phoneCall, String digits) {
        Integer n;
        Integer transactionId = null;
        try {
            WtcLog.info(TAG, "+dtmf(phoneCall=" + phoneCall + ", digits=" + WtcString.quote(digits) + ")");
            transactionId = phoneCall.getStack().sendCallDtmf(phoneCall.getCallId(), digits);
            if (transactionId != null) {
                CallDtmfWrapper callDtmfWrapper = new CallDtmfWrapper(phoneCall, digits);
                Object object = this.mSyncLock;
                synchronized (object) {
                    this.mCallDtmfTransactionIdToCallDtmfWrapper.put((int)transactionId, (Object)callDtmfWrapper);
                }
            }
            n = transactionId;
        }
        catch (Throwable throwable) {
            WtcLog.info(TAG, "-dtmf(phoneCall=" + phoneCall + ", digits=" + WtcString.quote(digits) + "); return " + transactionId);
            throw throwable;
        }
        WtcLog.info(TAG, "-dtmf(phoneCall=" + phoneCall + ", digits=" + WtcString.quote(digits) + "); return " + transactionId);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCallDtmf(WtcpControlHeader controlHeader, WtcpErrorCode errorCode) {
        String signature = "onCallDtmf(..., errorCode=" + errorCode + ")";
        boolean isOK = errorCode.isOK();
        try {
            CallDtmfWrapper callDtmfWrapper;
            if (isOK) {
                WtcLog.info(TAG, "+" + signature);
            } else {
                WtcLog.warn(TAG, "+" + signature);
            }
            int transactionId = controlHeader.transactionId;
            Object object = this.mSyncLock;
            synchronized (object) {
                callDtmfWrapper = (CallDtmfWrapper)this.mCallDtmfTransactionIdToCallDtmfWrapper.remove(transactionId);
            }
            boolean handled = false;
            if (callDtmfWrapper != null) {
                if (this.mListener != null) {
                    handled = this.mListener.onCallDtmf(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, callDtmfWrapper.mPhoneCall, callDtmfWrapper.mDigits, errorCode);
                }
            } else {
                WtcLog.error(TAG, "mCallDtmfTransactionIdToCallDtmfInfo.remove(" + transactionId + ") returned null!");
            }
            if (!handled && this.mListener != null) {
                this.mListener.onCallDtmf(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, errorCode);
            }
        }
        finally {
            if (isOK) {
                WtcLog.info(TAG, "-" + signature);
            } else {
                WtcLog.warn(TAG, "-" + signature);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCallDtmf(WtcpControlHeader controlHeader, WtcpCallDtmf callDtmf) {
        try {
            WtcLog.info(TAG, "+onCallDtmf(..., callDtmf=" + callDtmf + ")");
            int callId = callDtmf.callId;
            boolean handled = false;
            WtcClientPhoneCall phoneCall = this.getPhoneCall(callId);
            if (phoneCall != null) {
                phoneCall.onCallDtmf(controlHeader, callDtmf);
                if (this.mListener != null) {
                    handled = this.mListener.onCallDtmf(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneCall, callDtmf.digits);
                }
            }
            if (!handled && this.mListener != null) {
                this.mListener.onCallDtmf(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, callDtmf);
            }
        }
        finally {
            WtcLog.info(TAG, "-onCallDtmf(..., callDtmf=" + callDtmf + ")");
        }
    }

    public Integer pushToTalk(int callId, boolean on) {
        WtcClientPhoneCall phoneCall = this.getPhoneCall(callId);
        return phoneCall == null ? null : this.pushToTalk(phoneCall, on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer pushToTalk(WtcClientPhoneCall phoneCall, boolean on) {
        Integer n;
        Integer transactionId = null;
        try {
            WtcLog.info(TAG, "+pushToTalk(phoneCall=" + phoneCall + ", on=" + on + ")");
            transactionId = phoneCall.getStack().sendCallPushToTalk(phoneCall.getCallId(), on);
            if (transactionId != null && on) {
                phoneCall.setCallTalkState(1);
            } else {
                phoneCall.setCallTalkState(0);
            }
            n = transactionId;
        }
        catch (Throwable throwable) {
            WtcLog.info(TAG, "-pushToTalk(phoneCall=" + phoneCall + ", on=" + on + "); return " + transactionId);
            throw throwable;
        }
        WtcLog.info(TAG, "-pushToTalk(phoneCall=" + phoneCall + ", on=" + on + "); return " + transactionId);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onCallPushToTalkOn(WtcpControlHeader controlHeader, WtcInt32 callId, WtcpErrorCode errorCode) {
        boolean handled = false;
        String signature = "onCallPushToTalkOn(..., callId=" + callId + ", errorCode=" + errorCode + ")";
        boolean isOK = errorCode.isOK();
        try {
            if (isOK) {
                WtcLog.info(TAG, "+" + signature);
            } else {
                WtcLog.warn(TAG, "+" + signature);
            }
            WtcClientPhoneCall phoneCall = this.getPhoneCall(callId.value);
            if (phoneCall != null) {
                phoneCall.setCallTalkState(errorCode.isOK() ? 2 : 0);
                if (this.mListener != null) {
                    handled = this.mListener.onCallPushToTalkOn(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneCall, errorCode);
                }
            } else {
                WtcLog.warn(TAG, "onCallPushToTalkOn: getPhoneCall(" + callId.value + ") returned null!");
                if (this.mListener != null) {
                    handled = this.mListener.onCallPushToTalkOn(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, callId, errorCode);
                }
            }
            boolean bl = handled;
            return bl;
        }
        finally {
            if (isOK) {
                WtcLog.info(TAG, "-" + signature);
            } else {
                WtcLog.warn(TAG, "-" + signature);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onCallPushToTalkOff(WtcpControlHeader controlHeader, WtcInt32 callId, WtcpErrorCode errorCode) {
        boolean handled = false;
        String signature = "onCallPushToTalkOff(..., callId=" + callId + ", errorCode=" + errorCode + ")";
        boolean isOK = errorCode.isOK();
        try {
            if (isOK) {
                WtcLog.info(TAG, "+" + signature);
            } else {
                WtcLog.warn(TAG, "+" + signature);
            }
            WtcClientPhoneCall phoneCall = this.getPhoneCall(callId.value);
            if (phoneCall != null) {
                phoneCall.setCallTalkState(0);
                if (this.mListener != null) {
                    handled = this.mListener.onCallPushToTalkOff(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, phoneCall, errorCode);
                }
            } else {
                WtcLog.warn(TAG, "onCallPushToTalkOff: getPhoneCall(" + callId.value + ") returned null!");
                if (this.mListener != null) {
                    handled = this.mListener.onCallPushToTalkOff(this.mClient, controlHeader.getOpType(), controlHeader.transactionId, callId, errorCode);
                }
            }
            boolean bl = handled;
            return bl;
        }
        finally {
            if (isOK) {
                WtcLog.info(TAG, "-" + signature);
            } else {
                WtcLog.warn(TAG, "-" + signature);
            }
        }
    }

    protected static class CallDtmfWrapper {
        public final WtcClientPhoneCall mPhoneCall;
        public final String mDigits;

        public CallDtmfWrapper(WtcClientPhoneCall phoneCall, String digits) {
            this.mPhoneCall = phoneCall;
            this.mDigits = digits;
        }
    }

    protected static class CallMakeWrapper {
        public final WtcClientPhoneLine mPhoneLine;
        public final byte mCallType;
        public final String mRemoteName;

        public CallMakeWrapper(WtcClientPhoneLine phoneLine, byte callType, String remoteName) {
            this.mPhoneLine = phoneLine;
            this.mCallType = callType;
            this.mRemoteName = remoteName;
        }
    }
}

