/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcClientChannelAction;
import com.twistpair.wave.thinclient.WtcClientChannelManager;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelInfo;
import com.twistpair.wave.thinclient.protocol.types.WtcpEndpointInfo;
import com.twistpair.wave.thinclient.protocol.types.WtcpEndpointInfoList;
import com.twistpair.wave.thinclient.protocol.types.WtcpKeyValueList;
import com.twistpair.wave.thinclient.util.StereoVolume;
import com.twistpair.wave.thinclient.util.WtcInt16;
import com.twistpair.wave.thinclient.util.WtcInt32;
import com.twistpair.wave.thinclient.util.WtcString;
import java.util.Enumeration;
import java.util.Hashtable;

public class WtcClientChannel {
    private static final String TAG = WtcLog.TAG(WtcClientChannel.class);
    private static final boolean VERBOSE_LOG_CHANNEL_ACTIVITY = false;
    private static final char PROPERTY_KEY_PREFIX_SYSTEM = '%';
    private static final char PROPERTY_KEY_PREFIX_PRIVATE = '@';
    private static final char PROPERTY_KEY_SUFFIX_NAME = 'N';
    private static final char PROPERTY_KEY_SUFFIX_UNIQUE = 'U';
    private static final char PROPERTY_KEY_SUFFIX_SIMPLEX = 'S';
    private static final char PROPERTY_KEY_SUFFIX_RXABLE = 'R';
    private static final char PROPERTY_KEY_SUFFIX_TXABLE = 'T';
    private static final char PROPERTY_KEY_SUFFIX_VOLUME = 'V';
    public static final String PROPERTY_KEY_SYSTEM_UNIQUE = "%U";
    public static final String PROPERTY_KEY_PRIVATE_VOLUME = "@V";
    private final WtcClientChannelManager mManager;
    private final WtcInt32 mIdSession;
    private WtcInt16 mFlags;
    private String mName;
    protected final WtcClientChannelAction mActive = new WtcClientChannelAction();
    protected final WtcClientChannelAction mPtt = new WtcClientChannelAction();
    protected final WtcClientChannelAction mMute = new WtcClientChannelAction();
    private final WtcpKeyValueList mProperties = new WtcpKeyValueList();
    private String mIdUnique;
    private boolean mGotUnique = false;
    private boolean mSimplex = false;
    private boolean mRXable = true;
    private boolean mTXable = true;
    private final StereoVolume mVolume = new StereoVolume();
    private int mEndpointCount;
    private final Object mActivitySync = new Object();
    private final Hashtable mEndpointsVisible = new Hashtable();
    private final Hashtable mEndpointsTalking = new Hashtable();

    public WtcClientChannel(WtcClientChannelManager manager, WtcpChannelInfo channelInfo) {
        this.mManager = manager;
        this.mIdSession = WtcInt32.valueOf(channelInfo.id, true);
        this.setFlags(channelInfo.flags);
        this.mIdUnique = this.mName = channelInfo.name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append("{idSession=").append(this.mIdSession).append(",flags=").append(this.mFlags).append(",name=").append('\"').append(this.mName).append('\"');
        if (this.mActive.isAnyTrue()) {
            sb.append(",active=").append(this.mActive);
        }
        if (this.mPtt.isAnyTrue()) {
            sb.append(",ptt=").append(this.mPtt);
        }
        if (this.mMute.isAnyTrue()) {
            sb.append(",mute=").append(this.mMute);
        }
        sb.append(",unique=").append(this.mGotUnique).append(",idUnique=").append('\"').append(this.mIdUnique).append('\"').append(",simplex=").append(this.mSimplex).append(",RXable=").append(this.mRXable).append(",TXable=").append(this.mTXable).append(",volume=").append(this.mVolume).append(",properties=").append(this.mProperties).append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof WtcClientChannel) {
            return this.getIdSession().value == ((WtcClientChannel)o).getIdSession().value;
        }
        return false;
    }

    public WtcInt32 getIdSession() {
        return this.mIdSession;
    }

    public boolean isUnique() {
        return this.mGotUnique;
    }

    public String getIdUnique() {
        return this.mIdUnique;
    }

    public int getFlags() {
        return this.mFlags.value;
    }

    private void setFlags(int flags) {
        this.mFlags = new WtcInt16(flags);
    }

    public String getName() {
        return this.mName;
    }

    public boolean isActivated() {
        return this.mActive.isOn();
    }

    public boolean isSimplex() {
        return this.mSimplex;
    }

    public boolean getRXable() {
        return this.mRXable;
    }

    public boolean getTXable() {
        return this.mTXable;
    }

    public StereoVolume getVolume() {
        return this.mVolume;
    }

    public Integer setVolume(int left, int right) {
        return this.setVolume(new StereoVolume(left, right));
    }

    public Integer setVolume(StereoVolume volume) {
        if (volume == null) {
            volume = new StereoVolume(0, 0);
        }
        String value = volume.getLeft() + "," + volume.getRight();
        return this.mManager.setChannelProperty(this.mIdSession, PROPERTY_KEY_PRIVATE_VOLUME, value);
    }

    public Integer activate(boolean on) {
        return this.mManager.activate(this.mIdSession, on);
    }

    public boolean isTalking() {
        return this.mPtt.isOn();
    }

    public Integer talk(boolean on) {
        return this.mManager.talk(this.mIdSession, on);
    }

    public boolean isMuted() {
        return this.mMute.isOn();
    }

    public Integer mute(boolean on) {
        return this.mManager.mute(this.mIdSession, on);
    }

    protected void updateProperties(WtcpKeyValueList keyValues) {
        Enumeration keys = keyValues.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)keyValues.get(key);
            this.mProperties.put(key, value);
            int offset = 0;
            block0 : switch (key.charAt(offset++)) {
                case '%': {
                    switch (key.charAt(offset++)) {
                        case 'N': {
                            this.mName = value;
                            break block0;
                        }
                        case 'U': {
                            this.mIdUnique = value;
                            this.mGotUnique = true;
                            break block0;
                        }
                        case 'S': {
                            this.mSimplex = !"0".equals(value);
                            break block0;
                        }
                        case 'R': {
                            this.mRXable = !"0".equals(value);
                            break block0;
                        }
                        case 'T': {
                            this.mTXable = !"0".equals(value);
                        }
                    }
                    break;
                }
                case '@': {
                    switch (key.charAt(offset++)) {
                        case 'V': {
                            String[] volumeLeftRight = WtcString.split(value, ",", 2);
                            int left = Integer.parseInt(volumeLeftRight[0]);
                            int right = Integer.parseInt(volumeLeftRight[1]);
                            this.mVolume.set(left, right);
                        }
                    }
                }
            }
        }
    }

    protected void updateActivity(int channelFlags, short endpointCount, WtcpEndpointInfoList activityEndpoints) {
        this.setEndpointCount(endpointCount);
        this.setActivityEndpoints(activityEndpoints);
    }

    public int getEndpointCount() {
        return this.mEndpointCount;
    }

    private void setEndpointCount(int endpointCount) {
        this.mEndpointCount = endpointCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WtcpEndpointInfoList getEndpointsVisible() {
        Object object = this.mActivitySync;
        synchronized (object) {
            return new WtcpEndpointInfoList(this.mEndpointsVisible.elements());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WtcpEndpointInfoList getEndpointsTalking() {
        Object object = this.mActivitySync;
        synchronized (object) {
            return new WtcpEndpointInfoList(this.mEndpointsTalking.elements());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getHasTalkers() {
        Object object = this.mActivitySync;
        synchronized (object) {
            return this.mEndpointsTalking.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActivityEndpoints(WtcpEndpointInfoList activityEndpoints) {
        for (int i = 0; i < activityEndpoints.size(); ++i) {
            WtcpEndpointInfo endpointInfo = (WtcpEndpointInfo)activityEndpoints.elementAt(i);
            String endpointId = endpointInfo.getId();
            Object object = this.mActivitySync;
            synchronized (object) {
                if (endpointInfo.isVisible()) {
                    this.mEndpointsVisible.put(endpointId, endpointInfo);
                    if (endpointInfo.isSpeaking()) {
                        this.mEndpointsTalking.put(endpointId, endpointInfo);
                    } else {
                        this.mEndpointsTalking.remove(endpointId);
                    }
                } else {
                    this.mEndpointsVisible.remove(endpointId);
                    this.mEndpointsTalking.remove(endpointId);
                }
                continue;
            }
        }
    }
}

