/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcClientChannelManager;
import com.twistpair.wave.thinclient.WtcClientException;
import com.twistpair.wave.thinclient.WtcClientListener;
import com.twistpair.wave.thinclient.WtcClientPhoneCallManager;
import com.twistpair.wave.thinclient.WtcClientPhoneLineManager;
import com.twistpair.wave.thinclient.WtcConnectionStatistics;
import com.twistpair.wave.thinclient.WtcProxyInfo;
import com.twistpair.wave.thinclient.WtcStack;
import com.twistpair.wave.thinclient.WtcStackException;
import com.twistpair.wave.thinclient.WtcStackListener;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.media.WtcMediaCodecGSMPlatform;
import com.twistpair.wave.thinclient.media.WtcMediaDeviceMicrophone;
import com.twistpair.wave.thinclient.media.WtcMediaDeviceSpeaker;
import com.twistpair.wave.thinclient.net.WtcInetSocketAddressPlatform;
import com.twistpair.wave.thinclient.net.WtcUri;
import com.twistpair.wave.thinclient.net.WtcUriPlatform;
import com.twistpair.wave.thinclient.protocol.WtcpConstants;
import com.twistpair.wave.thinclient.protocol.headers.WtcpControlHeader;
import com.twistpair.wave.thinclient.protocol.headers.WtcpMediaHeader;
import com.twistpair.wave.thinclient.protocol.types.WtcpAddressBookInfoList;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallAnswer;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallDtmf;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallHangup;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallInfo;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallOffer;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallProgress;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelActivity;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelIdErrorDictionary;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelIdList;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelInfoList;
import com.twistpair.wave.thinclient.protocol.types.WtcpEndpointInfoList;
import com.twistpair.wave.thinclient.protocol.types.WtcpEndpointProperties;
import com.twistpair.wave.thinclient.protocol.types.WtcpErrorCode;
import com.twistpair.wave.thinclient.protocol.types.WtcpKeyValueList;
import com.twistpair.wave.thinclient.protocol.types.WtcpProfileInfoList;
import com.twistpair.wave.thinclient.protocol.types.WtcpStringList;
import com.twistpair.wave.thinclient.util.WtcInt16;
import com.twistpair.wave.thinclient.util.WtcInt32;
import com.twistpair.wave.thinclient.util.WtcInt8;
import com.twistpair.wave.thinclient.util.WtcString;
import com.twistpair.wave.thinclient.util.WtcVersionString;

public class WtcClient
extends WtcStackListener {
    private static final String TAG;
    public static final String WAVE_LICENSE_WTC_ANDROID = "{E030C868-E1FC-43E2-8CF1-85B977BD590C}";
    public static final String WAVE_LICENSE_WTC_ANDROID_IPTEL = "{E420E0EA-BD45-49fa-8EBD-832E33149880}";
    public static final String LICENSE_DEFAULT = "{E030C868-E1FC-43E2-8CF1-85B977BD590C}";
    public static final int KEX_DEFAULT = 1024;
    public static final byte AUDIO_CODEC_DEFAULT = 1;
    public static final byte AUDIO_SCALE_DEFAULT = 2;
    public static final byte SESSION_TIMEOUT_DEFAULT = 120;
    public static final int CONNECT_TIMEOUT_DEFAULT = 0;
    public static final String PLATFORM_DESCRIPTION_DEFAULT;
    private final WtcMediaDeviceMicrophone microphone;
    private final WtcMediaDeviceSpeaker speaker;
    private final WtcClientChannelManager channelManager;
    private final Object syncConnection = new Object();
    private final WtcVersionString version;
    private WtcStack stack;
    private String platformDescription;
    private String username;
    private String password;
    private WtcInt8 sessionTimeoutSeconds;
    private String license;
    private String profileId;
    private WtcInt8 audioCodec;
    private WtcInt8 audioScale;
    private String sessionId;
    private WtcClientListener listener;
    private WtcClientPhoneLineManager phoneLineManager;
    private WtcClientPhoneCallManager phoneCallManager;

    public WtcMediaDeviceMicrophone getMicrophone() {
        return this.microphone;
    }

    public WtcMediaDeviceSpeaker getSpeaker() {
        return this.speaker;
    }

    public WtcClientChannelManager getChannelManager() {
        return this.channelManager;
    }

    public WtcClientPhoneLineManager getPhoneLineManager() {
        return this.phoneLineManager;
    }

    public WtcClientPhoneCallManager getPhoneCallManager() {
        return this.phoneCallManager;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WtcClient(WtcMediaDeviceMicrophone microphone, WtcMediaDeviceSpeaker speaker, WtcVersionString version) {
        try {
            WtcLog.debug(TAG, "+WtcClient");
            if (microphone == null) {
                throw new IllegalArgumentException("microphone cannot be null");
            }
            if (speaker == null) {
                throw new IllegalArgumentException("speaker cannot be null");
            }
            this.microphone = microphone;
            this.speaker = speaker;
            this.channelManager = new WtcClientChannelManager(this);
            this.version = version;
            this.clear();
        }
        finally {
            WtcLog.debug(TAG, "-WtcClient");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Object object = this.syncConnection;
        synchronized (object) {
            this.stack = null;
            this.channelManager.clear();
            if (this.phoneLineManager != null) {
                this.phoneLineManager.clear();
                this.phoneLineManager = null;
            }
            if (this.phoneCallManager != null) {
                this.phoneCallManager.clear();
                this.phoneCallManager = null;
            }
            this.platformDescription = null;
            this.username = null;
            this.password = null;
            this.sessionTimeoutSeconds = null;
            this.license = null;
            this.profileId = null;
            this.audioCodec = null;
            this.audioScale = null;
            this.sessionId = null;
        }
    }

    public void connect(WtcClientListener listener, WtcConnectionStatistics connectionStatistics, String platformDescription, WtcUri[] uriServers, String username, String password) {
        this.connect(listener, connectionStatistics, platformDescription, 1024, uriServers, username, password);
    }

    public void connect(WtcClientListener listener, WtcConnectionStatistics connectionStatistics, String platformDescription, int kexSize, WtcUri[] uriServers, String username, String password) {
        this.connect(listener, connectionStatistics, platformDescription, kexSize, uriServers, username, password, (byte)120);
    }

    public void connect(WtcClientListener listener, WtcConnectionStatistics connectionStatistics, String platformDescription, int kexSize, WtcUri[] uriServers, String username, String password, byte sessionTimeoutSeconds) {
        try {
            this.connect(listener, connectionStatistics, platformDescription, kexSize, uriServers, username, password, sessionTimeoutSeconds, (byte)1, (byte)2);
        }
        catch (WtcClientException.WtcClientUnsupportedCodecException e) {
            WtcLog.error(TAG, "Should never happen, as long as AUDIO_CODEC_DEFAULT is valid", e);
        }
    }

    public void connect(WtcClientListener listener, WtcConnectionStatistics connectionStatistics, String platformDescription, int kexSize, WtcUri[] uriServers, String username, String password, byte sessionTimeoutSeconds, byte audioCodec, byte audioScale) throws WtcClientException.WtcClientUnsupportedCodecException {
        try {
            this.connect(listener, connectionStatistics, platformDescription, kexSize, uriServers, username, password, sessionTimeoutSeconds, audioCodec, audioScale, "{E030C868-E1FC-43E2-8CF1-85B977BD590C}", null);
        }
        catch (WtcClientException.WtcClientUnsupportedCodecException e) {
            WtcLog.error(TAG, "Should never happen, as long as AUDIO_CODEC_DEFAULT is valid", e);
        }
    }

    public void connect(WtcClientListener listener, WtcConnectionStatistics connectionStatistics, String platformDescription, int kexSize, WtcUri[] uriServers, String username, String password, byte sessionTimeoutSeconds, byte audioCodec, byte audioScale, String license, String profileId) throws WtcClientException.WtcClientUnsupportedCodecException {
        try {
            this.connect(listener, connectionStatistics, platformDescription, kexSize, uriServers, username, password, sessionTimeoutSeconds, audioCodec, audioScale, license, profileId, 0, null);
        }
        catch (WtcClientException.WtcClientUnsupportedCodecException e) {
            WtcLog.error(TAG, "Should never happen, as long as AUDIO_CODEC_DEFAULT is valid", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(WtcClientListener listener, WtcConnectionStatistics connectionStatistics, String platformDescription, int kexSize, WtcUri[] uriServers, String username, String password, byte sessionTimeoutSeconds, byte audioCodec, byte audioScale, String license, String profileId, int timeoutConnect, WtcInetSocketAddressPlatform localAddress) throws WtcClientException.WtcClientUnsupportedCodecException {
        String sig = "connect(" + WtcString.quote(platformDescription) + ", " + kexSize + ", " + WtcUri.toString(uriServers) + ", " + WtcString.quote(username) + ", " + WtcStack.censor(password) + ", " + sessionTimeoutSeconds + ", " + audioCodec + ", " + audioScale + ", " + WtcString.quote(license) + ", " + WtcString.quote(profileId) + ", " + timeoutConnect + ", " + localAddress + ")";
        try {
            WtcLog.debug(TAG, "+" + sig);
            if (listener == null) {
                throw new IllegalArgumentException("listener cannot be null");
            }
            if (WtcUriPlatform.isNullOrEmpty(uriServers)) {
                throw new IllegalArgumentException("uriServer cannot be null, empty, or contain null/EMPTY values");
            }
            if (WtcString.isNullOrEmpty(username)) {
                throw new IllegalArgumentException("username cannot be null or \"\"");
            }
            if (WtcString.isNullOrEmpty(license)) {
                throw new IllegalArgumentException("license cannot be null or \"\"");
            }
            if (sessionTimeoutSeconds < 5 || sessionTimeoutSeconds > 120) {
                throw new IllegalArgumentException("sessionTimeoutSeconds must be >= 5 and <= 120");
            }
            if (password == null) {
                password = "";
            }
            if (profileId == null) {
                profileId = "";
            }
            if (platformDescription == null) {
                platformDescription = PLATFORM_DESCRIPTION_DEFAULT;
            }
            Object object = this.syncConnection;
            synchronized (object) {
                this.disconnect();
                this.listener = listener;
                this.username = username;
                this.password = password;
                this.license = license;
                this.profileId = profileId;
                this.audioCodec = new WtcInt8(audioCodec);
                this.audioScale = new WtcInt8(audioScale);
                this.sessionTimeoutSeconds = new WtcInt8(sessionTimeoutSeconds);
                this.platformDescription = platformDescription;
                WtcMediaCodecGSMPlatform codec = null;
                switch (audioCodec) {
                    case 1: {
                        break;
                    }
                    case 10: {
                        codec = new WtcMediaCodecGSMPlatform();
                        break;
                    }
                    default: {
                        throw new WtcClientException.WtcClientUnsupportedCodecException(audioCodec);
                    }
                }
                this.microphone.setMediaEncoder(codec);
                this.speaker.setMediaDecoder(codec);
                this.stack = new WtcStack(this.microphone, this.speaker, connectionStatistics, this.version, uriServers, kexSize, timeoutConnect, localAddress);
                this.stack.setListener(this);
                this.stack.connect();
            }
        }
        finally {
            WtcLog.debug(TAG, "-" + sig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.syncConnection;
        synchronized (object) {
            boolean isSessionOpen = !WtcString.isNullOrEmpty(this.sessionId);
            this.disconnect(isSessionOpen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean sendSessionClose) {
        try {
            WtcLog.debug(TAG, "+disconnect(sendSessionClose=" + sendSessionClose + ")");
            Object object = this.syncConnection;
            synchronized (object) {
                Integer transactionId = null;
                try {
                    if (sendSessionClose && this.stack != null) {
                        transactionId = this.stack.sendSessionClose();
                    }
                }
                catch (Exception e) {
                    WtcLog.error(TAG, "disconnect(sendSessionClose=" + sendSessionClose + ')', e);
                    transactionId = null;
                }
                if (transactionId == null) {
                    this.listener = null;
                    if (this.stack != null) {
                        this.stack.disconnect();
                        this.stack.setListener(null);
                        this.stack = null;
                    }
                    this.clear();
                }
            }
        }
        finally {
            WtcLog.debug(TAG, "-disconnect(sendSessionClose=" + sendSessionClose + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onDisconnected(WtcStack stack, WtcInetSocketAddressPlatform proxyAddress, Exception exception, WtcConnectionStatistics statistics) {
        String sig = "onDisconnected(stack, " + WtcString.quote(proxyAddress) + ", " + exception + ", " + statistics + ")";
        boolean error = false;
        try {
            if (exception != null) {
                if (exception instanceof WtcStackException.WtcStackSessionCloseException) {
                    WtcStackException.WtcStackSessionCloseException sessionCloseException = (WtcStackException.WtcStackSessionCloseException)exception;
                    WtcpErrorCode errorCode = sessionCloseException.errorCode;
                    error = errorCode != null && errorCode.isError();
                } else {
                    error = true;
                }
            }
            if (error) {
                WtcLog.warn(TAG, "+" + sig, exception);
            } else {
                WtcLog.info(TAG, "+" + sig);
            }
            if (stack != this.stack) {
                WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
                return;
            }
            WtcClientListener listener = this.listener;
            if (listener != null) {
                listener.onDisconnected(this, proxyAddress, exception, statistics);
            }
        }
        catch (Exception e) {
            WtcLog.warn(TAG, "onDisconnected EXCEPTION", e);
        }
        finally {
            try {
                stack.setListener(null);
                this.disconnect(false);
            }
            catch (Exception e) {
                WtcLog.warn(TAG, "onDisconnected EXCEPTION", e);
            }
            if (error) {
                WtcLog.warn(TAG, "-onDisconnected(...)");
            } else {
                WtcLog.info(TAG, "-onDisconnected(...)");
            }
        }
    }

    @Override
    protected void onProxyLocating(WtcStack stack, WtcUri remoteAddress) {
        WtcLog.debug(TAG, "onProxyLocating(stack, " + remoteAddress + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onProxyLocating(this, remoteAddress);
        }
    }

    @Override
    protected void onProxyLocated(WtcStack stack, WtcProxyInfo[] proxyInfos) {
        WtcLog.debug(TAG, "onProxyLocated(stack, " + WtcProxyInfo.toString(proxyInfos) + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onProxyLocated(this, proxyInfos);
        }
    }

    @Override
    protected void onProxyConnecting(WtcStack stack, WtcInetSocketAddressPlatform addressProxy) {
        WtcLog.debug(TAG, "onProxyConnecting(stack, " + WtcString.quote(addressProxy) + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onProxyConnecting(this, addressProxy);
        }
    }

    @Override
    protected void onProxyConnected(WtcStack stack, WtcProxyInfo proxyInfo, WtcInetSocketAddressPlatform proxyAddress) {
        WtcLog.debug(TAG, "onProxyConnected(stack, " + proxyInfo + ", " + WtcString.quote(proxyAddress) + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onProxyConnected(this, proxyInfo, proxyAddress);
        }
    }

    @Override
    protected void onMessageReceivedMedia(WtcStack stack, WtcpMediaHeader mediaHeader, int payloadLength) {
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onMessageReceivedMedia(this, mediaHeader, payloadLength);
        }
    }

    @Override
    protected void onProxySecuring(WtcStack stack, int kexSize) {
        WtcLog.debug(TAG, "onProxySecuring(stack, " + kexSize + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onProxySecuring(this, kexSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void onProxySecured(WtcStack stack, int kexSize) {
        WtcLog.debug(TAG, "onProxySecured(stack, " + kexSize + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onProxySecured(this, kexSize);
        }
        Object object = this.syncConnection;
        synchronized (object) {
            stack.sendSessionOpen(this.audioCodec, this.audioScale, this.sessionTimeoutSeconds, this.platformDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onSessionOpen(WtcStack stack, WtcpControlHeader controlHeader, String sessionId, WtcInt32 serverTime, WtcVersionString serverVersion) {
        String sig = "onSessionOpen(stack, " + controlHeader + ", " + WtcString.quote(sessionId) + ", " + serverTime + ", " + serverVersion + ")";
        try {
            WtcLog.debug(TAG, "+" + sig);
            if (stack != this.stack) {
                WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
                return;
            }
            Object object = this.syncConnection;
            synchronized (object) {
                this.sessionId = sessionId;
            }
            WtcClientListener listener = this.listener;
            if (listener != null) {
                listener.onSessionOpen(this, controlHeader.getOpType(), controlHeader.transactionId, sessionId, serverTime, serverVersion);
            }
            this.setProfile(stack, this.profileId);
        }
        finally {
            WtcLog.debug(TAG, "-" + sig);
        }
    }

    @Override
    protected void onSessionOpen(WtcStack stack, WtcpControlHeader controlHeader, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onSessionOpen(stack, " + controlHeader + ", " + errorCode + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onSessionOpenError(this, controlHeader.getOpType(), controlHeader.transactionId, errorCode);
        }
    }

    public Integer setProfile(String profileId) {
        return this.setProfile(this.stack, profileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer setProfile(WtcStack stack, String profileId) {
        Object object = this.syncConnection;
        synchronized (object) {
            if (stack != null) {
                this.profileId = profileId;
                return stack.sendSetCredentials(this.username, this.password, this.license, profileId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onSetCredentials(WtcStack stack, WtcpControlHeader controlHeader, String localEndpointId, byte profileIndex, WtcpProfileInfoList profiles, WtcpChannelInfoList channels, WtcpStringList phoneLines) {
        String sig = "onSetCredentials(stack, " + controlHeader + ", " + WtcString.quote(localEndpointId) + ", " + profileIndex + ", " + profiles + ", " + channels + ", " + phoneLines + ")";
        try {
            WtcClientListener listener;
            WtcLog.debug(TAG, "+" + sig);
            if (stack != this.stack) {
                WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
                return;
            }
            if (profileIndex != -1) {
                Object object = this.syncConnection;
                synchronized (object) {
                    this.channelManager.setChannels(channels);
                    this.phoneLineManager = new WtcClientPhoneLineManager(this, this.listener, stack, phoneLines);
                    this.phoneCallManager = new WtcClientPhoneCallManager(this, this.listener);
                }
            }
            if ((listener = this.listener) != null) {
                WtcLog.info(TAG, "onSetCredentials(...): Sending channels to client listener: " + channels);
                listener.onSetCredentials(this, controlHeader.getOpType(), controlHeader.transactionId, localEndpointId, profileIndex, profiles, channels, phoneLines);
            }
        }
        finally {
            WtcLog.debug(TAG, "-" + sig);
        }
    }

    @Override
    protected void onSetCredentials(WtcStack stack, WtcpControlHeader controlHeader, WtcpErrorCode errorCode, WtcpProfileInfoList profiles) {
        WtcLog.debug(TAG, "onSetCredentials(stack, " + controlHeader + ", " + errorCode + ", " + profiles + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onSetCredentialsError(this, controlHeader.getOpType(), controlHeader.transactionId, errorCode, profiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onSessionResume(WtcStack stack, WtcpControlHeader controlHeader, WtcpErrorCode errorCode, String sessionId) {
        WtcLog.debug(TAG, "onSessionResume(stack, " + controlHeader + ", " + errorCode + ", " + WtcString.quote(sessionId) + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        Object object = this.syncConnection;
        synchronized (object) {
            this.sessionId = sessionId;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onSessionResume(this, controlHeader.getOpType(), controlHeader.transactionId, errorCode, sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onSessionClose(WtcStack stack, WtcpControlHeader controlHeader, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onSessionClose(stack, " + controlHeader + ", " + errorCode + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        Object object = this.syncConnection;
        synchronized (object) {
            this.sessionId = null;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onSessionClose(this, controlHeader.getOpType(), controlHeader.transactionId, errorCode);
        }
    }

    @Override
    protected void OnChannelChange(WtcStack stack, WtcpControlHeader controlHeader, boolean reconnect, int change, int channelId) {
        WtcLog.debug(TAG, "+onChannelSetActive(stack, " + controlHeader + ", reconnect=" + reconnect + ", change=" + WtcpConstants.WtcpChannelChange.toString(change) + ", channelId=" + channelId + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        this.channelManager.onChannelChange(this, this.listener, controlHeader, reconnect, change, channelId);
    }

    protected Integer channelsSetActive(WtcpChannelIdList channels) {
        WtcStack stack = this.stack;
        return stack == null ? null : stack.sendChannelSetActive(channels);
    }

    @Override
    protected void onChannelSetActive(WtcStack stack, WtcpControlHeader controlHeader, WtcpChannelIdErrorDictionary channelIdErrors) {
        WtcLog.debug(TAG, "+onChannelSetActive(stack, " + controlHeader + ", " + channelIdErrors + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        this.channelManager.onChannelOperation(this, this.listener, controlHeader, channelIdErrors);
    }

    protected Integer channelGetActivity(int channelId) {
        WtcStack stack = this.stack;
        return stack == null ? null : stack.sendChannelActivityRequest(WtcInt32.valueOf(channelId, true));
    }

    @Override
    protected void onChannelActivity(WtcStack stack, WtcpControlHeader controlHeader, WtcpChannelActivity channelActivity) {
        WtcLog.debug(TAG, "onChannelActivity(stack, " + controlHeader + ", " + channelActivity + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        this.channelManager.onChannelActivity(this, this.listener, controlHeader, channelActivity);
    }

    @Override
    protected void onChannelActivity(WtcStack stack, WtcpControlHeader controlHeader, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onChannelActivity(stack, " + controlHeader + ", " + errorCode + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        this.channelManager.onChannelActivity(this, this.listener, controlHeader, errorCode);
    }

    protected Integer channelsPushToTalk(WtcpChannelIdList channels) {
        WtcStack stack = this.stack;
        return stack == null ? null : stack.sendChannelPushToTalk(channels);
    }

    @Override
    protected void onChannelPushToTalk(WtcStack stack, WtcpControlHeader controlHeader, WtcpChannelIdErrorDictionary channelIdErrors) {
        WtcLog.debug(TAG, "onChannelPushToTalk(stack, " + controlHeader + ", " + channelIdErrors + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        this.channelManager.onChannelOperation(this, this.listener, controlHeader, channelIdErrors);
    }

    protected Integer channelsMute(WtcpChannelIdList channels) {
        WtcStack stack = this.stack;
        return stack == null ? null : stack.sendChannelMute(channels);
    }

    @Override
    protected void onChannelMute(WtcStack stack, WtcpControlHeader controlHeader, WtcpChannelIdErrorDictionary channelIdErrors) {
        WtcLog.debug(TAG, "onChannelMute(stack, " + controlHeader + ", " + channelIdErrors + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        this.channelManager.onChannelOperation(this, this.listener, controlHeader, channelIdErrors);
    }

    protected Integer channelPropertiesGet(WtcInt32 channelId, WtcpStringList keys) {
        WtcStack stack = this.stack;
        return stack == null ? null : stack.sendChannelPropertiesGet(channelId, keys);
    }

    @Override
    protected void onChannelPropertiesGet(WtcStack stack, WtcpControlHeader controlHeader, int channelId, WtcpKeyValueList keyValues) {
        WtcLog.debug(TAG, "onChannelPropertiesGet(stack, " + controlHeader + ", " + channelId + ", " + keyValues + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        this.channelManager.onChannelPropertiesGet(this, this.listener, controlHeader, channelId, keyValues);
    }

    @Override
    protected void onChannelPropertiesGet(WtcStack stack, WtcpControlHeader controlHeader, int channelId, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onChannelPropertiesGet(stack, " + controlHeader + ", " + channelId + ", " + errorCode + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        this.channelManager.onChannelPropertiesGet(this, this.listener, controlHeader, channelId, errorCode);
    }

    public Integer channelPropertiesSet(WtcInt32 channelId, WtcpKeyValueList keyValues) {
        WtcStack stack = this.stack;
        return stack == null ? null : stack.sendChannelPropertiesSet(channelId, keyValues);
    }

    @Override
    protected void onChannelPropertiesSet(WtcStack stack, WtcpControlHeader controlHeader, int channelId, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onChannelPropertiesSet(stack, " + controlHeader + ", " + channelId + ", " + errorCode + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        this.channelManager.onChannelPropertiesSet(this, this.listener, controlHeader, channelId, errorCode);
    }

    public Integer endpointPropertiesSet(WtcpKeyValueList keyValues) {
        WtcStack stack = this.stack;
        return stack == null ? null : stack.sendEndpointPropertiesSet(keyValues);
    }

    @Override
    protected void onEndpointPropertiesSet(WtcStack stack, WtcpControlHeader controlHeader, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onEndpointPropertiesSet(stack, " + controlHeader + ", " + errorCode + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onEndpointPropertiesSet(this, controlHeader.getOpType(), controlHeader.transactionId, errorCode);
        }
    }

    public Integer endpointLookupChannel(int channelId, String searchString) {
        return this.endpointLookupChannel(channelId, 64, searchString);
    }

    public Integer endpointLookupChannel(int channelId, int flagsInclude, String searchString) {
        return this.endpointLookupChannel(channelId, flagsInclude, 0, searchString);
    }

    public Integer endpointLookupChannel(int channelId, int flagsInclude, int flagsExclude, String searchString) {
        return this.endpointLookupChannel(channelId, flagsInclude, flagsExclude, (byte)0, (short)0, searchString);
    }

    public Integer endpointLookupChannel(int channelId, int flagsInclude, int flagsExclude, byte pageSize, short pageNumber, String searchString) {
        WtcStack stack = this.stack;
        return stack == null ? null : stack.sendEndpointLookup(WtcInt32.valueOf(channelId, true), WtcInt32.valueOf(flagsInclude, false), WtcInt32.valueOf(flagsExclude, false), new WtcInt8(pageSize), new WtcInt16(pageNumber), searchString);
    }

    public Integer endpointLookupSystem(String searchString) {
        return this.endpointLookupChannel(0, searchString);
    }

    public Integer endpointLookupSystem(int flagsInclude, String searchString) {
        return this.endpointLookupChannel(0, flagsInclude, searchString);
    }

    public Integer endpointLookupSystem(int flagsInclude, int flagsExclude, String searchString) {
        return this.endpointLookupChannel(0, flagsInclude, flagsExclude, searchString);
    }

    public Integer endpointLookupSystem(int flagsInclude, int flagsExclude, byte pageSize, short pageNumber, String searchString) {
        return this.endpointLookupChannel(0, flagsInclude, flagsExclude, pageSize, pageNumber, searchString);
    }

    @Override
    protected void onEndpointLookup(WtcStack stack, WtcpControlHeader controlHeader, int channelId, short pageNumber, short numberOfPages, WtcpEndpointInfoList endpoints) {
        WtcLog.debug(TAG, "onEndpointLookup(stack, " + controlHeader + ", " + channelId + ", " + pageNumber + ", " + numberOfPages + ", " + endpoints + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onEndpointLookup(this, controlHeader.getOpType(), controlHeader.transactionId, channelId, pageNumber, numberOfPages, endpoints);
        }
    }

    @Override
    protected void onEndpointLookup(WtcStack stack, WtcpControlHeader controlHeader, int channelId, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onEndpointLookup(stack, " + controlHeader + ", " + errorCode + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onEndpointLookupError(this, controlHeader.getOpType(), controlHeader.transactionId, channelId, errorCode);
        }
    }

    public Integer endpointPropertiesGet(String endpointId, String[] keys) {
        WtcStack stack = this.stack;
        return stack == null ? null : stack.sendEndpointPropertiesGet(endpointId, keys);
    }

    public Integer endpointPropertiesGet(String endpointId, WtcpStringList keys) {
        WtcStack stack = this.stack;
        return stack == null ? null : stack.sendEndpointPropertiesGet(endpointId, keys);
    }

    @Override
    protected void onEndpointPropertiesGet(WtcStack stack, WtcpControlHeader controlHeader, WtcpEndpointProperties keyValues) {
        WtcLog.debug(TAG, "onEndpointPropertiesGet(stack, " + controlHeader + ", " + keyValues + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onEndpointPropertiesGet(this, controlHeader.getOpType(), controlHeader.transactionId, keyValues);
        }
    }

    @Override
    protected void onEndpointPropertiesGet(WtcStack stack, WtcpControlHeader controlHeader, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onEndpointPropertiesGet(stack, " + controlHeader + ", " + errorCode + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onEndpointPropertiesGetError(this, controlHeader.getOpType(), controlHeader.transactionId, errorCode);
        }
    }

    public Integer endpointPropertyFilterSet(String filter) {
        WtcStack stack = this.stack;
        return stack == null ? null : stack.sendEndpointPropertyFilterSet(1, filter);
    }

    @Override
    protected void onEndpointPropertyFilterSet(WtcStack stack, WtcpControlHeader controlHeader, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onEndpointPropertyFilterSet(stack, " + controlHeader + ", " + errorCode + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onEndpointPropertyFilterSet(this, controlHeader.getOpType(), controlHeader.transactionId, errorCode);
        }
    }

    @Override
    public short onPingRequestRxTimeout(WtcStack stack, long timeoutMs, long elapsedMs, short lastPingRequestTxId) {
        WtcLog.debug(TAG, "onPingRequestRxTimeout(stack, timeoutMs=" + timeoutMs + ", elapsedMs=" + elapsedMs + ", lastPingRequestTxId=" + lastPingRequestTxId + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return -1;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            lastPingRequestTxId = listener.onPingRequestRxTimeout(this, timeoutMs, elapsedMs, lastPingRequestTxId);
        }
        return lastPingRequestTxId;
    }

    @Override
    protected void onPing(WtcStack stack, WtcpControlHeader controlHeader, short pingId) {
        WtcLog.debug(TAG, "onPing(stack, " + controlHeader + ", " + pingId + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onPing(this, controlHeader.getOpType(), controlHeader.transactionId, pingId);
        }
    }

    public Integer phoneLinesSetActive(String[] phoneLines) {
        WtcClientPhoneLineManager phoneLineManager = this.phoneLineManager;
        return phoneLineManager == null ? null : phoneLineManager.activate(phoneLines);
    }

    public Integer phoneLinesSetActive(WtcpStringList phoneLines) {
        WtcClientPhoneLineManager phoneLineManager = this.phoneLineManager;
        return phoneLineManager == null ? null : phoneLineManager.activate(phoneLines);
    }

    @Override
    protected void onPhoneLinesSetActive(WtcStack stack, WtcpControlHeader controlHeader, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onPhoneLinesSetActive(stack, " + controlHeader + ", errorCode=" + errorCode + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientPhoneLineManager phoneLineManager = this.phoneLineManager;
        if (phoneLineManager != null) {
            phoneLineManager.onPhoneLinesSetActive(controlHeader, errorCode);
        }
    }

    @Override
    protected void onPhoneLineStatus(WtcStack stack, WtcpControlHeader controlHeader, String phoneLine, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onPhoneLineStatus(stack, " + controlHeader + ", " + WtcString.quote(phoneLine) + ", " + errorCode + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientPhoneLineManager phoneLineManager = this.phoneLineManager;
        if (phoneLineManager != null) {
            phoneLineManager.onPhoneLineStatus(controlHeader, phoneLine, errorCode);
        }
    }

    public Integer callMake(byte callType, String source, String destination, String destinationName) {
        WtcClientPhoneLineManager phoneLineManager = this.phoneLineManager;
        return phoneLineManager == null ? null : this.phoneCallManager.call(callType, source, destination, destinationName);
    }

    @Override
    protected void onCallMake(WtcStack stack, WtcpControlHeader controlHeader, WtcpCallInfo callInfo) {
        WtcLog.debug(TAG, "onCallMake(stack, " + controlHeader + ", " + callInfo + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientPhoneCallManager phoneCallManager = this.phoneCallManager;
        if (phoneCallManager != null) {
            phoneCallManager.onCallMake(controlHeader, callInfo);
        }
    }

    @Override
    protected void onCallProgress(WtcStack stack, WtcpControlHeader controlHeader, WtcpCallProgress callProgress) {
        WtcLog.debug(TAG, "onCallProgress(stack, " + controlHeader + ", " + callProgress + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientPhoneCallManager phoneCallManager = this.phoneCallManager;
        if (phoneCallManager != null) {
            phoneCallManager.onCallProgress(controlHeader, callProgress);
        }
    }

    @Override
    protected void onCallOffer(WtcStack stack, WtcpControlHeader controlHeader, WtcpCallOffer callOffer) {
        WtcLog.debug(TAG, "onCallOffer(stack, " + controlHeader + ", " + callOffer + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientPhoneCallManager phoneCallManager = this.phoneCallManager;
        if (phoneCallManager != null) {
            phoneCallManager.onCallOffer(controlHeader, callOffer);
        }
    }

    public Integer callAnswer(int callId) {
        WtcClientPhoneLineManager phoneLineManager = this.phoneLineManager;
        return phoneLineManager == null ? null : this.phoneCallManager.answer(callId);
    }

    @Override
    protected void onCallAnswer(WtcStack stack, WtcpControlHeader controlHeader, WtcpCallAnswer callAnswer) {
        WtcLog.debug(TAG, "onCallAnswer(stack, " + controlHeader + ", " + callAnswer + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientPhoneCallManager phoneCallManager = this.phoneCallManager;
        if (phoneCallManager != null) {
            phoneCallManager.onCallAnswer(controlHeader, callAnswer);
        }
    }

    public Integer callHangup(int callId) {
        WtcClientPhoneLineManager phoneLineManager = this.phoneLineManager;
        return phoneLineManager == null ? null : this.phoneCallManager.hangup(callId);
    }

    @Override
    protected void onCallHangup(WtcStack stack, WtcpControlHeader controlHeader, WtcpCallHangup callHangup) {
        WtcLog.debug(TAG, "onCallHangup(stack, " + controlHeader + ", " + callHangup + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientPhoneCallManager phoneCallManager = this.phoneCallManager;
        if (phoneCallManager != null) {
            phoneCallManager.onCallHangup(controlHeader, callHangup);
        }
    }

    public Integer callDtmf(int callId, String digits) {
        WtcClientPhoneLineManager phoneLineManager = this.phoneLineManager;
        return phoneLineManager == null ? null : this.phoneCallManager.dtmf(callId, digits);
    }

    @Override
    protected void onCallDtmf(WtcStack stack, WtcpControlHeader controlHeader) {
        WtcLog.debug(TAG, "onCallDtmf(stack, " + controlHeader + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientPhoneCallManager phoneCallManager = this.phoneCallManager;
        if (phoneCallManager != null) {
            phoneCallManager.onCallDtmf(controlHeader, (WtcpErrorCode)null);
        }
    }

    @Override
    protected void onCallDtmf(WtcStack stack, WtcpControlHeader controlHeader, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onCallDtmf(stack, " + controlHeader + ", " + errorCode + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientPhoneCallManager phoneCallManager = this.phoneCallManager;
        if (phoneCallManager != null) {
            phoneCallManager.onCallDtmf(controlHeader, errorCode);
        }
    }

    @Override
    protected void onCallDtmf(WtcStack stack, WtcpControlHeader controlHeader, WtcpCallDtmf callDtmf) {
        WtcLog.debug(TAG, "onCallDtmf(stack, " + controlHeader + ", " + callDtmf + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientPhoneCallManager phoneCallManager = this.phoneCallManager;
        if (phoneCallManager != null) {
            phoneCallManager.onCallDtmf(controlHeader, callDtmf);
        }
    }

    public Integer callPushToTalk(int callId, boolean on) {
        WtcClientPhoneLineManager phoneLineManager = this.phoneLineManager;
        return phoneLineManager == null ? null : this.phoneCallManager.pushToTalk(callId, on);
    }

    @Override
    protected void onCallPushToTalkOn(WtcStack stack, WtcpControlHeader controlHeader, WtcInt32 callId, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onCallPushToTalkOn(stack, " + controlHeader + ", " + callId + ", " + errorCode + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientPhoneCallManager phoneCallManager = this.phoneCallManager;
        if (phoneCallManager != null) {
            phoneCallManager.onCallPushToTalkOn(controlHeader, callId, errorCode);
        }
    }

    @Override
    protected void onCallPushToTalkOff(WtcStack stack, WtcpControlHeader controlHeader, WtcInt32 callId, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onCallPushToTalkOff(stack, " + controlHeader + ", " + callId + ", " + errorCode + ")");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientPhoneCallManager phoneCallManager = this.phoneCallManager;
        if (phoneCallManager != null) {
            phoneCallManager.onCallPushToTalkOff(controlHeader, callId, errorCode);
        }
    }

    public Integer getAddressBook(short version, String filter) {
        WtcStack stack = this.stack;
        return stack == null ? null : stack.sendAddressBookRequest(version, filter);
    }

    @Override
    protected void onAddressBook(WtcStack stack, WtcpControlHeader controlHeader, WtcInt16 version, WtcpErrorCode errorCode, WtcpAddressBookInfoList addressBookInfoList) {
        WtcLog.debug(TAG, "onAddressBook(stack, " + controlHeader + ", " + version + ", " + errorCode + ", addressBookInfoList(" + addressBookInfoList.size() + ")=...)");
        if (stack != this.stack) {
            WtcLog.warn(TAG, "Got event for non-current stack; ignoring");
            return;
        }
        WtcClientListener listener = this.listener;
        if (listener != null) {
            listener.onAddressBook(this, 2, -1, version, errorCode, addressBookInfoList);
        }
    }

    static {
        PLATFORM_DESCRIPTION_DEFAULT = TAG = WtcLog.TAG(WtcClient.class);
    }
}

