package com.twistpair.wave.thinclient.util;

import android.util.SparseArray;

public class WtcInt32CachePlatform
{
    private WtcInt32CachePlatform()
    {
    }

    private static final SparseArray<WtcInt32> cache = new SparseArray<WtcInt32>();

    static WtcInt32 valueOf(int value)
    {
        synchronized (cache)
        {
            WtcInt32 result = (WtcInt32) cache.get(value);
            if (result == null)
            {
                result = new WtcInt32(value);
                cache.put(value, result);
            }
            return result;
        }
    }

    static void clear()
    {
        synchronized (cache)
        {
            cache.clear();
        }
    }
}
