package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcComparatorPlatform;

//
// BEGIN WtcpProfileInfo
//
public class WtcpProfileInfo //
                implements IWtcpReceivable
{
    public static final WtcComparatorPlatform COMPARATOR = new WtcComparatorPlatform()
                                                         {
                                                             //@Override
                                                             public int compare(Object a, Object b)
                                                             {
                                                                 return ((WtcpProfileInfo) a).name.compareTo(((WtcpProfileInfo) b).name);
                                                             }
                                                         };

    public String                             id;
    public String                             name;

    public WtcpProfileInfo(String id, String name)
    {
        this.id = id;
        this.name = name;
    }

    public WtcpProfileInfo(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        id = inputStream.readString();
        name = inputStream.readString();
    }

    public String toString()
    {
        //return "(id=" + WtcString.quote(id) + ", name=" + WtcString.quote(name) + ")";
        return name;
    }
}
//
// END WtcpProfileInfo
//
