package com.twistpair.wave.thinclient.protocol.types;

import java.util.Enumeration;
import java.util.Vector;

//
// BEGIN WtcpList
//
public class WtcpList
{
    public static final byte[] EMPTY = new byte[]
                                     {
        0, 0
                                     };

    public static boolean isNullOrEmpty(WtcpList o)
    {
        return o == null || o.size() == 0;
    }

    protected final Class  type;
    protected final Vector vector = new Vector();

    protected WtcpList(Class type)
    {
        super();
        if (type == null)
        {
            throw new IllegalArgumentException("type cannot by null");
        }
        this.type = type;
    }

    protected WtcpList(Class type, Object[] values)
    {
        this(type);
        addElements(values);
    }

    protected WtcpList(Class type, Vector values)
    {
        this(type);
        addElements(values);
    }

    protected WtcpList(Class type, WtcpList other)
    {
        this(type);
        addElements(other);
    }

    public void removeAllElements()
    {
        vector.removeAllElements();
    }

    public int size()
    {
        return vector.size();
    }

    public boolean isEmpty()
    {
        return vector.isEmpty();
    }

    public Enumeration elements()
    {
        return vector.elements();
    }

    public boolean contains(Object value)
    {
        return vector.contains(value);
    }

    public void addElement(Object value)
    {
        if (value == null || (value.getClass() != type))
        {
            throw new IllegalArgumentException("value must be of type " + type);
        }
        vector.addElement(value);
    }

    public Object elementAt(int location)
    {
        return vector.elementAt(location);
    }

    public boolean removeElement(Object value)
    {
        if (value == null || (value.getClass() != type))
        {
            throw new IllegalArgumentException("value must be of type " + type);
        }
        return vector.removeElement(value);
    }

    public void setElements(WtcpList other)
    {
        vector.removeAllElements();
        addElements(other);
    }

    public void addElements(Object[] values)
    {
        if (values != null)
        {
            for (int i = 0; i < values.length; i++)
            {
                addElement(values[i]);
            }
        }
    }

    public void addElements(Vector values)
    {
        if (values != null)
        {
            addElements(values.elements());
        }
    }

    public void addElements(WtcpList other)
    {
        if (other != null)
        {
            addElements(other.elements());
        }
    }

    public void addElements(Enumeration enumeration)
    {
        if (enumeration != null)
        {
            while (enumeration.hasMoreElements())
            {
                // Need to copy? What if other is later cleared?
                addElement(enumeration.nextElement());
            }
        }
    }

    public boolean removeElements(WtcpList other)
    {
        boolean found = false;
        if (other != null)
        {
            Enumeration items = other.elements();
            while (items.hasMoreElements())
            {
                found |= removeElement(items.nextElement());
            }
        }
        return found;
    }

    public String toString()
    {
        return vector.toString();
    }
}
//
// END WtcpList
//
