package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcComparatorPlatform;

//
// BEGIN WtcpChannelInfo
//
public class WtcpChannelInfo //
                implements IWtcpReceivable
{
    public static WtcComparatorPlatform COMPARATOR = new WtcComparatorPlatform()
                                                   {
                                                       //@Override
                                                       public int compare(Object a, Object b)
                                                       {
                                                           return ((WtcpChannelInfo) a).name.compareTo(((WtcpChannelInfo) b).name);
                                                       }
                                                   };

    public int                          id;

    /**
     * Any combo of WtcpChannelFlags
     */
    public int                          flags;

    public String                       name;

    public WtcpChannelInfo(int id, int flags, String name)
    {
        this.id = id;
        this.flags = flags;
        this.name = name;
    }

    public WtcpChannelInfo(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        id = inputStream.readInt32();
        flags = inputStream.readInt16();
        name = inputStream.readString();
    }

    public String toString()
    {
        /*
        StringBuffer sb = new StringBuffer();
        sb.append(name).append(" (Flags: ").append(flags).append(")");
        return sb.toString();
        */
        return name;
    }
}
//
// END WtcpChannelInfo
//
