package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.protocol.WtcpConstants.WtcpCallProgressState;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;

//
// BEGIN WtcpCallProgress
//
public class WtcpCallProgress //
                implements IWtcpReceivable
{
    public int callId;

    /**
     * One of WtcpCallProgressState
     */
    public int progress;

    public WtcpCallProgress(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        callId = inputStream.readInt32();
        progress = inputStream.readInt8();
    }

    public String toString()
    {
        return new StringBuffer() //
        .append('{') //
        .append("callId=").append(callId) //
        .append(", progress=").append(WtcpCallProgressState.toString(progress)) //
        .append('}') //
        .toString();
    }
}
//
// END WtcpCallProgress
//
