package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;

//
// BEGIN WtcpCallHangup
//
public class WtcpCallHangup //
                implements IWtcpReceivable
{
    public int           callId;
    public WtcpErrorCode errorCode;

    public WtcpCallHangup(int callId, WtcpErrorCode errorCode)
    {
        this.callId = callId;
        this.errorCode = errorCode;
    }

    public WtcpCallHangup(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        callId = inputStream.readInt32();
        errorCode = new WtcpErrorCode(inputStream);
    }

    public String toString()
    {
        return new StringBuffer() //
        .append('{') //
        .append("callId=").append(callId) //
        .append(", errorCode=").append(errorCode) //
        .append('}') //
        .toString();
    }
}
//
// END WtcpCallHangup
//
