package com.twistpair.wave.thinclient.protocol.types;

import java.util.Enumeration;
import java.util.Random;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;

public class WtcpAddressBookInfoList //
                extends WtcpList //
                implements IWtcpReceivable
{
    public static final short                   VERSION = (short) 1;

    public static final WtcpAddressBookInfoList FAKE;

    private static String randomName(Random rand, int lengthFirst, int lengthLast)
    {
        final String data = "qwertyuiopasdfghjklzxcvbnm";
        final int dataLength = data.length();

        StringBuffer sb = new StringBuffer(lengthFirst + 1 + lengthLast);

        sb.append(String.valueOf(data.charAt(rand.nextInt(dataLength))).toUpperCase());
        for (int i = 1; i < lengthFirst; i++)
        {
            sb.append(data.charAt(rand.nextInt(dataLength)));
        }
        sb.append(' ');
        sb.append(String.valueOf(data.charAt(rand.nextInt(dataLength))).toUpperCase());
        for (int i = 1; i < lengthLast; i++)
        {
            sb.append(data.charAt(rand.nextInt(dataLength)));
        }

        String name = sb.toString();
        return name;
    }

    static
    {
        FAKE = new WtcpAddressBookInfoList();

        Random rand = new Random();
        for (int i = 0; i < 300; i++)
        {
            String id = String.valueOf(i);
            int lengthFirst = 4 + rand.nextInt(3) - rand.nextInt(2);
            int lengthLast = 6 + rand.nextInt(4) - rand.nextInt(3);
            String name = randomName(rand, lengthFirst, lengthLast).trim();
            String type = String.valueOf(rand.nextInt(4));
            String phoneNumber = "555-222-" + String.valueOf(1000 + i);
            FAKE.addElement(new WtcpAddressBookInfo(id, name, type, phoneNumber));
        }
    }

    public WtcpAddressBookInfoList()
    {
        super(WtcpAddressBookInfo.class);
    }

    public WtcpAddressBookInfoList(IWtcMemoryStream inputStream)
    {
        this();
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        short count = inputStream.readInt16();
        WtcpAddressBookInfo addressBookInfo;
        for (int i = 0; i < count; i++)
        {
            addressBookInfo = new WtcpAddressBookInfo(inputStream);
            addElement(addressBookInfo);
        }
    }

    public String toString()
    {
        Enumeration elements = elements();
        WtcpAddressBookInfo element;

        StringBuffer sb = new StringBuffer();
        sb.append('[');
        while (elements.hasMoreElements())
        {
            element = (WtcpAddressBookInfo) elements.nextElement();
            sb.append(element);
            if (elements.hasMoreElements())
            {
                sb.append(',');
            }
        }
        sb.append(']');
        return sb.toString();
    }
}
