package com.twistpair.wave.thinclient.net;

import java.io.IOException;
import java.net.Socket;

import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.net.WtcNetworkExceptionPlatform.WtcNetworkUnknownHostException;
import com.twistpair.wave.thinclient.net.WtcNetworkExceptionPlatform.WtcNetworkUnreachableException;

public class WtcSocketPlatform extends Socket implements WtcSocket
{
    private static final String          TAG           = WtcLog.TAG(WtcSocketPlatform.class);

    private WtcInetSocketAddressPlatform remoteAddress = null;

    public void close() throws IOException
    {
        //remoteAddress = null;
        super.close();
    }

    public void connect(WtcInetSocketAddressPlatform remoteAddress, int timeoutMs) throws IOException
    {
        connect(remoteAddress, timeoutMs, null);
    }

    public void connect(WtcInetSocketAddressPlatform remoteAddress, int timeoutMs, WtcInetSocketAddressPlatform localAddress) //
                    throws IOException
    {
        try
        {
            if (localAddress != null)
            {
                try
                {
                    WtcLog.debug(TAG, "+bind(" + localAddress + ")");
                    super.bind(localAddress);
                    WtcLog.debug(TAG, "-bind(" + localAddress + ")");
                }
                catch (IOException e)
                {
                    WtcLog.error(TAG, "-bind(" + localAddress + ")", e);
                    throw e;
                }
            }
            super.connect(remoteAddress, timeoutMs);
            this.remoteAddress = remoteAddress;
        }
        catch (IOException e)
        {
            if (WtcNetworkExceptionPlatform.isUnreachable(e))
            {
                e = new WtcNetworkUnreachableException(remoteAddress, e);
            }
            else if (WtcNetworkExceptionPlatform.isUnknownHostException(e))
            {
                e = new WtcNetworkUnknownHostException(remoteAddress, e);
            }
            throw e;
        }
    }

    public WtcInetSocketAddressPlatform getRemoteAddress()
    {
        return remoteAddress;
    }

    public void shutdown()
    {
        try
        {
            super.shutdownInput();
        }
        catch (IOException e)
        {
            if (e.getMessage().toLowerCase().contains("transport endpoint is not connected"))
            {
                WtcLog.warn(TAG, "shutdownInput(); // ignore: " + e.toString());
            }
            else
            {
                WtcLog.error(TAG, "shutdownInput(); // ignore", e);
            }
        }

        try
        {
            super.shutdownOutput();
        }
        catch (IOException e)
        {
            if (e.getMessage().toLowerCase().contains("transport endpoint is not connected"))
            {
                WtcLog.warn(TAG, "shutdownOutput(); // ignore: " + e.toString());
            }
            else
            {
                WtcLog.error(TAG, "shutdownOutput(); // ignore", e);
            }
        }
    }
}
