package com.twistpair.wave.thinclient.media;

import com.twistpair.wave.thinclient.protocol.WtcpConstants.WtcpAudioCodec;

public abstract class WtcMediaDeviceFactory
{
    protected byte          mAudioCodecId;
    protected WtcMediaCodec mAudioCodec;

    public WtcMediaDeviceFactory()
    {
        this(WtcpAudioCodec.PCM_Mono16bBigEndian8kHz);
    }

    /**
     * @param audioCodecId one of WtcpAudioCodec.*
     * @throws IllegalArgumentException if audioCodec is not supported
     */
    public WtcMediaDeviceFactory(byte audioCodecId) //
                    throws IllegalArgumentException
    {
        setAudioCodec(audioCodecId);
    }

    public byte getAudioCodec()
    {
        return mAudioCodecId;
    }

    /**
     * @param audioCodecId one of WtcpAudioCodec.*;
     * @throws IllegalArgumentException if audioCodec is not supported
     */
    public abstract void setAudioCodec(byte audioCodecId) //
                    throws IllegalArgumentException;

    public WtcMediaDeviceMicrophone createMicrophone()
    {
        return new WtcMediaDeviceMicrophonePlatform(mAudioCodec);
    }

    public WtcMediaDeviceSpeaker createSpeaker()
    {
        return new WtcMediaDeviceSpeakerPlatform(mAudioCodec);
    }
}
