package com.twistpair.wave.thinclient.media;

public abstract class WtcMediaCodec
{
    public abstract String getName();

    public abstract int getSampleRate();

    public abstract int getMillisecondsPerFrame();

    public abstract int getBytesPerFrame();

    public int getByteCountForDuration(int milliseconds, int minBuffSize)
    {
        int bytesPerFrame = getBytesPerFrame();
        int byteCountForDuration = (milliseconds / getMillisecondsPerFrame()) * bytesPerFrame;

        if (byteCountForDuration < (minBuffSize / 2))
        {
            // return the min buffersize specified by the Recorder, adjusted for frame size
            int imod = minBuffSize % bytesPerFrame;
            byteCountForDuration = ((minBuffSize / bytesPerFrame) * bytesPerFrame) + (imod > 0 ? bytesPerFrame : 0);
        }

        return byteCountForDuration;
    }

    /**
     * Initilize the codec, if required.
     * @return true if success
     */
    protected abstract boolean initialize();

    /**
     * Close and free any buffers used
     */
    public abstract void close();

    /**
     * Decodes the given encoded buffer.
     * @param bufferEncoded
     * @param length
     * @param bufferUnencoded
     * @return number of bytes written to bufferDecoded
     */
    public abstract int decode(byte[] bufferEncoded, int length, short[] bufferUnencoded);

    /**
     * Encodes the given buffer.
     * @param bufferUnencoded
     * @param offset
     * @param length
     * @param bufferEncoded
     * @return number of bytes written to bufferEncoded
     */
    public abstract int encode(short[] bufferUnencoded, int offset, int length, byte[] bufferEncoded);
}
