package com.twistpair.wave.thinclient.kexcrypto;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;

import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

import com.twistpair.wave.thinclient.kexcrypto.WtcKexCryptoBase.IWtcDhKeyPair;
import com.twistpair.wave.thinclient.kexcrypto.WtcKexCryptoBase.WtcKexCryptoException;

//
// BEGIN WtcDhKeyPairPlatform
//
public class WtcDhKeyPairPlatform //
                implements IWtcDhKeyPair
{
    //private static final String   TAG            = WtcLog.TAG(WtcDhKeyPairPlatform.class);

    protected static final String DIFFIE_HELLMAN = "DH";

    private final DHPrivateKey    dhLocalPrivateKey;
    private final DHPublicKey     dhLocalPublicKey;

    public WtcDhKeyPairPlatform(byte[] P, byte[] G) //
                    throws WtcKexCryptoException
    {
        try
        {
            KeyPairGenerator dhkpg = KeyPairGenerator.getInstance(DIFFIE_HELLMAN);
            DHParameterSpec dhps = new DHParameterSpec(new BigInteger(1, P), new BigInteger(1, G));
            dhkpg.initialize(dhps);

            // NOTE: This method blocks while computing the crypto big numbers...
            KeyPair dhkp = dhkpg.generateKeyPair();

            dhLocalPrivateKey = (DHPrivateKey) dhkp.getPrivate(); // private key
            dhLocalPublicKey = (DHPublicKey) dhkp.getPublic(); // computed (G^dhLocalPrivateKey) % P
        }
        catch (Exception e)
        {
            throw new WtcKexCryptoException("new WtcDhKeyPairPlatform(...)", e);
        }
    }

    public byte[] getDHPublicKeyBytes() //
    {
        return dhLocalPublicKey.getY().toByteArray();
    }

    public byte[] calculateAgreement(byte[] remotePublicKey) //
                    throws WtcKexCryptoException
    {
        BigInteger y = new BigInteger(1, remotePublicKey);

        KeyFactory dhKeyFactory;
        try
        {
            dhKeyFactory = KeyFactory.getInstance(DIFFIE_HELLMAN);
        }
        catch (NoSuchAlgorithmException e)
        {
            throw new WtcKexCryptoException("WtcDhKeyPairPlatform.calculateAgreement(...)", e);
        }

        DHParameterSpec dhParameterSpec = dhLocalPrivateKey.getParams();
        BigInteger p = dhParameterSpec.getP();
        BigInteger g = dhParameterSpec.getG();

        DHPublicKeySpec dhRemotePublicKeySpec = new DHPublicKeySpec(y, p, g);
        DHPublicKey dhRemotePublicKey;
        try
        {
            dhRemotePublicKey = (DHPublicKey) dhKeyFactory.generatePublic(dhRemotePublicKeySpec);
        }
        catch (InvalidKeySpecException e)
        {
            throw new WtcKexCryptoException("WtcDhKeyPairPlatform.calculateAgreement(...)", e);
        }

        KeyAgreement dhKeyAgreement;
        try
        {
            dhKeyAgreement = KeyAgreement.getInstance(DIFFIE_HELLMAN);
        }
        catch (NoSuchAlgorithmException e)
        {
            throw new WtcKexCryptoException("WtcDhKeyPairPlatform.calculateAgreement(...)", e);
        }
        try
        {
            dhKeyAgreement.init(dhLocalPrivateKey);
            dhKeyAgreement.doPhase(dhRemotePublicKey, true);
        }
        catch (InvalidKeyException e)
        {
            throw new WtcKexCryptoException("WtcDhKeyPairPlatform.calculateAgreement(...)", e);
        }
        catch (IllegalStateException e)
        {
            throw new WtcKexCryptoException("WtcDhKeyPairPlatform.calculateAgreement(...)", e);
        }

        return dhKeyAgreement.generateSecret();
    }
}
//
// END WtcDhKeyPairPlatform
//
