package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.protocol.WtcpConstants.WtcpCallType;
import com.twistpair.wave.thinclient.util.WtcString;

public class WtcClientPhoneLine
{
    private static final String             TAG = WtcLog.TAG(WtcClientPhoneLine.class);

    private final WtcStack                  mStack;
    private final WtcClientPhoneLineManager mLineManager;

    private final String                    mNumber;

    protected boolean                       mIsActivated;

    private WtcClientPhoneCall              mPhoneCall;

    protected WtcClientPhoneLine(WtcStack stack, //
                    WtcClientPhoneLineManager lineManager, //
                    String number)
    {
        if (stack == null)
        {
            throw new IllegalArgumentException("stack cannot be null");
        }

        if (lineManager == null)
        {
            throw new IllegalArgumentException("lineManager cannot be null");
        }

        if (WtcString.isNullOrEmpty(number))
        {
            throw new IllegalArgumentException("number cannot be null/\"\"");
        }

        mStack = stack;
        mLineManager = lineManager;

        mNumber = number;
    }

    public String toString()
    {
        StringBuffer sb = new StringBuffer() //
        .append('{') //
        .append("number=").append(WtcString.quote(mNumber)) //
        .append(", activated=").append(mIsActivated) //
        .append('}');
        return sb.toString();
    }

    /**
     * @return never null
     */
    protected WtcStack getStack()
    {
        return mStack;
    }

    /**
     * @return never null/""
     */
    public String getNumber()
    {
        return mNumber;
    }

    public boolean getIsActivated()
    {
        return mIsActivated;
    }

    /**
     * @return The phone call currently on this line, or null if there is none
     */
    public WtcClientPhoneCall getPhoneCall()
    {
        return mPhoneCall;
    }

    protected void setPhoneCall(WtcClientPhoneCall phoneCall)
    {
        mPhoneCall = phoneCall;
    }

    /**
     * @param on
     * @return transactionId if the Request was successfully placed in the queue, otherwise null
     */
    public Integer activate(boolean on)
    {
        return mLineManager.activate(this, on);
    }

    /**
     * @param remoteEndpointId
     * @param remoteName
     * @return transactionId if the Request was successfully placed in the queue, otherwise null
     */
    public Integer callEndpoint(String remoteEndpointId, String remoteName)
    {
        return call(WtcpCallType.Endpoint, remoteEndpointId, remoteName);
    }

    /**
     * @param remoteNumber
     * @param remoteName
     * @return transactionId if the Request was successfully placed in the queue, otherwise null
     */
    public Integer callNumber(String remoteNumber, String remoteName)
    {
        return call(WtcpCallType.E164, remoteNumber, remoteName);
    }

    /**
     * @param callType One of WtcpCallType.*
     * @param remoteNumberOrEndpointId Remote phone number or endpoint id (depending on callType)
     * @param remoteName
     * @return transactionId if the Request was successfully placed in the queue, otherwise null
     */
    protected Integer call(byte callType, String remoteNumberOrEndpointId, String remoteName)
    {
        WtcClientPhoneCallManager callManager = mLineManager.getPhoneCallManager();
        return (callManager == null) ? null : callManager.call(this, callType, remoteNumberOrEndpointId, remoteName);
    }
}
