/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import androidx.annotation.NonNull;
import com.twilio.voice.AudioCodec;

public class OpusCodec
extends AudioCodec {
    @NonNull
    public static final String NAME = "opus";
    static int DEFAULT_BITRATE = 0;
    static int MIN_BITRATE = 6000;
    static int MAX_BITRATE = 510000;
    private int maxAverageBitrate = DEFAULT_BITRATE;
    private boolean useDtx = false;

    public OpusCodec() {
        super(NAME);
    }

    public OpusCodec(int maxAverageBitrate) {
        super(NAME);
        if (maxAverageBitrate >= MIN_BITRATE && maxAverageBitrate <= MAX_BITRATE) {
            this.maxAverageBitrate = maxAverageBitrate;
        }
    }

    OpusCodec(int maxAverageBitrate, boolean useDtx) {
        super(NAME);
        if (maxAverageBitrate >= MIN_BITRATE && maxAverageBitrate <= MAX_BITRATE) {
            this.maxAverageBitrate = maxAverageBitrate;
        }
        this.useDtx = useDtx;
    }

    public int getMaxAverageBitrate() {
        return this.maxAverageBitrate;
    }

    boolean isDtxEnabled() {
        return this.useDtx;
    }
}

