/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.annotation.SuppressLint;
import android.util.Pair;
import com.twilio.voice.Call;
import com.twilio.voice.Constants;
import com.twilio.voice.Voice;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONObject;

class EventPayload {
    private static final String INSIGHTS_SDK_VERSION = "com.twilio.voice.env.sdk.version";
    boolean isPrivate = false;
    private String timeStamp;
    private String productName;
    private String callSid;
    private String messageSid;
    private String payloadType;
    private long timestampMS;
    private JSONObject payload;
    private String clientName;
    private Constants.Direction direction;
    private String value;
    private String values;
    private Pair<String, Class> qualityThresholdValuePair;
    private String tempCallSid;
    private int qualityScore;
    private String issueName;
    private Long errorCode;
    private String errorMessage;
    private String requestId;
    private String selectedRegion;
    private String gateway;
    private String region;
    private String codecParams;
    private String selectedCodec;
    private String transportId;
    private Boolean isRemote;
    private String ip;
    private Long port;
    private String protocol;
    private String candidateType;
    private Long priority;
    private String url;
    private Boolean deleted;
    private Long networkCost;
    private Long networkId;
    private Long relatedPort;
    private String level;
    private String relatedAddress;
    private String networkType;
    private String name;
    private String tcpType;
    private JSONObject localCandidate;
    private JSONObject remoteCandidate;
    private Long lastDataReceivedMs;
    private String reason;
    private Constants.LoggerType loggerType;
    private Constants.CallMessageEventType eventType;
    private String voiceEventSid;

    private EventPayload(Builder builder) {
        this.productName = builder.productName;
        this.payload = builder.payload;
        this.payloadType = builder.payloadType;
        this.timeStamp = builder.timeStamp;
        this.timestampMS = builder.timestampMS;
        this.clientName = builder.clientName;
        this.direction = builder.direction;
        this.callSid = builder.callSid;
        this.messageSid = builder.messageSid;
        this.tempCallSid = builder.tempCallSid;
        this.qualityScore = builder.qualityScore;
        this.issueName = builder.issue;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.requestId = builder.requestId;
        this.selectedRegion = builder.selectedRegion;
        this.gateway = builder.gateway;
        this.region = builder.region;
        this.codecParams = builder.codecParams;
        this.selectedCodec = builder.selectedCodec;
        this.transportId = builder.transportId;
        this.isRemote = builder.isRemote;
        this.ip = builder.ip;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.candidateType = builder.candidateType;
        this.priority = builder.priority;
        this.url = builder.url;
        this.deleted = builder.deleted;
        this.networkCost = builder.networkCost;
        this.values = builder.values;
        this.value = builder.value;
        this.qualityThresholdValuePair = builder.qualityThresholdValuePair;
        this.networkId = builder.networkId;
        this.relatedPort = builder.relatedPort;
        this.level = builder.level;
        this.relatedAddress = builder.relatedAddress;
        this.networkType = builder.networkType;
        this.name = builder.name;
        this.tcpType = builder.tcpType;
        this.localCandidate = builder.localCandidate;
        this.remoteCandidate = builder.remoteCandidate;
        this.reason = builder.reason;
        this.lastDataReceivedMs = builder.lastDataReceivedMs;
        this.loggerType = builder.loggerType;
        this.eventType = builder.eventType;
        this.voiceEventSid = builder.voiceEventSid;
    }

    String getTimeStamp() {
        return this.timeStamp;
    }

    Object getPayloadType() {
        return this.payloadType;
    }

    String getProductName() {
        return this.productName;
    }

    boolean isPrivate() {
        return this.isPrivate;
    }

    String getCallSid() {
        return this.callSid;
    }

    long getTimestampMillis() {
        return this.timestampMS;
    }

    JSONObject getPayload() throws Exception {
        this.jsonPayloadPreparation();
        return this.payload;
    }

    String getClientName() {
        return this.clientName;
    }

    Constants.Direction getDirection() {
        return this.direction;
    }

    String getTempCallSid() {
        return this.tempCallSid;
    }

    int getQualityScore() {
        return this.qualityScore;
    }

    String getIssueName() {
        return this.issueName;
    }

    Constants.LoggerType getLogger() {
        return this.loggerType;
    }

    Constants.CallMessageEventType getEventType() {
        return this.eventType;
    }

    String getVoiceEventSid() {
        return this.voiceEventSid;
    }

    JSONObject jsonPayloadPreparation() throws Exception {
        JSONObject payload = new JSONObject();
        payload.put("timestamp_ms", this.timestampMS);
        payload.put("client_name", (Object)this.clientName);
        payload.put("temp_call_sid", (Object)this.tempCallSid);
        payload.put("call_sid", (Object)this.callSid);
        payload.put("message_sid", (Object)this.messageSid);
        payload.put("sdk_version", (Object)EventPayload.getSdkVersion());
        payload.put("platform", (Object)"android");
        payload.put("direction", (Object)this.direction);
        payload.put("selected_region", (Object)this.selectedRegion);
        payload.put("gateway", (Object)this.gateway);
        payload.put("region", (Object)this.region);
        payload.put("codec_params", (Object)this.codecParams);
        payload.put("selected_codec", (Object)this.selectedCodec);
        payload.put("transport_id", (Object)this.transportId);
        payload.put("is_remote", (Object)this.isRemote);
        payload.put("ip", (Object)this.ip);
        payload.put("port", (Object)this.port);
        payload.put("protocol", (Object)this.protocol);
        payload.put("candidate_type", (Object)this.candidateType);
        payload.put("priority", (Object)this.priority);
        payload.put("url", (Object)this.url);
        payload.put("deleted", (Object)this.deleted);
        payload.put("network-cost", (Object)this.networkCost);
        payload.put("network-id", (Object)this.networkId);
        payload.put("related_port", (Object)this.relatedPort);
        payload.put("level", (Object)this.level);
        payload.put("related_address", (Object)this.relatedAddress);
        payload.put("network-type", (Object)this.networkType);
        payload.put("name", (Object)this.name);
        payload.put("tcp_type", (Object)this.tcpType);
        payload.put("local_candidate", (Object)this.localCandidate);
        payload.put("remote_candidate", (Object)this.remoteCandidate);
        payload.put("reason", (Object)this.reason);
        payload.put("last_data_received_ms", (Object)this.lastDataReceivedMs);
        payload.put("logger_type", (Object)this.loggerType.name().toLowerCase(Locale.US));
        payload.put("voice_event_sid", (Object)this.voiceEventSid);
        if (this.errorCode != null && this.errorCode.compareTo(0L) > 0) {
            payload.put("code", (Object)this.errorCode);
            payload.put("message", (Object)this.errorMessage);
        }
        if (this.requestId != null) {
            payload.put("request_sid", (Object)this.requestId);
        }
        if (this.eventType != null) {
            payload.put("event_type", (Object)this.eventType.name().toLowerCase(Locale.US));
        }
        JSONObject data = new JSONObject();
        if (this.values != null) {
            data.put("threshold", EventPayload.fromStringThreshold(this.qualityThresholdValuePair));
            data.put("values", (Object)this.values);
        } else if (this.value != null) {
            data.put("threshold", EventPayload.fromStringThreshold(this.qualityThresholdValuePair));
            data.put("value", (Object)this.value);
        } else {
            if (this.qualityScore > 0) {
                payload.put("quality_score", this.qualityScore);
            }
            if (this.issueName != null && !this.issueName.equals(Call.Issue.NOT_REPORTED.toString())) {
                payload.put("issue_name", (Object)this.issueName);
            }
            data = null;
        }
        payload.put("data", (Object)data);
        this.payload = payload;
        return this.payload;
    }

    private static String getSdkVersion() {
        return System.getProperty(INSIGHTS_SDK_VERSION, Voice.getVersion());
    }

    static Object fromStringThreshold(Pair<String, Class> stringValuePair) {
        if (((Class)stringValuePair.second).equals(Float.class)) {
            Float object = Float.valueOf(Float.parseFloat((String)stringValuePair.first));
            Class<Float> reifiedType = Float.class;
            return reifiedType.cast(object);
        }
        if (((Class)stringValuePair.second).equals(Long.class)) {
            Long object = Long.parseLong((String)stringValuePair.first);
            Class<Long> reifiedType = Long.class;
            return reifiedType.cast(object);
        }
        Object object = stringValuePair.first;
        Class<String> reifiedType = String.class;
        return reifiedType.cast(object);
    }

    static class Builder {
        private String productName;
        private JSONObject payload;
        private String payloadType;
        private long timestampMS;
        private String timeStamp;
        private String callSid;
        private String messageSid;
        private String clientName;
        private Constants.Direction direction;
        private String values;
        private String value;
        private String qualityParam;
        private Pair<String, Class> qualityThresholdValuePair;
        private String tempCallSid;
        private int qualityScore;
        private String issue;
        private Long errorCode;
        private String errorMessage;
        private String requestId;
        private String selectedRegion;
        private String gateway;
        private String region;
        private String codecParams;
        private String selectedCodec;
        private String transportId;
        private Boolean isRemote;
        private String ip;
        private Long port;
        private String protocol;
        private String candidateType;
        private Long priority;
        private String url;
        private Boolean deleted;
        private Long networkCost;
        private Long networkId;
        private Long relatedPort;
        private String level;
        private String relatedAddress;
        private String networkType;
        private String name;
        private String tcpType;
        private JSONObject localCandidate;
        private JSONObject remoteCandidate;
        private Long lastDataReceivedMs;
        private String reason;
        private Constants.LoggerType loggerType;
        private Constants.CallMessageEventType eventType;
        private String voiceEventSid;

        @SuppressLint(value={"SimpleDateFormat"})
        Builder() {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            df.setTimeZone(tz);
            Date now = new Date();
            this.timeStamp = df.format(now);
            this.timestampMS = now.getTime();
            this.loggerType = Voice.loggerType;
        }

        Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        Builder payLoadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        Builder callSid(String callSid) {
            this.callSid = callSid;
            return this;
        }

        Builder messageSid(String messageSid) {
            this.messageSid = messageSid;
            return this;
        }

        Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        Builder direction(Constants.Direction direction) {
            this.direction = direction;
            return this;
        }

        Builder value(String value) {
            this.value = value;
            return this;
        }

        Builder values(String values) {
            this.values = values;
            return this;
        }

        Builder qualityThresholdValuePair(Pair<String, Class> qualityThresholdValuePair) {
            this.qualityThresholdValuePair = qualityThresholdValuePair;
            return this;
        }

        Builder tempCallSid(String tempCallSid) {
            this.tempCallSid = tempCallSid;
            return this;
        }

        Builder score(Call.Score score) {
            if (score != null) {
                this.qualityScore = score.getValue();
            }
            return this;
        }

        Builder issue(Call.Issue issue) {
            if (issue != null) {
                this.issue = issue.toString();
            }
            return this;
        }

        Builder errorCode(Long errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        Builder selectedRegion(String selectedRegion) {
            this.selectedRegion = selectedRegion;
            return this;
        }

        Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        Builder region(String region) {
            this.region = region;
            return this;
        }

        Builder codecParams(String codecParams) {
            this.codecParams = codecParams;
            return this;
        }

        Builder selectedCodec(String selectedCodec) {
            this.selectedCodec = selectedCodec;
            return this;
        }

        Builder transportId(String transportId) {
            this.transportId = transportId;
            return this;
        }

        Builder isRemote(Boolean isRemote) {
            this.isRemote = isRemote;
            return this;
        }

        Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        Builder port(Long port) {
            this.port = port;
            return this;
        }

        Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        Builder candidateType(String candidateType) {
            this.candidateType = candidateType;
            return this;
        }

        Builder priority(Long priority) {
            this.priority = priority;
            return this;
        }

        Builder url(String url) {
            this.url = url;
            return this;
        }

        Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        Builder networkCost(Long networkCost) {
            this.networkCost = networkCost;
            return this;
        }

        Builder networkId(Long networkId) {
            this.networkId = networkId;
            return this;
        }

        Builder relatedPort(Long relatedPort) {
            this.relatedPort = relatedPort;
            return this;
        }

        Builder level(String level) {
            this.level = level;
            return this;
        }

        Builder relatedAddress(String relatedAddress) {
            this.relatedAddress = relatedAddress;
            return this;
        }

        Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        Builder name(String name) {
            this.name = name;
            return this;
        }

        Builder tcpType(String tcpType) {
            this.tcpType = tcpType;
            return this;
        }

        Builder localCandidate(JSONObject localCandidate) {
            this.localCandidate = localCandidate;
            return this;
        }

        Builder remoteCandidate(JSONObject remoteCandidate) {
            this.remoteCandidate = remoteCandidate;
            return this;
        }

        Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        Builder lastDataReceivedMs(Long lastDataReceivedMs) {
            this.lastDataReceivedMs = lastDataReceivedMs;
            return this;
        }

        Builder loggerType(Constants.LoggerType loggerType) {
            this.loggerType = loggerType;
            return this;
        }

        Builder callMessageEventType(Constants.CallMessageEventType eventType) {
            this.eventType = eventType;
            return this;
        }

        Builder voiceEventSid(String voiceEventSid) {
            this.voiceEventSid = voiceEventSid;
            return this;
        }

        EventPayload build() {
            if (this.productName == null) {
                throw new NullPointerException("productName must not be null");
            }
            if (this.payloadType == null) {
                throw new NullPointerException("payloadType must not be null");
            }
            return new EventPayload(this);
        }
    }
}

